/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.pdf.PDF;
import com.caucho.quercus.lib.pdf.PDFFont;
import com.caucho.quercus.lib.pdf.PDFImage;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.logging.Logger;

public class PDFModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(PDFModule.class);
    private static final Logger log = Logger.getLogger(PDFModule.class.getName());

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"pdf"};
    }

    public static boolean pdf_activate_item(Env env, @NotNull PDF pdf, int id) {
        env.stub("pdf_activate_item");
        return false;
    }

    public static boolean pdf_add_annotation(Env env, @NotNull PDF pdf) {
        env.stub("pdf_add_annotation");
        return false;
    }

    public static boolean pdf_add_bookmark(Env env, @NotNull PDF pdf) {
        env.stub("pdf_add_bookmark");
        return false;
    }

    public static boolean pdf_add_launchlink(Env env, @NotNull PDF pdf, double llx, double lly, double urx, double ury, String filename) {
        env.stub("pdf_add_launchlink");
        return false;
    }

    public static boolean pdf_add_locallink(Env env, @NotNull PDF pdf, double llx, double lly, double urx, double ury, int page, String dest) {
        env.stub("pdf_add_locallink");
        return false;
    }

    public static boolean pdf_add_nameddest(Env env, @NotNull PDF pdf, String name, @Optional String optlist) {
        env.stub("pdf_add_nameddest");
        return false;
    }

    public static boolean pdf_add_note(Env env, @NotNull PDF pdf, double llx, double lly, double urx, double ury, String contents, String title, String icon, int open) {
        env.stub("pdf_add_note");
        return false;
    }

    public static boolean pdf_add_outline(Env env, @NotNull PDF pdf, String name, @Optional String optlist) {
        env.stub("pdf_add_outline");
        return false;
    }

    public static boolean pdf_add_pdflink(Env env, @NotNull PDF pdf, double llx, double lly, double urx, double ury, String filename, int page, String dest) {
        env.stub("pdf_add_pdflink");
        return false;
    }

    public static boolean pdf_add_thumbnail(Env env, @NotNull PDF pdf, @NotNull PDFImage image) {
        env.stub("pdf_add_thumbnail");
        return false;
    }

    public static boolean pdf_add_weblink(Env env, @NotNull PDF pdf, double llx, double lly, double urx, double ury, String url) {
        env.stub("pdf_add_weblink");
        return false;
    }

    public static boolean pdf_arc(@NotNull PDF pdf, double x1, double y1, double r, double a, double b) {
        if (pdf == null) {
            return false;
        }
        return pdf.arc(x1, y1, r, a, b);
    }

    public static boolean pdf_arcn(@NotNull PDF pdf, double x1, double y1, double r, double a, double b) {
        if (pdf == null) {
            return false;
        }
        return pdf.arcn(x1, y1, r, a, b);
    }

    public static boolean pdf_attach_file(Env env, @NotNull PDF pdf, double llx, double lly, double urx, double ury, String filename, String description, String author, String mimetype, String icon) {
        env.stub("pdf_attach_file");
        return false;
    }

    public static boolean pdf_begin_document(@NotNull PDF pdf, @Optional String fileName, @Optional String optList) {
        try {
            if (pdf == null) {
                return false;
            }
            return pdf.begin_document(fileName, optList);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_begin_font(Env env, @NotNull PDF pdf, String fileName, double a, double b, double c, double d, double e, double f, @Optional String optList) {
        env.stub("pdf_begin_font");
        return false;
    }

    public static boolean pdf_begin_glyph(Env env, @NotNull PDF pdf, String glyphname, double wx, double llx, double lly, double urx, double ury) {
        env.stub("pdf_begin_glyph");
        return false;
    }

    public static boolean pdf_begin_item(Env env, @NotNull PDF pdf, String tag, String optlist) {
        env.stub("pdf_begin_item");
        return false;
    }

    public static boolean pdf_begin_layer(Env env, @NotNull PDF pdf, int layer) {
        env.stub("pdf_begin_layer");
        return false;
    }

    public static boolean pdf_begin_page_ext(@NotNull PDF pdf, double w, double h, @Optional String optlist) {
        try {
            if (pdf == null) {
                return false;
            }
            return pdf.begin_page_ext(w, h, optlist);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_begin_page(@NotNull PDF pdf, double w, double h) {
        try {
            if (pdf == null) {
                return false;
            }
            return pdf.begin_page(w, h);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_begin_pattern(Env env, @NotNull PDF pdf, double w, double h, double xStep, double yStep, int paintType) {
        env.stub("pdf_begin_pattern");
        return false;
    }

    public static boolean pdf_begin_template(Env env, @NotNull PDF pdf, double w, double h) {
        env.stub("pdf_begin_template");
        return false;
    }

    public static boolean pdf_circle(@NotNull PDF pdf, double x, double y, double r) {
        if (pdf == null) {
            return false;
        }
        return pdf.circle(x, y, r);
    }

    public static boolean pdf_clip(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.clip();
    }

    public static boolean pdf_close_image(Env env, @NotNull PDF pdf, PDFImage image) {
        env.stub("pdf_close_image");
        return false;
    }

    public static boolean pdf_close_pdi_page(Env env, @NotNull PDF pdf, int page) {
        env.stub("pdf_close_pdi_page");
        return false;
    }

    public static boolean pdf_close_pdi(Env env, @NotNull PDF pdf, int doc) {
        env.stub("pdf_close_pdi");
        return false;
    }

    public static boolean pdf_close(@NotNull PDF pdf) {
        try {
            if (pdf == null) {
                return false;
            }
            return pdf.close();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_closepath_fill_stroke(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.closepath_fill_stroke();
    }

    public static boolean pdf_closepath_stroke(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.closepath_stroke();
    }

    public static boolean pdf_closepath(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.closepath();
    }

    public static boolean pdf_concat(@NotNull PDF pdf, double a, double b, double c, double d, double e, double f) {
        if (pdf == null) {
            return false;
        }
        return pdf.concat(a, b, c, d, e, f);
    }

    public static boolean pdf_continue_text(@NotNull PDF pdf, String text) {
        if (pdf == null) {
            return false;
        }
        return pdf.continue_text(text);
    }

    public static boolean pdf_create_action(Env env, @NotNull PDF pdf, String type, @Optional String optList) {
        env.stub("pdf_create_action");
        return false;
    }

    public static boolean pdf_create_annotation(Env env, @NotNull PDF pdf, double llx, double lly, double urx, double ury, String type, @Optional String optList) {
        env.stub("pdf_create_annotation");
        return false;
    }

    public static boolean pdf_create_bookmark(Env env, @NotNull PDF pdf, String text, @Optional String optList) {
        env.stub("pdf_create_bookmark");
        return false;
    }

    public static boolean pdf_create_field(Env env, @NotNull PDF pdf, double llx, double lly, double urx, double ury, String name, String type, @Optional String optList) {
        env.stub("pdf_create_field");
        return false;
    }

    public static boolean pdf_create_fieldgroup(Env env, @NotNull PDF pdf, String name, @Optional String optList) {
        env.stub("pdf_create_fieldgroup");
        return false;
    }

    public static boolean pdf_create_gstate(Env env, @NotNull PDF pdf, @Optional String optList) {
        env.stub("pdf_create_gstate");
        return false;
    }

    public static boolean pdf_create_pvf(Env env, @NotNull PDF pdf, String filename, String data, @Optional String optList) {
        env.stub("pdf_create_pvf");
        return false;
    }

    public static boolean pdf_create_textflow(Env env, @NotNull PDF pdf, String text, @Optional String optList) {
        env.stub("pdf_create_textflow");
        return false;
    }

    public static boolean pdf_curveto(@NotNull PDF pdf, double x1, double y1, double x2, double y2, double x3, double y3) {
        if (pdf == null) {
            return false;
        }
        return pdf.curveto(x1, y1, x2, y2, x3, y3);
    }

    public static boolean pdf_define_layer(Env env, @NotNull PDF pdf, String name, @Optional String optList) {
        env.stub("pdf_define_layer");
        return false;
    }

    public static boolean pdf_delete_pvf(Env env, @NotNull PDF pdf, String name) {
        env.stub("pdf_delete_pvf");
        return false;
    }

    public static boolean pdf_delete_textflow(Env env, @NotNull PDF pdf, int textflow) {
        env.stub("pdf_delete_textflow");
        return false;
    }

    public static boolean pdf_delete(@NotNull PDF pdf) {
        try {
            if (pdf == null) {
                return false;
            }
            return pdf.delete();
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_encoding_set_char(Env env, @NotNull PDF pdf, String encoding, int slow, String glyphname, int uv) {
        env.stub("pdf_encoding_set_char");
        return false;
    }

    public static boolean pdf_end_document(@NotNull PDF pdf, @Optional String optlist) {
        try {
            if (pdf == null) {
                return false;
            }
            return pdf.end_document(optlist);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_end_font(Env env, @NotNull PDF pdf) {
        env.stub("pdf_end_font");
        return false;
    }

    public static boolean pdf_end_glyph(Env env, @NotNull PDF pdf) {
        env.stub("pdf_end_glyph");
        return false;
    }

    public static boolean pdf_end_item(Env env, @NotNull PDF pdf, int id) {
        env.stub("pdf_end_item");
        return false;
    }

    public static boolean pdf_end_layer(Env env, @NotNull PDF pdf) {
        env.stub("pdf_end_layer");
        return false;
    }

    public static boolean pdf_end_page_ext(@NotNull PDF pdf, @Optional String optlist) {
        if (pdf == null) {
            return false;
        }
        return pdf.end_page_ext(optlist);
    }

    public static boolean pdf_end_page(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.end_page();
    }

    public static boolean pdf_end_pattern(Env env, @NotNull PDF pdf) {
        env.stub("pdf_end_pattern");
        return false;
    }

    public static boolean pdf_end_template(Env env, @NotNull PDF pdf) {
        env.stub("pdf_end_template");
        return false;
    }

    public static boolean pdf_end_path(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.endpath();
    }

    public static boolean pdf_fill_imageblock(Env env, @NotNull PDF pdf, int page, String blockname, int image, @Optional String optlist) {
        env.stub("pdf_fill_imageblock");
        return false;
    }

    public static boolean pdf_fill_pdfblock(Env env, @NotNull PDF pdf, int page, String blockname, int contents, @Optional String optlist) {
        env.stub("pdf_fill_pdfblock");
        return false;
    }

    public static boolean pdf_fill_stroke(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.fill_stroke();
    }

    public static boolean pdf_fill_textblock(Env env, @NotNull PDF pdf, int page, String block, String text, @Optional String optlist) {
        env.stub("pdf_fill_textblock");
        return false;
    }

    public static boolean pdf_fill(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.fill();
    }

    public static boolean pdf_findfont(Env env, @NotNull PDF pdf, String fontname, String encoding, int embed) {
        env.stub("pdf_findfont");
        return false;
    }

    public static boolean pdf_fit_image(@NotNull PDF pdf, @NotNull PDFImage image, double x, double y, @Optional String optlist) {
        if (pdf == null) {
            return false;
        }
        return pdf.fit_image(image, x, y, optlist);
    }

    public static boolean pdf_fit_pdi_page(Env env, @NotNull PDF pdf, int page, double x, double y, @Optional String optlist) {
        env.stub("pdf_fit_pdi_page");
        return false;
    }

    public static boolean pdf_fit_textflow(Env env, @NotNull PDF pdf, int textflow, double llx, double lly, double urx, double ury, @Optional String optlist) {
        env.stub("pdf_fit_textflow");
        return false;
    }

    public static boolean pdf_fit_textline(Env env, @NotNull PDF pdf, String text, double x, double y, @Optional String optlist) {
        env.stub("pdf_fit_textline");
        return false;
    }

    public static String pdf_get_apiname(Env env, @NotNull PDF pdf) {
        env.stub("pdf_get_apiname");
        return "";
    }

    public static Value pdf_get_buffer(Env env, @NotNull PDF pdf) {
        if (pdf == null) {
            return BooleanValue.FALSE;
        }
        return pdf.get_buffer(env);
    }

    public static String pdf_get_errmsg(PDF pdf) {
        if (pdf != null) {
            return pdf.get_errmsg();
        }
        return "";
    }

    public static int pdf_get_errnum(PDF pdf) {
        if (pdf != null) {
            return pdf.get_errnum();
        }
        return 0;
    }

    public static double pdf_get_image_height(@NotNull PDFImage image) {
        if (image != null) {
            return image.get_height();
        }
        return 0.0;
    }

    public static double pdf_get_image_width(@NotNull PDFImage image) {
        if (image != null) {
            return image.get_width();
        }
        return 0.0;
    }

    public static String pdf_get_parameter(@NotNull PDF pdf, String key, @Optional double modifier) {
        if (pdf != null) {
            return pdf.get_parameter(key, modifier);
        }
        return "";
    }

    public static String pdf_get_pdi_parameter(Env env, @NotNull PDF pdf, String key, int doc, int page, int reserved) {
        env.stub("pdf_get_pdi_parameter");
        return "";
    }

    public static double pdf_get_pdi_value(Env env, @NotNull PDF pdf, String key, int doc, int page, int reserved) {
        env.stub("pdf_get_pdi_value");
        return 0.0;
    }

    public static double pdf_get_value(@NotNull PDF pdf, String key, @Optional double modifier) {
        if (pdf != null) {
            return pdf.get_value(key, modifier);
        }
        return 0.0;
    }

    public static double pdf_info_textflow(Env env, @NotNull PDF pdf, int textflow, String key) {
        env.stub("pdf_info_textflow");
        return 0.0;
    }

    public static boolean pdf_initgraphics(Env env, @NotNull PDF pdf) {
        if (pdf != null) {
            return pdf.initgraphics(env);
        }
        return false;
    }

    public static boolean pdf_lineto(@NotNull PDF pdf, double x, double y) {
        if (pdf == null) {
            return false;
        }
        return pdf.lineto(x, y);
    }

    public static PDFFont pdf_load_font(@NotNull PDF pdf, String fontname, String encoding, @Optional String optlist) {
        try {
            if (pdf == null) {
                return null;
            }
            return pdf.load_font(fontname, encoding, optlist);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_load_iccprofile(Env env, @NotNull PDF pdf, String profileName, @Optional String optlist) {
        env.stub("pdf_load_iccprofile");
        return false;
    }

    public static PDFImage pdf_load_image(@NotNull PDF pdf, String imageType, Path path, @Optional String optlist) {
        try {
            if (pdf == null) {
                return null;
            }
            return pdf.load_image(imageType, path, optlist);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_makespotcolor(Env env, @NotNull PDF pdf, String spotname) {
        env.stub("pdf_makespotcolor");
        return false;
    }

    public static boolean pdf_moveto(@NotNull PDF pdf, double x, double y) {
        if (pdf == null) {
            return false;
        }
        return pdf.moveto(x, y);
    }

    public static PDF pdf_new(Env env) {
        return new PDF(env);
    }

    public static boolean pdf_open_file(@NotNull PDF pdf, String filename) {
        return PDFModule.pdf_begin_document(pdf, filename, "");
    }

    public static PDFImage pdf_open_image_file(@NotNull PDF pdf, String imagetype, Path filename, String stringparam, int intparam) {
        return PDFModule.pdf_load_image(pdf, imagetype, filename, "");
    }

    public static boolean pdf_open_image_data(Env env, @NotNull PDF pdf, String imagetype, String source, String data, long length, long width, long height, int components, int bpc, String params) {
        env.stub("pdf_open_image_data");
        return false;
    }

    public static boolean pdf_open_pdi_page(Env env, @NotNull PDF pdf, int doc, int pagenumber, @Optional String optlist) {
        env.stub("pdf_open_pdi_page");
        return false;
    }

    public static boolean pdf_open_pdi(Env env, @NotNull PDF pdf, String filename, @Optional String optlist) {
        env.stub("pdf_open_pdi");
        return false;
    }

    public static boolean pdf_place_image(@NotNull PDF pdf, PDFImage image, double x, double y, double scale) {
        return PDFModule.pdf_fit_image(pdf, image, x, y, "");
    }

    public static boolean pdf_place_pdi_page(Env env, @NotNull PDF pdf, int page, double x, double y, double scaleX, double scaleY) {
        return PDFModule.pdf_fit_pdi_page(env, pdf, page, x, y, "");
    }

    public static boolean pdf_process_pdi(Env env, @NotNull PDF pdf, int doc, int page, @Optional String optlist) {
        env.stub("pdf_process_pdi");
        return false;
    }

    public static boolean pdf_rect(@NotNull PDF pdf, double x, double y, double width, double height) {
        if (pdf == null) {
            return false;
        }
        return pdf.rect(x, y, width, height);
    }

    public static boolean pdf_restore(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.restore();
    }

    public static boolean pdf_rotate(@NotNull PDF pdf, double phi) {
        if (pdf == null) {
            return false;
        }
        return pdf.rotate(phi);
    }

    public static boolean pdf_save(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.save();
    }

    public static boolean pdf_scale(@NotNull PDF pdf, double scaleX, double scaleY) {
        if (pdf == null) {
            return false;
        }
        return pdf.scale(scaleX, scaleY);
    }

    public static boolean pdf_set_border_color(Env env, @NotNull PDF pdf, double red, double green, double blue) {
        env.stub("pdf_set_border_color");
        return false;
    }

    public static boolean pdf_set_border_dash(Env env, @NotNull PDF pdf, double black, double white) {
        env.stub("pdf_set_border_dash");
        return false;
    }

    public static boolean pdf_set_border_style(Env env, @NotNull PDF pdf, String style, double width) {
        env.stub("pdf_set_border_style");
        return false;
    }

    public static boolean pdf_set_gstate(Env env, @NotNull PDF pdf, int gstate) {
        env.stub("pdf_set_gstate");
        return false;
    }

    public static boolean pdf_set_info(@NotNull PDF pdf, String key, String value) {
        if (pdf == null) {
            return false;
        }
        return pdf.set_info(key, value);
    }

    public static boolean pdf_set_layer_dependency(Env env, @NotNull PDF pdf, String type, @Optional String optlist) {
        env.stub("pdf_set_layer_dependency");
        return false;
    }

    public static boolean pdf_set_parameter(@NotNull PDF pdf, String key, String value) {
        if (pdf != null) {
            return false;
        }
        return pdf.set_parameter(key, value);
    }

    public static boolean pdf_set_text_pos(@NotNull PDF pdf, double x, double y) {
        if (pdf == null) {
            return false;
        }
        return pdf.set_text_pos(x, y);
    }

    public static boolean pdf_set_value(@NotNull PDF pdf, String key, double value) {
        if (pdf == null) {
            return false;
        }
        return pdf.set_value(key, value);
    }

    public static boolean pdf_setcolor(@NotNull PDF pdf, String type, String colorspace, double c1, @Optional double c2, @Optional double c3, @Optional double c4) {
        if (pdf == null) {
            return false;
        }
        return pdf.setcolor(type, colorspace, c1, c2, c3, c4);
    }

    public static boolean pdf_setdash(@NotNull PDF pdf, double black, double white) {
        if (pdf == null) {
            return false;
        }
        return pdf.setdash(black, white);
    }

    public static boolean pdf_setdashpattern(Env env, @NotNull PDF pdf, String optlist) {
        if (pdf == null) {
            return false;
        }
        return pdf.setdashpattern(env, optlist);
    }

    public static boolean pdf_setflat(Env env, @NotNull PDF pdf, double flatness) {
        if (pdf == null) {
            return false;
        }
        return pdf.setflat(env, flatness);
    }

    public static boolean pdf_setfont(@NotNull PDF pdf, @NotNull PDFFont font, double size) {
        try {
            if (pdf == null) {
                return false;
            }
            return pdf.setfont(font, size);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean pdf_setgray_fill(@NotNull PDF pdf, double g) {
        if (pdf == null) {
            return false;
        }
        return pdf.setgray_fill(g);
    }

    public static boolean pdf_setgray_stroke(@NotNull PDF pdf, double g) {
        if (pdf == null) {
            return false;
        }
        return pdf.setgray_stroke(g);
    }

    public static boolean pdf_setgray(@NotNull PDF pdf, double g) {
        if (pdf == null) {
            return false;
        }
        return pdf.setgray(g);
    }

    public static boolean pdf_setlinecap(Env env, @NotNull PDF pdf, int value) {
        if (pdf == null) {
            return false;
        }
        return pdf.setlinecap(env, value);
    }

    public static boolean pdf_setlinejoin(Env env, @NotNull PDF pdf, int value) {
        if (pdf == null) {
            return false;
        }
        return pdf.setlinejoin(env, value);
    }

    public static boolean pdf_setlinewidth(@NotNull PDF pdf, double width) {
        if (pdf == null) {
            return false;
        }
        return pdf.setlinewidth(width);
    }

    public static boolean pdf_setmatrix(Env env, @NotNull PDF pdf, double a, double b, double c, double d, double e, double f) {
        if (pdf == null) {
            return false;
        }
        return pdf.setmatrix(env, a, b, c, d, e, f);
    }

    public static boolean pdf_setmiterlimit(Env env, @NotNull PDF pdf, double value) {
        if (pdf == null) {
            return false;
        }
        return pdf.setmiterlimit(env, value);
    }

    public static boolean pdf_setrgbcolor_fill(@NotNull PDF pdf, double red, double green, double blue) {
        if (pdf == null) {
            return false;
        }
        return pdf.setrgbcolor_fill(red, green, blue);
    }

    public static boolean pdf_setrgbcolor_stroke(@NotNull PDF pdf, double red, double green, double blue) {
        if (pdf == null) {
            return false;
        }
        return pdf.setrgbcolor_stroke(red, green, blue);
    }

    public static boolean pdf_setrgbcolor(@NotNull PDF pdf, double red, double green, double blue) {
        if (pdf == null) {
            return false;
        }
        return pdf.setrgbcolor(red, green, blue);
    }

    public static boolean pdf_shading_pattern(Env env, @NotNull PDF pdf, int shading, @Optional String optlist) {
        if (pdf == null) {
            return false;
        }
        return pdf.shading_pattern(env, shading, optlist);
    }

    public static int pdf_shading(Env env, @NotNull PDF pdf, String type, double x1, double y1, double x2, double y2, double c1, double c2, double c3, double c4, @Optional String optlist) {
        if (pdf == null) {
            return 0;
        }
        return pdf.shading(env, type, x1, y1, x2, y2, c1, c2, c3, c4, optlist);
    }

    public static boolean pdf_shfill(Env env, @NotNull PDF pdf, int shading) {
        if (pdf == null) {
            return false;
        }
        return pdf.shfill(env, shading);
    }

    public static boolean pdf_show_boxed(Env env, @NotNull PDF pdf, String text, double x, double y, double width, double height, String mode, @Optional String feature) {
        if (pdf == null) {
            return false;
        }
        return pdf.show_boxed(text, x, y, width, height, mode, feature);
    }

    public static boolean pdf_show_xy(Env env, @NotNull PDF pdf, String text, double x, double y) {
        if (pdf == null) {
            return false;
        }
        return pdf.show_xy(text, x, y);
    }

    public static boolean pdf_show(Env env, @NotNull PDF pdf, String text) {
        if (pdf == null) {
            return false;
        }
        return pdf.show(text);
    }

    public static boolean pdf_skew(@NotNull PDF pdf, double alpha, double beta) {
        if (pdf == null) {
            return false;
        }
        return pdf.skew(alpha, beta);
    }

    public static double pdf_stringwidth(@NotNull PDF pdf, String text, @NotNull PDFFont font, double size) {
        if (pdf == null) {
            return 0.0;
        }
        return pdf.stringwidth(text, font, size);
    }

    public static boolean pdf_stroke(@NotNull PDF pdf) {
        if (pdf == null) {
            return false;
        }
        return pdf.stroke();
    }

    public static boolean pdf_suspend_page(Env env, @NotNull PDF pdf, @Optional String optlist) {
        env.stub("pdf_suspend_page");
        return false;
    }

    public static boolean pdf_translate(@NotNull PDF pdf, double x, double y) {
        if (pdf == null) {
            return false;
        }
        return pdf.translate(x, y);
    }

    public static String pdf_utf16_to_utf8(Env env, @NotNull PDF pdf, String utf16string) {
        env.stub("pdf_utf16_to_utf8");
        return utf16string;
    }

    public static String pdf_utf8_to_utf16(Env env, @NotNull PDF pdf, String utf8string) {
        env.stub("pdf_utf16_to_utf8");
        return utf8string;
    }
}

