/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.lib.pdf.PDFDestination;
import com.caucho.quercus.lib.pdf.PDFObject;
import com.caucho.quercus.lib.pdf.PDFOutline;
import com.caucho.quercus.lib.pdf.PDFPage;
import com.caucho.quercus.lib.pdf.PDFStream;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class PDFWriter {
    private static final Logger log = Logger.getLogger(PDFWriter.class.getName());
    private static final L10N L = new L10N(PDFWriter.class);
    private long _offset;
    private WriteStream _out;
    private int _objectId = 1;
    private int _lastObject;
    private String _creator = "Quercus PDF";
    private String _author;
    private String _title;
    private ArrayList<PDFObject> _pendingObjects = new ArrayList();
    private ArrayList<ObjectDef> _xref = new ArrayList();

    PDFWriter(WriteStream out) {
        this._out = out;
    }

    public void setCreator(String creator) {
        this._creator = creator;
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void beginDocument() throws IOException {
        this.println("%PDF-1.4");
        this.println("#\u00c0\u00c3\u00c4\u00c9");
    }

    public void writeCatalog(int catalogId, int rootId, int outlineId, ArrayList<Integer> pagesList, int pageCount) throws IOException {
        this.beginObject(catalogId);
        this.println("  << /Type /Catalog");
        this.println("     /Pages " + rootId + " 0 R");
        if (outlineId > 0) {
            this.println("     /PageMode /UseOutlines");
            this.println("     /Outlines " + outlineId + " 0 R");
        }
        this.println("  >>");
        this.endObject();
        if (pagesList.size() > 0) {
            this.beginObject(rootId);
            this.println("  << /Type /Pages");
            this.print("     /Kids [");
            for (int i = 0; i < pagesList.size(); ++i) {
                if (i != 0) {
                    this.print(" ");
                }
                this.print(pagesList.get(i) + " 0 R");
            }
            this.println("]");
            this.println("     /Count " + pageCount);
            this.println("  >>");
            this.endObject();
        }
    }

    public void writeOutline(PDFOutline outline) throws IOException {
        List<PDFDestination> roots = outline.getRootDestinations();
        this.beginObject(outline.getId());
        this.println("  << /Type /Outlines");
        this.println("     /First " + roots.get(0).getId() + " 0 R");
        this.println("     /Last " + roots.get(roots.size() - 1).getId() + " 0 R");
        this.println("  >>");
        this.endObject();
        for (int i = 0; i < roots.size(); ++i) {
            this.writeOutlineItem(roots, i);
        }
    }

    private void writeOutlineItem(List<PDFDestination> destinations, int index) throws IOException {
        PDFDestination dest = destinations.get(index);
        List<PDFDestination> children = dest.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            this.writeOutlineItem(children, i);
        }
        this.beginObject(dest.getId());
        this.println("  << /Title (" + PDFStream.pdfEscapeText(dest.getTitle()) + ")");
        this.println("     /Parent " + dest.getParentId() + " 0 R");
        this.println("     /Dest [" + dest.getPageId() + " 0 R /XYZ 0 " + dest.getPos() + " 0]");
        if (index > 0) {
            this.println("     /Prev " + destinations.get(index - 1).getId() + " 0 R");
        }
        if (index < destinations.size() - 1) {
            this.println("     /Next " + destinations.get(index + 1).getId() + " 0 R");
        }
        if (!children.isEmpty()) {
            this.println("     /First " + children.get(0).getId() + " 0 R");
            this.println("     /Last " + children.get(children.size() - 1).getId() + " 0 R");
            this.println("     /Count " + children.size() * -1);
        }
        this.println("  >>");
        this.endObject();
    }

    public void writePageGroup(int id, int parentId, ArrayList<PDFPage> pages) throws IOException {
        int i;
        this.beginObject(id);
        this.println("  << /Type /Pages");
        this.print("     /Kids [");
        for (i = 0; i < pages.size(); ++i) {
            if (i != 0) {
                this.print(" ");
            }
            this.print(pages.get(i).getId() + " 0 R");
        }
        this.println("]");
        this.println("     /Count " + pages.size());
        this.println("     /Parent " + parentId + " 0 R");
        this.println("  >>");
        this.endObject();
        for (i = 0; i < pages.size(); ++i) {
            pages.get(i).write(this);
        }
    }

    public void writeStream(int id, PDFStream stream) throws IOException {
        stream.flush();
        int length = stream.getLength();
        this.beginObject(id);
        this.println(" << /Length " + length + " >>");
        this.println("stream");
        stream.writeToStream(this._out);
        this._offset += (long)length;
        this.println();
        this.println("endstream");
        this.endObject();
    }

    public void endDocument() throws IOException {
        long xrefOffset = this._offset;
        this.println("xref");
        this.println("0 " + (this._xref.size() + 1) + "");
        this.print("0000000000 65535 f \n");
        for (int i = 0; i < this._xref.size(); ++i) {
            this._xref.get(i).write();
        }
        this.println("trailer");
        this.println(" << /Size " + (this._xref.size() + 1));
        this.println("    /Root 1 0 R");
        this.println(" >>");
        this.println("startxref");
        this.println(xrefOffset);
        this.println("%%EOF");
    }

    public int allocateId(int count) {
        int id = this._objectId;
        this._objectId += count;
        return id;
    }

    public void addPendingObject(PDFObject obj) throws IOException {
        if (this._lastObject + 1 == obj.getId()) {
            this.beginObject(obj.getId());
            obj.writeObject(this);
            this.endObject();
        } else {
            this._pendingObjects.add(obj);
        }
    }

    public void beginObject(int id) throws IOException {
        while (this._xref.size() < id) {
            this._xref.add(null);
        }
        this._xref.set(id - 1, new ObjectDef(id, this._offset));
        this.println(id + " 0 obj");
    }

    public void endObject() throws IOException {
        this.println("endobj");
        ++this._lastObject;
        for (int i = this._pendingObjects.size() - 1; i >= 0; --i) {
            PDFObject obj = this._pendingObjects.get(i);
            if (this._lastObject + 1 != obj.getId()) continue;
            this._pendingObjects.remove(i);
            this.beginObject(obj.getId());
            obj.writeObject(this);
            this.endObject();
            break;
        }
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._out.write(buffer, offset, length);
        this._offset += (long)length;
    }

    public void print(String s) throws IOException {
        this._out.print(s);
        this._offset += (long)s.length();
    }

    public void println(String s) throws IOException {
        this._out.println(s);
        this._offset += (long)(s.length() + 1);
    }

    public void println() throws IOException {
        this._out.println();
        ++this._offset;
    }

    public void print(long v) throws IOException {
        this.println(String.valueOf(v));
    }

    public void println(long v) throws IOException {
        this.println(String.valueOf(v));
    }

    public void print(double v) throws IOException {
        if ((double)((long)v) == v) {
            this.print(String.valueOf((long)v));
        } else {
            this.print(String.valueOf(v));
        }
    }

    public void println(double v) throws IOException {
        if ((double)((long)v) == v) {
            this.println(String.valueOf((long)v));
        } else {
            this.println(String.valueOf(v));
        }
    }

    public String toString() {
        return "PDF[]";
    }

    class ObjectDef {
        private int _id;
        private long _offset;

        ObjectDef(int id, long offset) {
            this._id = id;
            this._offset = offset;
        }

        void write() throws IOException {
            PDFWriter.this._out.print(this._offset / 1000000000L % 10L);
            PDFWriter.this._out.print(this._offset / 100000000L % 10L);
            PDFWriter.this._out.print(this._offset / 10000000L % 10L);
            PDFWriter.this._out.print(this._offset / 1000000L % 10L);
            PDFWriter.this._out.print(this._offset / 100000L % 10L);
            PDFWriter.this._out.print(this._offset / 10000L % 10L);
            PDFWriter.this._out.print(this._offset / 1000L % 10L);
            PDFWriter.this._out.print(this._offset / 100L % 10L);
            PDFWriter.this._out.print(this._offset / 10L % 10L);
            PDFWriter.this._out.print(this._offset % 10L);
            PDFWriter.this._out.print(" 00000 n \n");
            this._offset += 20L;
        }
    }
}

