/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.reflection;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.CallExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.reflection.ReflectionClass;
import com.caucho.quercus.lib.reflection.ReflectionFunctionAbstract;
import com.caucho.quercus.lib.reflection.ReflectionParameter;
import com.caucho.quercus.lib.reflection.Reflector;
import com.caucho.quercus.program.Arg;
import com.caucho.util.L10N;

public class ReflectionMethod
extends ReflectionFunctionAbstract
implements Reflector {
    private static final L10N L = new L10N(ReflectionMethod.class);
    public static final int IS_STATIC = 1;
    public static final int IS_ABSTRACT = 2;
    public static final int IS_FINAL = 4;
    public static final int IS_PUBLIC = 256;
    public static final int IS_PROTECTED = 512;
    public static final int IS_PRIVATE = 1024;
    private String _clsName;

    protected ReflectionMethod(AbstractFunction method) {
        super(method);
    }

    protected ReflectionMethod(String clsName, AbstractFunction method) {
        super(method);
        this._clsName = clsName;
    }

    public static ReflectionMethod __construct(Env env, Value obj, StringValue name) {
        String clsName = obj.isObject() ? obj.getClassName() : obj.toString();
        return new ReflectionMethod(clsName, env.getClass(clsName).getFunction(name));
    }

    public static String export(Env env, Value cls, String name, @Optional boolean isReturn) {
        return null;
    }

    public Value invoke(Env env, ObjectValue object, Value[] args) {
        return this.getFunction().callMethod(env, object.getQuercusClass(), (Value)object, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value invokeArgs(Env env, ObjectValue object, ArrayValue args) {
        AbstractFunction fun = this.getFunction();
        CallExpr expr = new CallExpr(Location.UNKNOWN, env.createString(this.getName()), (Expr[])null);
        env.pushCall(expr, object, args.getValueArray(env));
        try {
            Value value = fun.callMethod(env, object.getQuercusClass(), (Value)object, args.getValueArray(env));
            return value;
        }
        finally {
            env.popCall();
        }
    }

    public boolean isFinal() {
        return this.getFunction().isFinal();
    }

    public boolean isAbstract() {
        return this.getFunction().isAbstract();
    }

    public boolean isPublic() {
        return this.getFunction().isPublic();
    }

    public boolean isPrivate() {
        return this.getFunction().isPrivate();
    }

    public boolean isProtected() {
        return this.getFunction().isProtected();
    }

    public boolean isStatic() {
        return this.getFunction().isStatic();
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDestructor() {
        return false;
    }

    public int getModifiers() {
        int flag = 65536;
        if (this.isProtected()) {
            flag |= 0x200;
        } else if (this.isPublic()) {
            flag |= 0x100;
        }
        if (this.isFinal()) {
            flag |= 4;
        }
        if (this.isAbstract()) {
            flag |= 2;
        }
        if (this.isStatic()) {
            flag |= 1;
        }
        return flag;
    }

    public ReflectionClass getDeclaringClass(Env env) {
        String clsName = this.getFunction().getDeclaringClassName();
        if (clsName == null) {
            throw new QuercusException(L.l("class name is null {0}: {1}", (Object)this.getFunction(), (Object)this.getFunction().getClass()));
        }
        return new ReflectionClass(env, clsName);
    }

    @Override
    public ArrayValue getParameters(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        AbstractFunction fun = this.getFunction();
        Arg[] args = fun.getArgs(env);
        for (int i = 0; i < args.length; ++i) {
            ((ArrayValue)array).put(env.wrapJava(new ReflectionParameter(this._clsName, fun, args[i])));
        }
        return array;
    }

    public void setAccessible(boolean isAccessible) {
    }

    private AbstractFunction getFunction() {
        return (AbstractFunction)this.getCallable();
    }

    public String toString() {
        String name = this._clsName != null ? this._clsName + "->" + this.getName() : this.getName();
        return this.getClass().getSimpleName() + "[" + name + "]";
    }
}

