/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.ObjectExtJavaValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.SimpleXMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SimpleUtil {
    public static void toXml(Env env, StringBuilder sb, Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                SimpleUtil.toXmlImpl(env, sb, (Document)node);
                break;
            }
            case 1: {
                SimpleUtil.toXmlImpl(env, sb, (Element)node);
                break;
            }
            case 3: {
                SimpleUtil.toXmlImpl(env, sb, (Text)node);
                break;
            }
            case 2: {
                SimpleUtil.toXmlImpl(env, sb, (Attr)node);
                break;
            }
            case 10: {
                SimpleUtil.toXmlImpl(env, sb, (DocumentType)node);
                break;
            }
            case 5: {
                SimpleUtil.toXmlImpl(env, sb, (EntityReference)node);
                break;
            }
            case 8: {
                SimpleUtil.toXmlImpl(env, sb, (Comment)node);
                break;
            }
            default: {
                throw new UnsupportedOperationException(node.getClass().getName());
            }
        }
    }

    public static void toXmlImpl(Env env, StringBuilder sb, Document doc) {
        sb.append("<?xml version=");
        sb.append('\"');
        sb.append(doc.getXmlVersion());
        sb.append('\"');
        if (doc.getXmlEncoding() != null) {
            sb.append(' ');
            sb.append("encoding=");
            sb.append('\"');
            sb.append(doc.getXmlEncoding());
            sb.append('\"');
        }
        sb.append("?>\n");
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            SimpleUtil.toXml(env, sb, child);
            sb.append('\n');
        }
    }

    public static void toXmlImpl(Env env, StringBuilder sb, Element node) {
        sb.append('<');
        sb.append(node.getNodeName());
        NamedNodeMap attrMap = node.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node attr = attrMap.item(i);
            SimpleUtil.toXml(env, sb, attr);
        }
        if (node.getFirstChild() == null) {
            sb.append('/');
            sb.append('>');
        } else {
            sb.append('>');
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                SimpleUtil.toXml(env, sb, child);
            }
            sb.append('<');
            sb.append('/');
            sb.append(node.getNodeName());
            sb.append('>');
        }
    }

    public static void toXmlImpl(Env env, StringBuilder sb, Attr node) {
        sb.append(' ');
        sb.append(node.getNodeName());
        sb.append('=');
        sb.append('\"');
        sb.append(node.getNodeValue());
        sb.append('\"');
    }

    public static void toXmlImpl(Env env, StringBuilder sb, Text node) {
        String str = node.getNodeValue();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entity = SimpleUtil.toEntity(ch);
            if (entity != null) {
                sb.append('&');
                sb.append(entity);
                sb.append(';');
                continue;
            }
            sb.append(ch);
        }
    }

    public static void toXmlImpl(Env env, StringBuilder sb, DocumentType node) {
        sb.append("<!DOCTYPE");
        sb.append(' ');
        sb.append(node.getName());
        sb.append(' ');
        sb.append("SYSTEM");
        sb.append(' ');
        sb.append('\"');
        sb.append(node.getSystemId());
        sb.append('\"');
        NamedNodeMap entities = node.getEntities();
        if (entities != null && entities.getLength() > 0) {
            sb.append(' ');
            sb.append('[');
            sb.append('\n');
            for (int i = 0; i < entities.getLength(); ++i) {
                Entity entity = (Entity)entities.item(i);
                sb.append("<!ENTITY");
                sb.append(' ');
                sb.append(entity.getNodeName());
                sb.append(' ');
                sb.append('\"');
                sb.append(entity.getTextContent());
                sb.append('\"');
                sb.append('>');
                sb.append('\n');
            }
            sb.append(']');
        }
        sb.append('>');
    }

    public static void toXmlImpl(Env env, StringBuilder sb, EntityReference node) {
        sb.append('&');
        sb.append(node.getNodeName());
        sb.append(';');
    }

    public static void toXmlImpl(Env env, StringBuilder sb, Comment node) {
        sb.append("<!--");
        sb.append(node.getNodeValue());
        sb.append("-->");
    }

    public static String toEntity(char ch) {
        switch (ch) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '&': {
                return "amp";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
        }
        return null;
    }

    public static int fromEntity(String name) {
        if ("lt".equals(name)) {
            return 60;
        }
        if ("gt".equals(name)) {
            return 62;
        }
        if ("amp".equals(name)) {
            return 38;
        }
        if ("quot".equals(name)) {
            return 34;
        }
        if ("apos".equals(name)) {
            return 39;
        }
        return -1;
    }

    public static boolean isSameNamespace(Node node, String namespace) {
        String prefix = SimpleUtil.getPrefix(node.getNodeName());
        return SimpleUtil.hasNamespace(node, prefix, namespace);
    }

    public static String getPrefix(String name) {
        int i = name.indexOf(58);
        if (i < 0) {
            return null;
        }
        String prefix = name.substring(0, i);
        return prefix;
    }

    public static boolean hasNamespace(Node node, String prefix, String namespace) {
        NamedNodeMap attrMap;
        if (namespace == null) {
            return true;
        }
        String attrName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
        while (node != null && (attrMap = node.getAttributes()) != null) {
            Attr attr = (Attr)attrMap.getNamedItem(attrName);
            if (attr != null) {
                return attr.getNodeValue().equals(namespace);
            }
            node = node.getParentNode();
        }
        return false;
    }

    public static Value wrapJava(Env env, QuercusClass cls, SimpleXMLNode node) {
        if (!"SimpleXMLElement".equals(cls.getName())) {
            return new ObjectExtJavaValue(env, cls, node, cls.getJavaClassDef());
        }
        return new JavaValue(env, node, cls.getJavaClassDef());
    }
}

