/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.JsonEncode;
import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectExtJavaValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.AttributeListView;
import com.caucho.quercus.lib.simplexml.ChildrenView;
import com.caucho.quercus.lib.simplexml.SimpleNamespaceContext;
import com.caucho.quercus.lib.simplexml.SimpleView;
import com.caucho.quercus.lib.simplexml.SimpleXMLElement;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SimpleXMLNode {
    private static final Logger log = Logger.getLogger(SimpleXMLNode.class.getName());
    private static final L10N L = new L10N(SimpleXMLNode.class);
    protected final QuercusClass _cls;
    protected final SimpleView _view;
    private SimpleNamespaceContext _xpathNamespaceContext;

    public SimpleXMLNode(QuercusClass cls, SimpleView view) {
        this._cls = cls;
        this._view = view;
    }

    @Name(value="getName")
    public String simplexml_getName() {
        return this._view.getNodeName();
    }

    public StringValue __toString(Env env) {
        String str = this._view.toString(env);
        StringValue sb = env.createStringBuilder();
        if (sb.isUnicode()) {
            sb.append(str);
        } else {
            byte[] bytes;
            String encoding = this._view.getEncoding();
            try {
                bytes = str.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new QuercusException(e);
            }
            sb.appendBytes(bytes, 0, bytes.length);
        }
        return sb;
    }

    public Value __getField(Env env, StringValue name) {
        SimpleView view = this._view.getField(env, name);
        if (view == null) {
            return NullValue.NULL;
        }
        SimpleXMLElement e = new SimpleXMLElement(this._cls, view);
        return e.wrapJava(env);
    }

    public void __setField(Env env, StringValue name, Value value) {
        SimpleView view = this._view.setField(env, name, value);
    }

    public Value __get(Env env, Value indexV) {
        SimpleView view = this._view.getIndex(env, indexV);
        if (view == null) {
            return NullValue.NULL;
        }
        SimpleXMLElement e = new SimpleXMLElement(this._cls, view);
        return e.wrapJava(env);
    }

    public void __set(Env env, StringValue nameV, StringValue value) {
        this._view.setIndex(env, nameV, value);
    }

    public int __count(Env env) {
        return this._view.getCount();
    }

    public SimpleXMLElement addChild(Env env, StringValue nameV, @Optional StringValue valueV, @Optional String namespace) {
        String value;
        String name;
        String encoding = this._view.getEncoding();
        try {
            name = nameV.toString(encoding);
            value = valueV.toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            return null;
        }
        SimpleView view = this._view.addChild(env, name, value, namespace);
        SimpleXMLElement e = new SimpleXMLElement(this._cls, view);
        return e;
    }

    public void addAttribute(Env env, StringValue nameV, @Optional StringValue valueV, @Optional String namespace) {
        String value;
        String name;
        String encoding = this._view.getEncoding();
        try {
            name = nameV.toString(encoding);
            value = valueV.toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            return;
        }
        if (namespace != null) {
            if (namespace.length() == 0) {
                namespace = null;
            } else if (name.indexOf(58) <= 0) {
                env.warning(L.l("Adding attributes with namespaces requires attribute name with a prefix"));
                return;
            }
        }
        this._view.addAttribute(env, name, value, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Value asXML(Env env, @Optional Value filename) {
        StringBuilder sb = new StringBuilder();
        if (!this._view.toXml(env, sb)) {
            return BooleanValue.FALSE;
        }
        String encoding = this._view.getEncoding();
        if (filename.isDefault()) {
            StringValue value = env.createStringBuilder();
            if (env.isUnicodeSemantics()) {
                value.append(sb.toString());
            } else {
                byte[] bytes;
                try {
                    bytes = sb.toString().getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    log.log(Level.FINE, e.getMessage(), e);
                    env.warning(e);
                    return BooleanValue.FALSE;
                }
                value.append(bytes);
            }
            return value;
        }
        Path path = env.lookupPwd(filename);
        WriteStream os = null;
        try {
            os = path.openWrite();
            byte[] bytes = sb.toString().getBytes(encoding);
            ((OutputStream)os).write(bytes);
            BooleanValue booleanValue = BooleanValue.TRUE;
            return booleanValue;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            if (os != null) {
                IoUtil.close(os);
            }
        }
    }

    public Value attributes(Env env, @Optional Value namespaceV, @Optional boolean isPrefix) {
        String namespace = null;
        if (!namespaceV.isNull() && (namespace = namespaceV.toString()) != null && namespace.length() == 0) {
            namespace = null;
        }
        AttributeListView view = this._view.getAttributes(namespace);
        SimpleXMLElement e = new SimpleXMLElement(this.getQuercusClass(), view);
        return e.wrapJava(env);
    }

    public Value children(Env env, @Optional Value namespaceV, @Optional boolean isPrefix) {
        String namespace = null;
        String prefix = null;
        if (!namespaceV.isNull()) {
            if (isPrefix) {
                prefix = namespaceV.toString();
                if (prefix != null && prefix.length() == 0) {
                    prefix = null;
                }
            } else {
                namespace = namespaceV.toString();
                if (namespace != null && namespace.length() == 0) {
                    namespace = null;
                }
            }
        }
        ChildrenView view = this._view.getChildren(namespace, prefix);
        SimpleXMLElement e = new SimpleXMLElement(this._cls, view);
        return e.wrapJava(env);
    }

    public ArrayValue getNamespaces(Env env, @Optional boolean isRecursive) {
        ArrayValueImpl array = new ArrayValueImpl();
        HashMap<String, String> usedMap = this._view.getNamespaces(isRecursive, false, true);
        for (Map.Entry<String, String> entry : usedMap.entrySet()) {
            StringValue key = env.createString(entry.getKey());
            StringValue value = env.createString(entry.getValue());
            ((ArrayValue)array).append(key, value);
        }
        return array;
    }

    public ArrayValue getDocNamespaces(Env env, @Optional boolean isRecursive, @Optional boolean isFromRoot) {
        ArrayValueImpl array = new ArrayValueImpl();
        HashMap<String, String> usedMap = this._view.getNamespaces(isRecursive, isFromRoot, false);
        for (Map.Entry<String, String> entry : usedMap.entrySet()) {
            StringValue key = env.createString(entry.getKey());
            StringValue value = env.createString(entry.getValue());
            ((ArrayValue)array).append(key, value);
        }
        return array;
    }

    public boolean registerXPathNamespace(Env env, String prefix, String ns) {
        if (this._xpathNamespaceContext == null) {
            this._xpathNamespaceContext = new SimpleNamespaceContext();
        }
        this._xpathNamespaceContext.addPrefix(prefix, ns);
        return true;
    }

    public Value xpath(Env env, String expression) {
        List<SimpleView> viewList;
        if (this._xpathNamespaceContext == null) {
            this._xpathNamespaceContext = new SimpleNamespaceContext();
        }
        if ((viewList = this._view.xpath(env, this._xpathNamespaceContext, expression)) == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        for (SimpleView view : viewList) {
            SimpleXMLElement e = new SimpleXMLElement(this._cls, view);
            Value value = e.wrapJava(env);
            array.append(value);
        }
        return array;
    }

    @JsonEncode
    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        this._view.jsonEncode(env, context, sb, this._cls);
    }

    protected QuercusClass getQuercusClass() {
        return this._cls;
    }

    protected Value wrapJava(Env env) {
        if (!"SimpleXMLElement".equals(this._cls.getName())) {
            return new ObjectExtJavaValue(env, this._cls, this, this._cls.getJavaClassDef());
        }
        return new JavaValue(env, this, this._cls.getJavaClassDef());
    }
}

