/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.VariableModule;
import com.caucho.quercus.lib.spl.ArrayAccess;
import com.caucho.quercus.lib.spl.Countable;
import com.caucho.quercus.lib.spl.Iterator;
import com.caucho.quercus.lib.spl.Serializable;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class SplObjectStorage
implements ArrayAccess,
Countable,
Iterator,
Serializable {
    private static L10N L = new L10N(SplObjectStorage.class);
    private HashMap<StringValue, ObjectEntry> _objMap = new HashMap();
    private ObjectEntry _head;
    private ObjectEntry _tail;
    private int _iterCount;
    private ObjectEntry _current;

    public void addAll(Env env, SplObjectStorage storage) {
        for (ObjectEntry entry = storage._head; entry != null; entry = entry.getNext()) {
            this.attachImpl(env, entry.getHash(), entry.getObject(), entry.getValue());
        }
    }

    public void attach(Env env, Value obj, @Optional Value value) {
        StringValue hash = this.getHash(env, obj);
        this.attachImpl(env, hash, obj, value);
    }

    private void attachImpl(Env env, StringValue hash, Value obj, Value value) {
        ObjectEntry entry = this._objMap.get(hash);
        if (entry == null) {
            entry = new ObjectEntry(hash, obj, value);
            if (this._tail != null) {
                this._tail.setNext(entry);
                entry.setPrev(this._tail);
            }
            this._tail = entry;
            if (this._head == null) {
                this._head = entry;
            }
        } else {
            entry.setObject(obj);
            entry.setValue(value);
        }
        this._objMap.put(hash, entry);
    }

    public boolean contains(Env env, Value obj) {
        StringValue hash = this.getHash(env, obj);
        return this._objMap.containsKey(hash);
    }

    @Override
    public int count(Env env) {
        return this._objMap.size();
    }

    public void detach(Env env, Value obj) {
        StringValue hash = this.getHash(env, obj);
        this.detachImpl(env, hash);
    }

    private void detachImpl(Env env, StringValue hash) {
        ObjectEntry entry = this._objMap.remove(hash);
        if (entry == null) {
            return;
        }
        ObjectEntry prev = entry.getPrev();
        ObjectEntry next = entry.getNext();
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        if (entry == this._tail) {
            this._tail = entry.getPrev();
        }
        if (entry == this._head) {
            this._head = entry.getNext();
        }
    }

    @Override
    public boolean offsetExists(Env env, Value offset) {
        StringValue hash = offset.toObject(env).getObjectHash(env);
        return this._objMap.containsKey(hash);
    }

    @Override
    public Value offsetSet(Env env, Value obj, Value value) {
        this.attach(env, obj, value);
        return NullValue.NULL;
    }

    @Override
    public Value offsetGet(Env env, Value obj) {
        StringValue hash = this.getHash(env, obj);
        ObjectEntry entry = this._objMap.get(hash);
        if (entry == null) {
            Value e = env.createException("UnexpectedValueException", L.l("{0} not found", (Object)hash));
            throw new QuercusLanguageException(e);
        }
        return entry.getValue();
    }

    @Override
    public Value offsetUnset(Env env, Value obj) {
        this.detach(env, obj);
        return NullValue.NULL;
    }

    @Override
    public Value current(Env env) {
        if (this._current == null) {
            return NullValue.NULL;
        }
        return this._current.getObject();
    }

    @Override
    public Value key(Env env) {
        return LongValue.create(this._iterCount);
    }

    @Override
    public void next(Env env) {
        if (this._current != null) {
            this._current = this._current.getNext();
            ++this._iterCount;
        }
    }

    @Override
    public void rewind(Env env) {
        this._current = this._head;
        this._iterCount = 0;
    }

    @Override
    public boolean valid(Env env) {
        return this._current != null;
    }

    public StringValue getHash(Env env, Value obj) {
        return obj.getObjectHash(env);
    }

    public Value getInfo() {
        if (this._current == null) {
            return NullValue.NULL;
        }
        return this._current.getValue();
    }

    public void setInfo(Value value) {
        if (this._current == null) {
            return;
        }
        this._current.setValue(value);
    }

    public void removeAll(Env env, SplObjectStorage storage) {
        for (StringValue hash : storage._objMap.keySet()) {
            this.detachImpl(env, hash);
        }
    }

    public void removeAllExcept(Env env, SplObjectStorage storage) {
        ArrayList<ObjectEntry> toRemoveList = new ArrayList<ObjectEntry>();
        for (ObjectEntry entry = this._head; entry != null; entry = entry.getNext()) {
            if (storage._objMap.containsKey(entry.getHash())) continue;
            toRemoveList.add(entry);
        }
        for (ObjectEntry listEntry : toRemoveList) {
            this.detachImpl(env, listEntry.getHash());
        }
    }

    @Override
    public StringValue serialize(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        StringValue objStr = env.createString("obj");
        StringValue valueStr = env.createString("inf");
        for (ObjectEntry entry = this._head; entry != null; entry = entry.getNext()) {
            ArrayValueImpl inner = new ArrayValueImpl();
            inner.put(objStr, entry.getObject());
            inner.put(valueStr, entry.getValue());
            array.append(inner);
        }
        String str = VariableModule.serialize(env, array);
        return env.createString(str);
    }

    @Override
    public void unserialize(Env env, StringValue str) {
        Value unserializedValue = VariableModule.unserialize(env, str);
        ArrayValue array = unserializedValue.toArrayValue(env);
        StringValue objStr = env.createString("obj");
        StringValue valueStr = env.createString("inf");
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            ArrayValue inner = entry.getValue().toArrayValue(env);
            Value obj = inner.get(objStr);
            Value value = inner.get(valueStr);
            this.attach(env, obj, value);
        }
    }

    private ArrayValue toArrayValue(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        StringValue objStr = env.createString("obj");
        StringValue valueStr = env.createString("inf");
        for (Map.Entry<StringValue, ObjectEntry> entry : this._objMap.entrySet()) {
            ArrayValueImpl inner = new ArrayValueImpl();
            inner.put(objStr, entry.getValue().getObject());
            inner.put(valueStr, entry.getValue().getValue());
            array.put(entry.getKey(), inner);
        }
        return array;
    }

    public void varDumpImpl(Env env, Value obj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        ArrayValue array = this.toArrayValue(env);
        array.varDump(env, out, depth, valueSet);
    }

    static class ObjectEntry {
        private final StringValue _hash;
        private Value _obj;
        private Value _value;
        private ObjectEntry _prev;
        private ObjectEntry _next;

        public ObjectEntry(StringValue hash, Value obj, Value value) {
            this._hash = hash;
            this._obj = obj;
            this._value = value;
        }

        public StringValue getHash() {
            return this._hash;
        }

        public Value getObject() {
            return this._obj;
        }

        public void setObject(Value obj) {
            this._obj = obj;
        }

        public Value getValue() {
            return this._value;
        }

        public void setValue(Value value) {
            this._value = value;
        }

        public ObjectEntry getPrev() {
            return this._prev;
        }

        public void setPrev(ObjectEntry entry) {
            this._prev = entry;
        }

        public ObjectEntry getNext() {
            return this._next;
        }

        public void setNext(ObjectEntry entry) {
            this._next = entry;
        }
    }
}

