/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class BinaryValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new BinaryValueMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        StringValue arg = value.toBinaryValue(env);
        assert (arg instanceof BinaryValue) : "" + value.getClass() + ".toBinaryValue() returned a " + arg.getClass();
        return arg;
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value instanceof BinaryBuilderValue) {
            return (BinaryBuilderValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toBinaryValue(env);
        }
        StringValue ret = env.createBinaryBuilder();
        ret.append(value);
        return ret;
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toBinaryValueMarshalCost();
    }

    @Override
    public Class getExpectedClass() {
        return BinaryValue.class;
    }
}

