/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class ByteObjectMarshal
extends Marshal {
    public static final Marshal MARSHAL = new ByteObjectMarshal();

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Byte((byte)expr.evalLong(env));
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaByte();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return LongValue.ZERO;
        }
        return LongValue.create(((Number)value).longValue());
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toByteMarshalCost() + 1;
    }

    @Override
    public Class getExpectedClass() {
        return Byte.class;
    }
}

