/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class CharacterObjectMarshal
extends Marshal {
    public static final Marshal MARSHAL = new CharacterObjectMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Character(expr.evalChar(env));
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaCharacter();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return env.createString(value.toString());
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isUnicode() && argValue.length() == 1) {
            return 100;
        }
        if (argValue.isString() && !argValue.isBinary() && argValue.length() == 1) {
            return 100;
        }
        if (argValue.isLongConvertible()) {
            return 300;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return Character.class;
    }
}

