/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaDateValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import java.util.Date;

public class DateMarshal
extends Marshal {
    public static final Marshal MARSHAL = new DateMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaDate();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        return env.wrapJava((Date)value);
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaDateValue) {
            return 0;
        }
        if (argValue instanceof LongValue) {
            return 300;
        }
        if (argValue.isLongConvertible()) {
            return 300;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return Date.class;
    }
}

