/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class DoubleObjectMarshal
extends Marshal {
    public static final Marshal MARSHAL = new DoubleObjectMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Double(expr.evalDouble(env));
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaDouble();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return DoubleValue.ZERO;
        }
        return new DoubleValue(((Number)value).doubleValue());
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toDoubleMarshalCost() + 1;
    }

    @Override
    public Class getExpectedClass() {
        return Double.class;
    }
}

