/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class DoubleValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new DoubleValueMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.eval(env).toDoubleValue();
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toDoubleValue();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value instanceof DoubleValue) {
            return (DoubleValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toDoubleValue();
        }
        return null;
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof DoubleValue) {
            return 0;
        }
        if (argValue.isLongConvertible()) {
            return 300;
        }
        if (argValue.isDoubleConvertible()) {
            return 300;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return DoubleValue.class;
    }
}

