/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class LongMarshal
extends Marshal {
    public static final Marshal MARSHAL = new LongMarshal();

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Long(expr.evalLong(env));
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return new Long(value.toLong());
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return LongValue.ZERO;
        }
        return LongValue.create(((Number)value).longValue());
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toLongMarshalCost();
    }

    @Override
    public Class getExpectedClass() {
        return Long.TYPE;
    }
}

