/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaURLValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import java.net.URL;

public class URLMarshal
extends Marshal {
    public static final Marshal MARSHAL = new URLMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaURL(env);
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        return env.wrapJava((URL)value);
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaURLValue) {
            return 0;
        }
        if (argValue.isString()) {
            return 300;
        }
        return 400;
    }

    @Override
    public int getMarshalingCost(Expr expr) {
        if (expr.isString()) {
            return 300;
        }
        return 0x3FFFFFF;
    }

    @Override
    public Class getExpectedClass() {
        return URL.class;
    }
}

