/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import java.util.HashMap;

public class IniDefinition {
    private L10N L = new L10N(IniDefinition.class);
    public static final int PHP_INI_USER = 1;
    public static final int PHP_INI_PERDIR = 2;
    public static final int PHP_INI_SYSTEM = 4;
    public static final int PHP_INI_ALL = 7;
    public static IniDefinition NULL = new Null();
    private final String _name;
    private final int _scope;
    private final Value _deflt;
    private final Type _type;

    public IniDefinition(String name, Type type, Value deflt, int scope) {
        assert (name != null);
        assert (deflt != null);
        assert (scope == 1 || scope == 2 || scope == 4 || scope == 7);
        this._name = name.intern();
        this._type = type;
        this._scope = scope;
        this._deflt = deflt;
    }

    protected String getName() {
        return this._name;
    }

    protected Value getDefault() {
        return this._deflt;
    }

    public int getScope() {
        return this._scope;
    }

    public boolean isRuntimeDefinition() {
        return false;
    }

    private static BooleanValue toBooleanValue(Value value) {
        if (value instanceof BooleanValue) {
            return (BooleanValue)value;
        }
        if (!(value instanceof StringValue)) {
            return BooleanValue.create(value.toBoolean());
        }
        String valueAsString = value.toString().trim();
        if (valueAsString.length() == 0 || valueAsString.equalsIgnoreCase("false") || valueAsString.equalsIgnoreCase("off") || valueAsString.equalsIgnoreCase("0")) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public void set(QuercusContext quercus, Value value) {
        this.set(quercus.getIniMap(true), 4, value);
    }

    public void set(QuercusContext quercus, String s) {
        ConstStringValue value = null;
        if (s != null) {
            value = new ConstStringValue(s);
        }
        this.set(quercus, value);
    }

    public void set(Env env, Value value) {
        this.set(env.getIniMap(true), 1, value);
    }

    public void set(Env env, String value) {
        this.set(env.getIniMap(true), 1, env.createString(value));
    }

    protected void set(HashMap<String, Value> map, int scope, Value value) {
        if (scope != 1 || this._scope == 1 || this._scope == 7) {
            if (this._type == Type.BOOLEAN) {
                map.put(this._name, IniDefinition.toBooleanValue(value));
            } else {
                map.put(this._name, value);
            }
        }
    }

    private Value get(HashMap<String, Value> envMap, HashMap<String, Value> quercusMap) {
        Value value = null;
        if (envMap != null) {
            value = envMap.get(this._name);
        }
        if (value == null && quercusMap != null) {
            value = quercusMap.get(this._name);
        }
        if (value == null) {
            value = this._deflt;
        }
        if (value == null) {
            value = NullValue.NULL;
        }
        return value;
    }

    public Value getValue(QuercusContext quercus) {
        return this.get(null, quercus.getIniMap(false));
    }

    public Value getValue(Env env) {
        return this.get(env.getIniMap(false), env.getQuercus().getIniMap(false));
    }

    public StringValue getAsStringValue(QuercusContext quercus) {
        return this.get(null, quercus.getIniMap(false)).toStringValue();
    }

    public StringValue getAsStringValue(Env env) {
        return this.getValue(env).toStringValue();
    }

    public String getAsString(Env env) {
        StringValue value = this.getAsStringValue(env);
        return value.length() == 0 ? null : value.toString();
    }

    public String getAsString(QuercusContext quercus) {
        StringValue value = this.getAsStringValue(quercus);
        return value.length() == 0 ? null : value.toString();
    }

    public boolean getAsBoolean(QuercusContext quercus) {
        return this.getAsBooleanValue(quercus).toBoolean();
    }

    public boolean getAsBoolean(Env env) {
        return this.getAsBooleanValue(env).toBoolean();
    }

    public BooleanValue getAsBooleanValue(QuercusContext quercus) {
        return this.getAsBooleanValue(null, quercus.getIniMap(false));
    }

    public BooleanValue getAsBooleanValue(Env env) {
        return this.getAsBooleanValue(env.getIniMap(false), env.getQuercus().getIniMap(false));
    }

    private BooleanValue getAsBooleanValue(HashMap<String, Value> overrideMap, HashMap<String, Value> iniMap) {
        Value value = this.get(overrideMap, iniMap);
        return IniDefinition.toBooleanValue(value);
    }

    public LongValue getAsLongValue(QuercusContext quercus) {
        return this.getAsLongValue(null, quercus.getIniMap(false));
    }

    public LongValue getAsLongValue(Env env) {
        return this.getAsLongValue(env.getIniMap(false), env.getQuercus().getIniMap(false));
    }

    private LongValue getAsLongValue(HashMap<String, Value> overrideMap, HashMap<String, Value> iniMap) {
        Value value = this.get(overrideMap, iniMap);
        if (value instanceof LongValue) {
            return (LongValue)value;
        }
        if (value instanceof BooleanValue) {
            return value.toBoolean() ? LongValue.ONE : LongValue.ZERO;
        }
        return LongValue.create(value.toLong());
    }

    public long getAsLong(Env env) {
        return this.getAsLongValue(env).toLong();
    }

    public long getAsLongBytes(Env env, long deflt) {
        char ch;
        String bytes = this.getAsString(env);
        if (bytes == null) {
            return deflt;
        }
        long value = 0L;
        long sign = 1L;
        int i = 0;
        int length = bytes.length();
        if (length == 0) {
            return deflt;
        }
        if (bytes.charAt(i) == '-') {
            sign = -1L;
            ++i;
        } else if (bytes.charAt(i) == '+') {
            ++i;
        }
        if (length <= i) {
            return deflt;
        }
        while (i < length && (ch = bytes.charAt(i)) >= '0' && ch <= '9') {
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        value = sign * value;
        if (bytes.endsWith("gb") || bytes.endsWith("g") || bytes.endsWith("G")) {
            return value * 1024L * 1024L * 1024L;
        }
        if (bytes.endsWith("mb") || bytes.endsWith("m") || bytes.endsWith("M")) {
            return value * 1024L * 1024L;
        }
        if (bytes.endsWith("kb") || bytes.endsWith("k") || bytes.endsWith("K")) {
            return value * 1024L;
        }
        if (bytes.endsWith("b") || bytes.endsWith("B")) {
            return value;
        }
        if (value < 0L) {
            return value;
        }
        return value;
    }

    public static class Runtime
    extends IniDefinition {
        public Runtime(String name) {
            super(name, Type.STRING, NullValue.NULL, 7);
        }

        @Override
        public boolean isRuntimeDefinition() {
            return true;
        }
    }

    private static class Null
    extends Unsupported {
        private L10N L = new L10N(Unsupported.class);

        public Null() {
            super("#null", Type.STRING, NullValue.NULL, 7);
        }

        @Override
        public void set(HashMap<String, Value> map, int scope, Value value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Unsupported
    extends IniDefinition {
        private L10N L = new L10N(Unsupported.class);

        public Unsupported(String name, Type type, Value deflt, int scope) {
            super(name, type, deflt, scope);
        }

        @Override
        public void set(HashMap<String, Value> map, int scope, Value value) {
            Env env = Env.getInstance();
            if (env == null) {
                return;
            }
            if (IniDefinition.toBooleanValue(value).equals(IniDefinition.toBooleanValue(this.getDefault()))) {
                return;
            }
            env.warning(this.L.l("ini value `{0}' is not supported", (Object)this.getName()));
        }
    }

    public static enum Type {
        BOOLEAN,
        STRING,
        LONG,
        ARRAY;

    }
}

