/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.config.ConfigException;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.marshal.MarshalFactory;
import com.caucho.quercus.module.ModuleInfo;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.quercus.module.StaticFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.quercus.program.JavaArrayClassDef;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModuleContext {
    private static L10N L = new L10N(ModuleContext.class);
    private static final Logger log = Logger.getLogger(ModuleContext.class.getName());
    private ClassLoader _loader;
    private ModuleContext _parent;
    private HashSet<URL> _serviceClassUrls = new HashSet();
    private HashSet<URL> _serviceModuleUrls = new HashSet();
    private HashMap<String, ModuleInfo> _moduleInfoMap = new HashMap();
    private HashSet<String> _extensionSet = new HashSet();
    private ClassDef _stdClassDef;
    private QuercusClass _stdClass;
    private HashMap<String, ClassDef> _staticClasses = new HashMap();
    private HashMap<String, JavaClassDef> _javaClassWrappers = new HashMap();
    private HashMap<String, HashSet<String>> _extensionClasses = new HashMap();
    protected MarshalFactory _marshalFactory;
    protected ExprFactory _exprFactory;
    private boolean _isUnicodeSemantics;

    private ModuleContext(ClassLoader loader) {
        this._loader = loader;
        this._marshalFactory = new MarshalFactory(this);
        this._exprFactory = new ExprFactory();
        String[] empty = new String[]{};
        this._stdClassDef = new InterpretedClassDef("stdClass", null, empty, empty);
        this._stdClass = new QuercusClass(this, this._stdClassDef, null);
        this._staticClasses.put(this._stdClass.getName(), this._stdClassDef);
    }

    public ModuleContext(ModuleContext parent, ClassLoader loader) {
        this(loader);
        this._parent = parent;
        if (parent != null) {
            this._serviceClassUrls.addAll(parent._serviceClassUrls);
            this._serviceModuleUrls.addAll(parent._serviceModuleUrls);
            this._moduleInfoMap.putAll(parent._moduleInfoMap);
            this._extensionSet.addAll(parent._extensionSet);
            this._staticClasses.putAll(parent._staticClasses);
            this._javaClassWrappers.putAll(parent._javaClassWrappers);
            this._extensionClasses.putAll(parent._extensionClasses);
        }
    }

    public boolean isUnicodeSemantics() {
        return this._isUnicodeSemantics;
    }

    public void setUnicodeSemantics(boolean isUnicodeSemantics) {
        this._isUnicodeSemantics = isUnicodeSemantics;
    }

    public StringValue createString(String s) {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue(s);
        }
        return new ConstStringValue(s);
    }

    public StringValue createStringBuilder() {
        if (this._isUnicodeSemantics) {
            return new UnicodeBuilderValue();
        }
        return new StringBuilderValue();
    }

    public boolean hasServiceClass(URL url) {
        return this._serviceClassUrls.contains(url);
    }

    public void addServiceClass(URL url) {
        this._serviceClassUrls.add(url);
    }

    public void addServiceModule(URL url) {
        this._serviceModuleUrls.add(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleInfo addModule(String name, QuercusModule module) throws ConfigException {
        ModuleContext moduleContext = this;
        synchronized (moduleContext) {
            ModuleInfo info = this._moduleInfoMap.get(name);
            if (info == null) {
                info = new ModuleInfo(name, module);
                this._moduleInfoMap.put(name, info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClassDef addClass(String name, Class<?> type, String extension, Class<?> javaClassDefClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            JavaClassDef def = this._javaClassWrappers.get(name);
            if (def == null) {
                if (log.isLoggable(Level.FINEST)) {
                    if (extension == null) {
                        log.finest(L.l("PHP loading class {0} with type {1}", (Object)name, (Object)type.getName()));
                    } else {
                        log.finest(L.l("PHP loading class {0} with type {1} providing extension {2}", (Object)name, (Object)type.getName(), (Object)extension));
                    }
                }
                if (javaClassDefClass != null) {
                    Constructor<?> constructor = javaClassDefClass.getConstructor(ModuleContext.class, String.class, Class.class);
                    def = (JavaClassDef)constructor.newInstance(this, name, type);
                } else {
                    def = JavaClassDef.create(this, name, type);
                    if (def == null) {
                        def = this.createDefaultJavaClassDef(name, type, extension);
                    }
                }
                def.setPhpClass(true);
                this._javaClassWrappers.put(name, def);
                this._staticClasses.put(name, def);
                if (extension != null) {
                    this._extensionSet.add(extension);
                }
            }
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClassDef getJavaClassDefinition(Class<?> type, String className) {
        JavaClassDef def;
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            def = this._javaClassWrappers.get(className);
            if (def != null) {
                return def;
            }
            def = JavaClassDef.create(this, className, type);
            if (def == null) {
                def = this.createDefaultJavaClassDef(className, type);
            }
            this._javaClassWrappers.put(className, def);
            this._javaClassWrappers.put(type.getName(), def);
        }
        return def;
    }

    public JavaClassDef getJavaClassDefinition(String className) {
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            JavaClassDef def = this._javaClassWrappers.get(className);
            if (def != null) {
                return def;
            }
            try {
                Class<?> type;
                try {
                    type = Class.forName(className, false, this._loader);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException(L.l("'{0}' is not a known Java class: {1}", (Object)className, (Object)e.toString()), e);
                }
                catch (NoClassDefFoundError e) {
                    throw new ClassNotFoundException(L.l("'{0}' cannot be as a Java class: {1}", (Object)className, (Object)e.toString()), e);
                }
                def = JavaClassDef.create(this, className, type);
                if (def == null) {
                    def = this.createDefaultJavaClassDef(className, type);
                }
                this._javaClassWrappers.put(className, def);
                this._javaClassWrappers.put(type.getName(), def);
                return def;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QuercusRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClassDef getJavaClassDefinition(Class javaClass) {
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            return this._javaClassWrappers.get(javaClass.getName());
        }
    }

    protected JavaClassDef createDefaultJavaClassDef(String className, Class type) {
        if (type.isArray()) {
            return new JavaArrayClassDef(this, className, type);
        }
        return new JavaClassDef(this, className, type);
    }

    protected JavaClassDef createDefaultJavaClassDef(String className, Class type, String extension) {
        if (type.isArray()) {
            return new JavaArrayClassDef(this, className, type, extension);
        }
        return new JavaClassDef(this, className, type, extension);
    }

    public MarshalFactory getMarshalFactory() {
        return this._marshalFactory;
    }

    public ExprFactory getExprFactory() {
        return this._exprFactory;
    }

    public QuercusClass getStdClass() {
        return this._stdClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, ClassDef> getClassMap() {
        HashMap<String, ClassDef> hashMap = this._staticClasses;
        synchronized (hashMap) {
            return new HashMap<String, ClassDef>(this._staticClasses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, JavaClassDef> getWrapperMap() {
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            return new HashMap<String, JavaClassDef>(this._javaClassWrappers);
        }
    }

    public QuercusModule findModule(String name) {
        ModuleInfo info = this._moduleInfoMap.get(name);
        if (info != null) {
            return info.getModule();
        }
        return null;
    }

    public boolean isExtensionLoaded(String name) {
        return this._extensionSet.contains(name);
    }

    public HashSet<String> getLoadedExtensions() {
        return this._extensionSet;
    }

    public void addExtensionClass(String ext, String clsName) {
        HashSet<String> list = this._extensionClasses.get(ext);
        if (list == null) {
            list = new HashSet();
            this._extensionClasses.put(ext, list);
        }
        list.add(clsName);
    }

    public HashSet<String> getExtensionClasses(String ext) {
        return this._extensionClasses.get(ext);
    }

    public StaticFunction createStaticFunction(QuercusModule module, Method method) {
        return new StaticFunction(this, module, method);
    }

    public void init() {
        this.initStaticFunctions();
        this.initStaticClassServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStaticFunctions() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            this.setContextClassLoader(this._loader);
            String quercusModule = "META-INF/quercus/com.caucho.quercus.QuercusModule";
            Enumeration<URL> urls = this._loader.getResources(quercusModule);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = null;
                ReadStream rs = null;
                try {
                    is = url.openStream();
                    rs = new ReadStream(new VfsStream(is, null));
                    this.parseServicesModule(rs);
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            this.setContextClassLoader(oldLoader);
        }
    }

    private void parseServicesModule(ReadStream in) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        String line;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while ((line = in.readLine()) != null) {
            int p = line.indexOf(35);
            if (p >= 0) {
                line = line.substring(0, p);
            }
            if ((line = line.trim()).length() <= 0) continue;
            String className = line;
            try {
                Class<?> cl;
                try {
                    cl = Class.forName(className, false, loader);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException(L.l("'{0}' not valid {1}", (Object)className, (Object)e.toString()));
                }
                this.introspectPhpModuleClass(cl);
            }
            catch (Throwable e) {
                if (className.startsWith("com.caucho")) {
                    log.log(Level.FINER, e.toString(), e);
                    continue;
                }
                log.info("Failed loading " + className + "\n" + e.toString());
                log.log(Level.INFO, e.toString(), e);
            }
        }
    }

    protected void setContextClassLoader(ClassLoader loader) {
        Thread thread = Thread.currentThread();
        ClassLoader currentLoader = thread.getContextClassLoader();
        if (loader != currentLoader) {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ModuleInfo> getModules() {
        HashMap<String, ModuleInfo> hashMap = this._moduleInfoMap;
        synchronized (hashMap) {
            return new ArrayList<ModuleInfo>(this._moduleInfoMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectPhpModuleClass(Class<?> cl) throws IllegalAccessException, InstantiationException, ConfigException, InvocationTargetException, NoSuchMethodException {
        HashMap<String, ModuleInfo> hashMap = this._moduleInfoMap;
        synchronized (hashMap) {
            QuercusModule module;
            if (this._moduleInfoMap.get(cl.getName()) != null) {
                return;
            }
            log.finest(this.getClass().getSimpleName() + " loading module " + cl.getName());
            try {
                Constructor<?> constructor = cl.getConstructor(new Class[0]);
                module = (QuercusModule)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new QuercusException(L.l("unable to instantiate Quercus module {0} because it does not have a default constructor", (Object)cl), e);
            }
            ModuleInfo moduleInfo = this.addModule(cl.getName(), module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStaticClassServices() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            String quercusModule = "META-INF/quercus/com.caucho.quercus.QuercusClass";
            Enumeration<URL> urls = loader.getResources(quercusModule);
            HashSet<URL> urlSet = new HashSet<URL>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (this.hasServiceClass(url)) continue;
                this.addServiceClass(url);
                urlSet.add(url);
            }
            for (URL url : urlSet) {
                InputStream is = null;
                ReadStream rs = null;
                try {
                    is = url.openStream();
                    rs = new ReadStream(new VfsStream(is, null));
                    this.parseClassServicesModule(rs);
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    private void parseClassServicesModule(ReadStream in) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, ConfigException, NoSuchMethodException, InvocationTargetException {
        String line;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while ((line = in.readLine()) != null) {
            int p = line.indexOf(35);
            if (p >= 0) {
                line = line.substring(0, p);
            }
            if ((line = line.trim()).length() == 0) continue;
            String[] args = line.split(" ");
            String className = args[0];
            try {
                Class<?> cl = Class.forName(className, false, loader);
                String phpClassName = null;
                String extension = null;
                String definedBy = null;
                for (int i = 1; i < args.length; ++i) {
                    if ("as".equals(args[i])) {
                        if (++i >= args.length) {
                            throw new IOException(L.l("expecting Quercus class name after '{0}' in definition for class {1}", (Object)"as", (Object)className));
                        }
                        phpClassName = args[i];
                        continue;
                    }
                    if ("provides".equals(args[i])) {
                        if (++i >= args.length) {
                            throw new IOException(L.l("expecting name of extension after '{0}' in definition for class {1}", (Object)"extension", (Object)className));
                        }
                        extension = args[i];
                        continue;
                    }
                    if ("definedBy".equals(args[i])) {
                        if (++i >= args.length) {
                            throw new IOException(L.l("expecting name of class implementing JavaClassDef after '{0}' in definition for class {1}", (Object)"definedBy", (Object)className));
                        }
                        definedBy = args[i];
                        continue;
                    }
                    throw new IOException(L.l("unknown token '{0}' in definition for class {1} ", (Object)args[i], (Object)className));
                }
                if (phpClassName == null) {
                    phpClassName = className.substring(className.lastIndexOf(46) + 1);
                }
                Class<?> javaClassDefClass = definedBy != null ? Class.forName(definedBy, false, loader) : null;
                this.introspectJavaClass(phpClassName, cl, extension, javaClassDefClass);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Failed loading " + className + "\n" + e.toString());
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspectJavaClass(String name, Class type, String extension, Class javaClassDefClass) throws IllegalAccessException, InstantiationException, ConfigException, NoSuchMethodException, InvocationTargetException {
        JavaClassDef def = this.addClass(name, type, extension, javaClassDefClass);
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            this._javaClassWrappers.put(name, def);
            this._javaClassWrappers.put(type.getName(), def);
        }
        if (extension != null) {
            this._extensionSet.add(extension);
        }
    }

    public void introspectJavaImplClass(String name, Class type, String extension) throws IllegalAccessException, InstantiationException, ConfigException {
        if (log.isLoggable(Level.FINEST)) {
            if (extension == null) {
                log.finest(L.l("Quercus loading class {0} with type {1}", (Object)name, (Object)type.getName()));
            } else {
                log.finest(L.l("Quercus loading class {0} with type {1} providing extension {2}", (Object)name, (Object)type.getName(), (Object)extension));
            }
        }
        try {
            JavaClassDef javaClassDef = this.addClass(name, type, extension, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private void initStaticClasses() {
    }

    public static Value objectToValue(Object obj) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (Byte.class.equals(obj.getClass()) || Short.class.equals(obj.getClass()) || Integer.class.equals(obj.getClass()) || Long.class.equals(obj.getClass())) {
            return LongValue.create(((Number)obj).longValue());
        }
        if (Float.class.equals(obj.getClass()) || Double.class.equals(obj.getClass())) {
            return DoubleValue.create(((Number)obj).doubleValue());
        }
        if (String.class.equals(obj.getClass())) {
            return new StringBuilderValue((String)obj);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._loader + "]";
    }
}

