/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.annotation.Construct;
import com.caucho.quercus.annotation.Delegates;
import com.caucho.quercus.annotation.EntrySet;
import com.caucho.quercus.annotation.Hide;
import com.caucho.quercus.annotation.Isset;
import com.caucho.quercus.annotation.JsonEncode;
import com.caucho.quercus.annotation.ResourceType;
import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.BigDecimalValue;
import com.caucho.quercus.env.BigIntegerValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.CountDelegate;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaCalendarValue;
import com.caucho.quercus.env.JavaConstructor;
import com.caucho.quercus.env.JavaDateValue;
import com.caucho.quercus.env.JavaMethod;
import com.caucho.quercus.env.JavaResourceValue;
import com.caucho.quercus.env.JavaURLValue;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.LiteralExpr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.spl.Serializable;
import com.caucho.quercus.marshal.JavaMarshal;
import com.caucho.quercus.marshal.Marshal;
import com.caucho.quercus.marshal.MarshalFactory;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.FunctionArrayDelegate;
import com.caucho.quercus.program.FunctionCountDelegate;
import com.caucho.quercus.program.InstanceInitializer;
import com.caucho.quercus.program.JavaCollectionClassDef;
import com.caucho.quercus.program.JavaListClassDef;
import com.caucho.quercus.program.JavaMapClassDef;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaClassDef
extends ClassDef
implements InstanceInitializer {
    private static final Logger log = Logger.getLogger(JavaClassDef.class.getName());
    private static final L10N L = new L10N(JavaClassDef.class);
    private final ModuleContext _moduleContext;
    private final String _name;
    private final Class<?> _type;
    private QuercusClass _quercusClass;
    private HashSet<String> _instanceOfSet;
    private HashSet<String> _instanceOfSetLowerCase;
    private final boolean _isAbstract;
    private final boolean _isInterface;
    private final boolean _isDelegate;
    private boolean _isPhpClass;
    private String _resourceType;
    private JavaClassDef _componentDef;
    protected volatile boolean _isInit;
    private final HashMap<String, Value> _constMap = new HashMap();
    private final HashMap<String, Object> _constJavaMap = new HashMap();
    private final MethodMap<AbstractJavaMethod> _functionMap = new MethodMap(null, this);
    private final HashMap<String, AbstractJavaMethod> _getMap = new HashMap();
    private final HashMap<String, AbstractJavaMethod> _setMap = new HashMap();
    private final HashMap<String, FieldMarshalPair> _fieldMap = new HashMap();
    private AbstractJavaMethod _cons;
    private AbstractJavaMethod __construct;
    private AbstractJavaMethod __destruct;
    private JavaMethod __fieldGet;
    private JavaMethod __fieldSet;
    private FunctionArrayDelegate _funArrayDelegate;
    private ArrayDelegate _arrayDelegate;
    private JavaMethod __call;
    private JavaMethod __callStatic;
    private JavaMethod __toString;
    private Method _printRImpl;
    private Method _varDumpImpl;
    private Method _jsonEncode;
    private Method _entrySet;
    private Method _isset;
    private TraversableDelegate _traversableDelegate;
    private CountDelegate _countDelegate;
    private AbstractFunction _serializeFun;
    private AbstractFunction _unserializeFun;
    private Method _iteratorMethod;
    private Marshal _marshal;
    private String _extension;

    public JavaClassDef(ModuleContext moduleContext, String name, Class<?> type) {
        super(null, name, null, ClassDef.NULL_STRING_ARRAY, ClassDef.NULL_STRING_ARRAY);
        this._moduleContext = moduleContext;
        this._name = name;
        this._type = type;
        this._isAbstract = Modifier.isAbstract(type.getModifiers());
        this._isInterface = type.isInterface();
        this._isDelegate = type.isAnnotationPresent(ClassImplementation.class);
        if (type.isArray() && !this.isArray()) {
            throw new IllegalStateException(L.l("'{0}' needs to be called with JavaArrayClassDef", (Object)type));
        }
    }

    public JavaClassDef(ModuleContext moduleContext, String name, Class<?> type, String extension) {
        this(moduleContext, name, type);
        this._extension = extension;
        moduleContext.addExtensionClass(extension, name);
    }

    private void fillInstanceOfSet(Class<?> type, boolean isTop) {
        if (type == null) {
            return;
        }
        if (isTop && this._isDelegate) {
            this._instanceOfSet.add(this._name);
            this._instanceOfSetLowerCase.add(this._name.toLowerCase(Locale.ENGLISH));
        } else {
            String name = type.getSimpleName();
            this._instanceOfSet.add(name);
            this._instanceOfSetLowerCase.add(name.toLowerCase(Locale.ENGLISH));
        }
        this.fillInstanceOfSet(type.getSuperclass(), false);
        Class<?>[] ifaceList = type.getInterfaces();
        if (ifaceList != null) {
            for (Class<?> iface : ifaceList) {
                this.fillInstanceOfSet(iface, false);
            }
        }
    }

    public static JavaClassDef create(ModuleContext moduleContext, String name, Class<?> type) {
        if (Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return new DoubleClassDef(moduleContext);
        }
        if (Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
            return new LongClassDef(moduleContext);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return new BigDecimalClassDef(moduleContext);
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return new BigIntegerClassDef(moduleContext);
        }
        if (String.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return new StringClassDef(moduleContext);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return new BooleanClassDef(moduleContext);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return new CalendarClassDef(moduleContext);
        }
        if (Date.class.isAssignableFrom(type)) {
            return new DateClassDef(moduleContext, type);
        }
        if (URL.class.isAssignableFrom(type)) {
            return new URLClassDef(moduleContext);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new JavaMapClassDef(moduleContext, name, (Class)type);
        }
        if (List.class.isAssignableFrom(type)) {
            return new JavaListClassDef(moduleContext, name, (Class)type);
        }
        if (Collection.class.isAssignableFrom(type) && !Queue.class.isAssignableFrom(type)) {
            return new JavaCollectionClassDef(moduleContext, name, (Class)type);
        }
        return null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getSimpleName() {
        return this._type.getSimpleName();
    }

    public Class<?> getType() {
        return this._type;
    }

    public String getResourceType() {
        return this._resourceType;
    }

    protected ModuleContext getModuleContext() {
        return this._moduleContext;
    }

    @Override
    public String getExtension() {
        return this._extension;
    }

    @Override
    public boolean isA(Env env, String name) {
        if (this._instanceOfSet == null) {
            this._instanceOfSet = new HashSet();
            this._instanceOfSetLowerCase = new HashSet();
            this.fillInstanceOfSet(this._type, true);
        }
        return this._instanceOfSet.contains(name) || this._instanceOfSetLowerCase.contains(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addInterfaces(HashSet<String> interfaceSet) {
        this.addInterfaces(interfaceSet, this._type, true);
    }

    protected void addInterfaces(HashSet<String> interfaceSet, Class<?> type, boolean isTop) {
        if (type == null) {
            return;
        }
        interfaceSet.add(this._name.toLowerCase(Locale.ENGLISH));
        interfaceSet.add(type.getSimpleName().toLowerCase(Locale.ENGLISH));
        if (type.getInterfaces() != null) {
            for (Class<?> iface : type.getInterfaces()) {
                this.addInterfaces(interfaceSet, iface, false);
            }
        }
        this.addInterfaces(interfaceSet, type.getSuperclass(), false);
    }

    private boolean hasInterface(String name, Class<?> type) {
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces != null) {
            for (Class<?> intfc : interfaces) {
                if (intfc.getSimpleName().equalsIgnoreCase(name)) {
                    return true;
                }
                if (!this.hasInterface(name, intfc)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this._isAbstract;
    }

    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return this._isInterface;
    }

    public boolean isDelegate() {
        return this._isDelegate;
    }

    public void setPhpClass(boolean isPhpClass) {
        this._isPhpClass = isPhpClass;
    }

    public boolean isPhpClass() {
        return this._isPhpClass;
    }

    public JavaClassDef getComponentDef() {
        if (this._componentDef == null) {
            Class<?> compType = this.getType().getComponentType();
            this._componentDef = this._moduleContext.getJavaClassDefinition(compType.getName());
        }
        return this._componentDef;
    }

    public Value wrap(Env env, Object obj) {
        if (!this._isInit) {
            this.init();
        }
        if (this._resourceType != null) {
            return new JavaResourceValue(env, obj, this);
        }
        return new JavaValue(env, obj, this);
    }

    private int cmpObject(Object lValue, Object rValue) {
        if (lValue == rValue) {
            return 0;
        }
        if (lValue == null) {
            return -1;
        }
        if (rValue == null) {
            return 1;
        }
        if (lValue instanceof Comparable) {
            if (!(rValue instanceof Comparable)) {
                return -1;
            }
            return ((Comparable)lValue).compareTo(rValue);
        }
        if (rValue instanceof Comparable) {
            return 1;
        }
        if (lValue.equals(rValue)) {
            return 0;
        }
        String lName = lValue.getClass().getName();
        String rName = rValue.getClass().getName();
        return lName.compareTo(rName);
    }

    public int cmpObject(Object lValue, Object rValue, JavaClassDef rClassDef) {
        int cmp = this.cmpObject(lValue, rValue);
        if (cmp != 0) {
            return cmp;
        }
        for (Map.Entry<String, FieldMarshalPair> lEntry : this._fieldMap.entrySet()) {
            String lFieldName = lEntry.getKey();
            FieldMarshalPair rFieldPair = rClassDef._fieldMap.get(lFieldName);
            if (rFieldPair == null) {
                return 1;
            }
            FieldMarshalPair lFieldPair = lEntry.getValue();
            try {
                Object rResult;
                Object lResult = lFieldPair._field.get(lValue);
                int resultCmp = this.cmpObject(lResult, rResult = rFieldPair._field.get(lValue));
                if (resultCmp == 0) continue;
                return resultCmp;
            }
            catch (IllegalAccessException e) {
                log.log(Level.FINE, e.getMessage(), e);
                return 0;
            }
        }
        return 0;
    }

    public Value getField(Env env, Value qThis, StringValue nameV) {
        AbstractFunction phpGet;
        String name = nameV.toString();
        AbstractJavaMethod get = this._getMap.get(name);
        if (get != null) {
            try {
                return get.callMethod(env, this.getQuercusClass(), qThis);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.getMessage(), e);
                return UnsetValue.UNSET;
            }
        }
        FieldMarshalPair fieldPair = this._fieldMap.get(name);
        if (fieldPair != null) {
            try {
                Object result = fieldPair._field.get(qThis.toJavaObject());
                return fieldPair._marshal.unmarshal(env, result);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.getMessage(), e);
                return UnsetValue.UNSET;
            }
        }
        QuercusClass qClass = null;
        if (qThis != null) {
            qClass = qThis.getQuercusClass();
        }
        if (qClass == null) {
            qClass = this.getQuercusClass();
        }
        if ((phpGet = qClass.getFieldGet()) != null) {
            return phpGet.callMethod(env, this.getQuercusClass(), qThis, (Value)nameV);
        }
        if (this.__fieldGet != null) {
            try {
                return this.__fieldGet.callMethod(env, this.getQuercusClass(), qThis, (Value)nameV);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.getMessage(), e);
                return UnsetValue.UNSET;
            }
        }
        return UnsetValue.UNSET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value putField(Env env, Value qThis, StringValue nameV, Value value) {
        AbstractFunction phpSet;
        String name = nameV.toString();
        AbstractJavaMethod setter = this._setMap.get(name);
        if (setter != null) {
            try {
                return setter.callMethod(env, this.getQuercusClass(), qThis, value);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.getMessage(), e);
                return NullValue.NULL;
            }
        }
        FieldMarshalPair fieldPair = this._fieldMap.get(name);
        if (fieldPair != null) {
            try {
                Class<?> type = fieldPair._field.getType();
                Object marshaledValue = fieldPair._marshal.marshal(env, value, type);
                fieldPair._field.set(qThis.toJavaObject(), marshaledValue);
                return value;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.getMessage(), e);
                return NullValue.NULL;
            }
        }
        if (!qThis.isFieldInit() && (phpSet = qThis.getQuercusClass().getFieldSet()) != null) {
            qThis.setFieldInit(true);
            try {
                Value value2 = phpSet.callMethod(env, this.getQuercusClass(), qThis, (Value)nameV, value);
                return value2;
            }
            finally {
                qThis.setFieldInit(false);
            }
        }
        if (this.__fieldSet != null) {
            try {
                return this.__fieldSet.callMethod(env, this.getQuercusClass(), qThis, (Value)nameV, value);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.getMessage(), e);
                return NullValue.NULL;
            }
        }
        return null;
    }

    public Marshal getMarshal() {
        return this._marshal;
    }

    @Override
    public Value callNew(Env env, Value[] args) {
        if (this._cons != null) {
            if (this.__construct != null) {
                Value value = this._cons.call(env, Value.NULL_ARGS);
                this.__construct.callMethod(env, this.__construct.getQuercusClass(), value, args);
                return value;
            }
            return this._cons.call(env, args);
        }
        if (this.__construct != null) {
            return this.__construct.call(env, args);
        }
        return NullValue.NULL;
    }

    @Override
    public AbstractFunction getCall() {
        return this.__call;
    }

    @Override
    public AbstractFunction getCallStatic() {
        return this.__callStatic;
    }

    @Override
    public AbstractFunction getSerialize() {
        return this._serializeFun;
    }

    @Override
    public AbstractFunction getUnserialize() {
        return this._unserializeFun;
    }

    public AbstractFunction findFunction(StringValue methodName) {
        return this._functionMap.getRaw(methodName);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value[] args) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, args);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1, a2);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1, a2, a3);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1, a2, a3, a4);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1, a2, a3, a4, a5);
    }

    public Set<? extends Map.Entry<Value, Value>> entrySet(Object obj) {
        try {
            if (this._entrySet == null) {
                return null;
            }
            return (Set)this._entrySet.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new QuercusException(e);
        }
    }

    @Override
    public void initClassMethods(QuercusClass cl, String bindingClassName) {
        this.init();
        cl.addInitializer(this);
        if (this._cons != null) {
            cl.setConstructor(this._cons);
            cl.addMethod(this._moduleContext.createString("__construct"), this._cons);
        }
        if (this.__construct != null) {
            cl.setConstructor(this.__construct);
            cl.addMethod(this._moduleContext.createString("__construct"), this.__construct);
        }
        if (this.__destruct != null) {
            cl.setDestructor(this.__destruct);
            cl.addMethod(this._moduleContext.createString("__destruct"), this.__destruct);
        }
        for (AbstractJavaMethod value : this._functionMap.values()) {
            cl.addMethod(this._moduleContext.createString(value.getName()), value);
        }
        if (this.__fieldGet != null) {
            cl.setFieldGet(this.__fieldGet);
        }
        if (this.__fieldSet != null) {
            cl.setFieldSet(this.__fieldSet);
        }
        if (this.__call != null) {
            cl.setCall(this.__call);
        }
        if (this.__callStatic != null) {
            cl.setCallStatic(this.__callStatic);
        }
        if (this.__toString != null) {
            cl.addMethod(this._moduleContext.createString("__toString"), this.__toString);
        }
        if (this._arrayDelegate != null) {
            cl.setArrayDelegate(this._arrayDelegate);
        } else if (this._funArrayDelegate != null) {
            cl.setArrayDelegate(this._funArrayDelegate);
        }
        if (this._serializeFun != null) {
            cl.setSerialize(this._serializeFun, this._unserializeFun);
        }
        if (this._traversableDelegate != null) {
            cl.setTraversableDelegate(this._traversableDelegate);
        } else if (cl.getTraversableDelegate() == null && this._iteratorMethod != null) {
            cl.setTraversableDelegate(new JavaTraversableDelegate(this._iteratorMethod));
        }
        if (this._countDelegate != null) {
            cl.setCountDelegate(this._countDelegate);
        }
    }

    @Override
    public void initClassFields(QuercusClass cl, String bindingClassName) {
        for (Map.Entry<String, Value> entry : this._constMap.entrySet()) {
            cl.addConstant(this._moduleContext.createString(entry.getKey()), new LiteralExpr(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this._constJavaMap.entrySet()) {
            cl.addJavaConstant(this._moduleContext.createString(entry.getKey()), entry.getValue());
        }
    }

    public Value findConstant(Env env, String name) {
        return this._constMap.get(name);
    }

    @Override
    public void initInstance(Env env, Value value, boolean isInitFieldValues) {
        if (value instanceof ObjectValue) {
            ObjectValue object = (ObjectValue)value;
            if (this.__destruct != null) {
                env.addObjectCleanup(object);
            }
        }
    }

    public QuercusClass getQuercusClass() {
        if (this._quercusClass == null) {
            this.init();
            this._quercusClass = new QuercusClass(this._moduleContext, this, null);
        }
        return this._quercusClass;
    }

    @Override
    public AbstractFunction findConstructor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void init() {
        if (this._isInit) {
            return;
        }
        JavaClassDef javaClassDef = this;
        synchronized (javaClassDef) {
            if (this._isInit) {
                return;
            }
            super.init();
            try {
                this.initInterfaceList(this._type);
                this.introspect();
            }
            finally {
                this._isInit = true;
            }
        }
    }

    private void initInterfaceList(Class<?> type) {
        Class<?>[] ifaces = type.getInterfaces();
        if (ifaces == null) {
            return;
        }
        for (Class<?> iface : ifaces) {
            JavaClassDef javaClassDef = this._moduleContext.getJavaClassDefinition(iface);
            if (javaClassDef != null) {
                this.addInterface(javaClassDef.getName());
            }
            this.initInterfaceList(iface);
        }
    }

    private void introspect() {
        this.introspectConstants(this._type);
        this.introspectEnums(this._type);
        this.introspectMethods(this._moduleContext, this._type);
        this.introspectFields(this._moduleContext, this._type);
        this._marshal = new JavaMarshal(this, false);
        AbstractJavaMethod consMethod = this.getConsMethod();
        if (consMethod != null) {
            if (consMethod.isStatic()) {
                this._cons = consMethod;
            } else {
                this.__construct = consMethod;
            }
        }
        if (Serializable.class.equals(this._type)) {
            this._serializeFun = this.findFunction(Serializable.SERIALIZE);
            this._unserializeFun = this.findFunction(Serializable.UNSERIALIZE);
        }
        if (this._cons == null) {
            Constructor<?>[] cons = this._type.getConstructors();
            if (cons.length > 0) {
                int i;
                for (i = 0; i < cons.length && !cons[i].isAnnotationPresent(Construct.class); ++i) {
                }
                if (i < cons.length) {
                    this._cons = new JavaConstructor(this._moduleContext, this, cons[i]);
                } else {
                    this._cons = new JavaConstructor(this._moduleContext, this, cons[0]);
                    for (i = 1; i < cons.length; ++i) {
                        this._cons = this._cons.overload(new JavaConstructor(this._moduleContext, this, cons[i]));
                    }
                }
            } else {
                this._cons = null;
            }
        }
        if (this._cons != null) {
            this._cons.setConstructor(true);
        }
        if (this.__construct != null) {
            this.__construct.setConstructor(true);
        }
        this.introspectAnnotations(this._type);
    }

    private void introspectAnnotations(Class<?> type) {
        try {
            if (type == null) {
                return;
            }
            for (Class<?> iface : type.getInterfaces()) {
                this.introspectAnnotations(iface);
            }
            this.introspectAnnotations(type.getSuperclass());
            for (Annotation annotation : type.getAnnotations()) {
                if (annotation.annotationType() == Delegates.class) {
                    Class<?>[] delegateClasses;
                    for (Class<?> cl : delegateClasses = ((Delegates)annotation).value()) {
                        boolean isDelegate = this.addDelegate(cl);
                        if (isDelegate) continue;
                        throw new IllegalArgumentException(L.l("unknown @Delegate class '{0}'", (Object)cl));
                    }
                    continue;
                }
                if (annotation.annotationType() != ResourceType.class) continue;
                this._resourceType = ((ResourceType)annotation).value();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InstantiationException e) {
            throw new QuercusModuleException(e.getCause());
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    private boolean addDelegate(Class<?> cl) throws InstantiationException, IllegalAccessException {
        boolean isDelegate = false;
        if (TraversableDelegate.class.isAssignableFrom(cl)) {
            this._traversableDelegate = (TraversableDelegate)cl.newInstance();
            isDelegate = true;
        }
        if (ArrayDelegate.class.isAssignableFrom(cl)) {
            this._arrayDelegate = (ArrayDelegate)cl.newInstance();
            isDelegate = true;
        }
        if (CountDelegate.class.isAssignableFrom(cl)) {
            this._countDelegate = (CountDelegate)cl.newInstance();
            isDelegate = true;
        }
        return isDelegate;
    }

    private <T> boolean addDelegate(Class<T> cl, ArrayList<T> delegates, Class<? extends Object> delegateClass) {
        if (!cl.isAssignableFrom(delegateClass)) {
            return false;
        }
        for (T delegate : delegates) {
            if (delegate.getClass() != delegateClass) continue;
            return true;
        }
        try {
            delegates.add(delegateClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new QuercusModuleException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusModuleException(e);
        }
        return true;
    }

    private AbstractJavaMethod getConsMethod() {
        for (AbstractJavaMethod method : this._functionMap.values()) {
            if (!method.getName().equals("__construct")) continue;
            return method;
        }
        return null;
    }

    private void introspectFields(ModuleContext moduleContext, Class<?> type) {
        Field[] fields;
        Method[] methods;
        if (type == null) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        for (Method method : methods = type.getMethods()) {
            AbstractJavaMethod newGetter;
            AbstractJavaMethod existingGetter;
            String quercusName;
            String methodName;
            int length;
            if (Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(Hide.class) || (length = (methodName = method.getName()).length()) <= 3) continue;
            if (methodName.startsWith("get")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(3, length));
                existingGetter = this._getMap.get(quercusName);
                newGetter = new JavaMethod(moduleContext, this, method);
                if (existingGetter != null) {
                    newGetter = existingGetter.overload(newGetter);
                }
                this._getMap.put(quercusName, newGetter);
                continue;
            }
            if (methodName.startsWith("is")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(2, length));
                existingGetter = this._getMap.get(quercusName);
                newGetter = new JavaMethod(moduleContext, this, method);
                if (existingGetter != null) {
                    newGetter = existingGetter.overload(newGetter);
                }
                this._getMap.put(quercusName, newGetter);
                continue;
            }
            if (methodName.startsWith("set")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(3, length));
                AbstractJavaMethod existingSetter = this._setMap.get(quercusName);
                AbstractJavaMethod newSetter = new JavaMethod(moduleContext, this, method);
                if (existingSetter != null) {
                    newSetter = existingSetter.overload(newSetter);
                }
                this._setMap.put(quercusName, newSetter);
                continue;
            }
            if ("__get".equals(methodName)) {
                if (this._funArrayDelegate == null) {
                    this._funArrayDelegate = new FunctionArrayDelegate();
                }
                this._funArrayDelegate.setArrayGet(new JavaMethod(moduleContext, this, method));
                continue;
            }
            if ("__set".equals(methodName)) {
                if (this._funArrayDelegate == null) {
                    this._funArrayDelegate = new FunctionArrayDelegate();
                }
                this._funArrayDelegate.setArrayPut(new JavaMethod(moduleContext, this, method));
                continue;
            }
            if ("__count".equals(methodName)) {
                FunctionCountDelegate delegate = new FunctionCountDelegate();
                delegate.setCount(new JavaMethod(moduleContext, this, method));
                this._countDelegate = delegate;
                continue;
            }
            if ("__getField".equals(methodName)) {
                this.__fieldGet = new JavaMethod(moduleContext, this, method);
                continue;
            }
            if ("__setField".equals(methodName)) {
                this.__fieldSet = new JavaMethod(moduleContext, this, method);
                continue;
            }
            if ("__fieldGet".equals(methodName)) {
                this.__fieldGet = new JavaMethod(moduleContext, this, method);
                continue;
            }
            if (!"__fieldSet".equals(methodName)) continue;
            this.__fieldSet = new JavaMethod(moduleContext, this, method);
        }
        for (Field field : fields = type.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Hide.class)) continue;
            MarshalFactory factory = moduleContext.getMarshalFactory();
            Marshal marshal = factory.create(field.getType(), false);
            this._fieldMap.put(field.getName(), new FieldMarshalPair(field, marshal));
        }
    }

    private String javaToQuercusConvert(String s) {
        if (s.length() == 1) {
            char ch = Character.toLowerCase(s.charAt(0));
            return String.valueOf(ch);
        }
        if (Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toLowerCase(s.charAt(0)));
        int length = s.length();
        for (int i = 1; i < length; ++i) {
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private void introspectConstants(Class<?> type) {
        Field[] fields;
        if (type == null) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        for (Field field : fields = type.getFields()) {
            if (this._constMap.get(field.getName()) != null || this._constJavaMap.get(field.getName()) != null || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || field.isAnnotationPresent(Hide.class)) continue;
            try {
                Object obj = field.get(null);
                Value value = QuercusContext.objectToValue(obj);
                if (value != null) {
                    this._constMap.put(field.getName().intern(), value);
                    continue;
                }
                this._constJavaMap.put(field.getName().intern(), obj);
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    private void introspectEnums(Class<?> type) {
        Class<?>[] classes;
        if (type == null) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        for (Class<?> cls : classes = type.getClasses()) {
            ?[] constants;
            String name;
            if (!cls.isEnum() || this._constMap.get(name = cls.getSimpleName()) != null || this._constJavaMap.get(name) != null || cls.isAnnotationPresent(Hide.class) || (constants = cls.getEnumConstants()).length == 0) continue;
            Object obj = constants[0];
            try {
                Value value = QuercusContext.objectToValue(obj);
                if (value != null) {
                    this._constMap.put(name.intern(), value);
                    continue;
                }
                this._constJavaMap.put(name.intern(), obj);
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    private void introspectMethods(ModuleContext moduleContext, Class<?> type) {
        Method[] methods;
        if (type == null) {
            return;
        }
        for (Method method : methods = type.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.isAnnotationPresent(Hide.class) || this._isPhpClass && method.getDeclaringClass() == Object.class) continue;
            if ("iterator".equals((method = this.findInterfaceMethod(method, type)).getName()) && method.getParameterTypes().length == 0 && Iterator.class.isAssignableFrom(method.getReturnType())) {
                this._iteratorMethod = method;
            }
            if ("printRImpl".equals(method.getName())) {
                this._printRImpl = method;
                continue;
            }
            if ("varDumpImpl".equals(method.getName())) {
                this._varDumpImpl = method;
                continue;
            }
            if (method.isAnnotationPresent(JsonEncode.class)) {
                this._jsonEncode = method;
                continue;
            }
            if (method.isAnnotationPresent(Isset.class)) {
                this._isset = method;
                continue;
            }
            if (method.isAnnotationPresent(EntrySet.class)) {
                this._entrySet = method;
                continue;
            }
            if ("__call".equals(method.getName())) {
                this.__call = new JavaMethod(moduleContext, this, method);
                continue;
            }
            if ("__callStatic".equals(method.getName())) {
                this.__callStatic = new JavaMethod(moduleContext, this, method);
                continue;
            }
            if ("__toString".equals(method.getName())) {
                this.__toString = new JavaMethod(moduleContext, this, method);
                this._functionMap.put(this._moduleContext.createString(method.getName()), this.__toString);
                continue;
            }
            if ("__destruct".equals(method.getName())) {
                this.__destruct = new JavaMethod(moduleContext, this, method);
                this._functionMap.put(this._moduleContext.createString(method.getName()), this.__destruct);
                continue;
            }
            if (method.getName().startsWith("quercus_")) {
                throw new UnsupportedOperationException(L.l("{0}: use @Name instead", (Object)method.getName()));
            }
            JavaMethod newFun = new JavaMethod(moduleContext, this, method);
            String funName = newFun.getName();
            StringValue nameV = moduleContext.createString(funName);
            AbstractJavaMethod fun = this._functionMap.getRaw(nameV);
            fun = fun != null ? fun.overload(newFun) : newFun;
            this._functionMap.put(nameV, fun);
        }
    }

    private Method findInterfaceMethod(Method method, Class<?> type) {
        if (type == null) {
            return method;
        }
        for (Class<?> iface : type.getInterfaces()) {
            for (Method subMethod : iface.getMethods()) {
                if (!subMethod.getName().equals(method.getName()) || !Arrays.equals(subMethod.getParameterTypes(), method.getParameterTypes())) continue;
                return subMethod;
            }
        }
        return this.findInterfaceMethod(method, type.getSuperclass());
    }

    public JavaMethod getToString() {
        return this.__toString;
    }

    public StringValue toString(Env env, JavaValue value) {
        if (this.__toString == null) {
            return null;
        }
        QuercusClass cls = this.getQuercusClass();
        Value str = this.__toString.callMethod(env, cls, (Value)value, Expr.NULL_ARGS);
        return str.toStringValue(env);
    }

    public boolean issetField(Env env, Object obj, StringValue name) {
        if (this._isset == null) {
            return false;
        }
        try {
            Object result = this._isset.invoke(obj, env, name);
            return !Boolean.FALSE.equals(result);
        }
        catch (InvocationTargetException e) {
            throw new QuercusRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public boolean jsonEncode(Env env, Object obj, JsonEncodeContext context, StringValue sb) {
        if (this._jsonEncode == null) {
            return false;
        }
        try {
            this._jsonEncode.invoke(obj, env, context, sb);
            return true;
        }
        catch (InvocationTargetException e) {
            throw new QuercusRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public boolean printRImpl(Env env, Object obj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        try {
            if (this._printRImpl == null) {
                return false;
            }
            this._printRImpl.invoke(obj, env, out, depth, valueSet);
            return true;
        }
        catch (InvocationTargetException e) {
            throw new QuercusRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public boolean varDumpImpl(Env env, Value obj, Object javaObj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        try {
            if (this._varDumpImpl == null) {
                return false;
            }
            this._varDumpImpl.invoke(javaObj, env, obj, out, depth, valueSet);
            return true;
        }
        catch (InvocationTargetException e) {
            throw new QuercusRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    private static class URLClassDef
    extends JavaClassDef {
        URLClassDef(ModuleContext module) {
            super(module, "URL", URL.class);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            return new JavaURLValue(env, (URL)obj, (JavaClassDef)this);
        }
    }

    private static class DateClassDef
    extends JavaClassDef {
        DateClassDef(ModuleContext module, Class<?> type) {
            super(module, type.getSimpleName(), type);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            return new JavaDateValue(env, (Date)obj, (JavaClassDef)this);
        }
    }

    private static class CalendarClassDef
    extends JavaClassDef {
        CalendarClassDef(ModuleContext module) {
            super(module, "Calendar", Calendar.class);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            return new JavaCalendarValue(env, (Calendar)obj, (JavaClassDef)this);
        }
    }

    private static class BooleanClassDef
    extends JavaClassDef {
        BooleanClassDef(ModuleContext module) {
            super(module, "Boolean", Boolean.class);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            if (Boolean.TRUE.equals(obj)) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }

    private static class StringClassDef
    extends JavaClassDef {
        StringClassDef(ModuleContext module) {
            super(module, "String", String.class);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            return env.createString((String)obj);
        }
    }

    private static class BigDecimalClassDef
    extends JavaClassDef {
        BigDecimalClassDef(ModuleContext module) {
            super(module, "BigDecimal", BigDecimal.class);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            return new BigDecimalValue(env, (BigDecimal)obj, (JavaClassDef)this);
        }
    }

    private static class BigIntegerClassDef
    extends JavaClassDef {
        BigIntegerClassDef(ModuleContext module) {
            super(module, "BigInteger", BigInteger.class);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            return new BigIntegerValue(env, (BigInteger)obj, (JavaClassDef)this);
        }
    }

    private static class DoubleClassDef
    extends JavaClassDef {
        DoubleClassDef(ModuleContext module) {
            super(module, "Double", Double.class);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            return new DoubleValue(((Number)obj).doubleValue());
        }
    }

    private static class LongClassDef
    extends JavaClassDef {
        LongClassDef(ModuleContext module) {
            super(module, "Long", Long.class);
        }

        @Override
        public Value wrap(Env env, Object obj) {
            return LongValue.create(((Number)obj).longValue());
        }
    }

    private class FieldMarshalPair {
        public Field _field;
        public Marshal _marshal;

        public FieldMarshalPair(Field field, Marshal marshal) {
            this._field = field;
            this._marshal = marshal;
        }
    }

    private class MethodMarshalPair {
        public Method _method;
        public Marshal _marshal;

        public MethodMarshalPair(Method method, Marshal marshal) {
            this._method = method;
            this._marshal = marshal;
        }
    }

    private class JavaEntry
    implements Map.Entry<Value, Value> {
        private Value _key;
        private Value _value;

        public JavaEntry(Value key, Value value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public Value getKey() {
            return this._key;
        }

        @Override
        public Value getValue() {
            return this._value;
        }

        @Override
        public Value setValue(Value value) {
            throw new UnsupportedOperationException();
        }
    }

    private class JavaIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private Env _env;
        private Iterator<?> _iterator;
        private int _index;

        public JavaIterator(Env env, Iterator<?> iterator) {
            this._env = env;
            this._iterator = iterator;
        }

        @Override
        public Map.Entry<Value, Value> next() {
            Object next = this._iterator.next();
            int index = this._index++;
            if (next instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)next;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key instanceof Value && value instanceof Value) {
                    return entry;
                }
                if (key instanceof Value) {
                    Value v = this._env.wrapJava(value);
                    return new JavaEntry((Value)key, v);
                }
                Value k = this._env.wrapJava(key);
                return new JavaEntry(k, this._env.wrapJava(value));
            }
            return new JavaEntry(LongValue.create(index), this._env.wrapJava(next));
        }

        @Override
        public boolean hasNext() {
            if (this._iterator != null) {
                return this._iterator.hasNext();
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class JavaValueIterator
    implements Iterator<Value> {
        private Env _env;
        private Iterator<?> _iterator;

        public JavaValueIterator(Env env, Iterator<?> iterator) {
            this._env = env;
            this._iterator = iterator;
        }

        @Override
        public Value next() {
            Object next = this._iterator.next();
            if (next instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)next;
                Object value = entry.getValue();
                if (value instanceof Value) {
                    return (Value)value;
                }
                return this._env.wrapJava(value);
            }
            return this._env.wrapJava(next);
        }

        @Override
        public boolean hasNext() {
            if (this._iterator != null) {
                return this._iterator.hasNext();
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class JavaKeyIterator
    implements Iterator<Value> {
        private Iterator<?> _iterator;
        private int _index;

        public JavaKeyIterator(Iterator<?> iterator) {
            this._iterator = iterator;
        }

        @Override
        public Value next() {
            this._iterator.next();
            return LongValue.create(this._index++);
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class JavaTraversableDelegate
    implements TraversableDelegate {
        private Method _iteratorMethod;

        public JavaTraversableDelegate(Method iterator) {
            this._iteratorMethod = iterator;
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> getIterator(Env env, ObjectValue qThis) {
            try {
                Object javaObj = qThis.toJavaObject();
                Iterator iterator = (Iterator)this._iteratorMethod.invoke(javaObj, new Object[0]);
                return new JavaIterator(env, iterator);
            }
            catch (InvocationTargetException e) {
                throw new QuercusRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new QuercusRuntimeException(e);
            }
        }

        @Override
        public Iterator<Value> getKeyIterator(Env env, ObjectValue qThis) {
            try {
                Object javaObj = qThis.toJavaObject();
                Iterator iterator = (Iterator)this._iteratorMethod.invoke(javaObj, new Object[0]);
                return new JavaKeyIterator(iterator);
            }
            catch (InvocationTargetException e) {
                throw new QuercusRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new QuercusRuntimeException(e);
            }
        }

        @Override
        public Iterator<Value> getValueIterator(Env env, ObjectValue qThis) {
            try {
                Object javaObj = qThis.toJavaObject();
                Iterator iterator = (Iterator)this._iteratorMethod.invoke(javaObj, new Object[0]);
                return new JavaValueIterator(env, iterator);
            }
            catch (InvocationTargetException e) {
                throw new QuercusRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new QuercusRuntimeException(e);
            }
        }
    }
}

