/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.env.StringValue;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TraitAliasMap {
    private final HashMap<StringValue, TraitAlias> _aliasMap = new HashMap();

    public void put(StringValue funName, StringValue funNameAlias, String traitName) {
        TraitAlias alias = new TraitAlias(traitName, funNameAlias);
        this._aliasMap.put(funName.toLowerCase(Locale.ENGLISH), alias);
    }

    public StringValue get(StringValue funName, String traitName) {
        TraitAlias alias = this._aliasMap.get(funName.toLowerCase(Locale.ENGLISH));
        if (alias == null) {
            return null;
        }
        if (alias.getTraitName().equalsIgnoreCase(traitName)) {
            return alias.getFunNameAlias();
        }
        return null;
    }

    public Set<Map.Entry<StringValue, TraitAlias>> entrySet() {
        return this._aliasMap.entrySet();
    }

    static class TraitAlias {
        private final String _traitName;
        private final StringValue _funNameAlias;

        public TraitAlias(String traitName, StringValue funNameAlias) {
            this._traitName = traitName;
            this._funNameAlias = funNameAlias;
        }

        public String getTraitName() {
            return this._traitName;
        }

        public StringValue getFunNameAlias() {
            return this._funNameAlias;
        }
    }
}

