/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng;

import com.caucho.relaxng.VerifierFilter;
import com.caucho.relaxng.VerifierHandler;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.Xml;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Verifier {
    private static final Logger log = Logger.getLogger(Verifier.class.getName());

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract VerifierHandler getVerifierHandler();

    public VerifierFilter getVerifierFilter() {
        return new VerifierFilter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(String url) throws IOException, SAXException {
        Path path = Vfs.lookup(url);
        try (ReadStream is = path.openRead();){
            Xml xml = new Xml();
            VerifierHandler handler = this.getVerifierHandler();
            xml.setContentHandler(handler);
            xml.parse(is);
            boolean bl = handler.isValid();
            return bl;
        }
    }

    public void error(SAXParseException e) throws SAXException {
        log.log(Level.FINE, e.toString(), e);
    }
}

