/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.RingItem;
import com.caucho.util.RingItemFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RingQueue<T extends RingItem> {
    private static final Logger log = Logger.getLogger(RingQueue.class.getName());
    private final T[] _ring;
    private final AtomicInteger _headAlloc = new AtomicInteger();
    private final AtomicInteger _head = new AtomicInteger();
    private final AtomicInteger _tailAlloc = new AtomicInteger();
    private final AtomicInteger _tail = new AtomicInteger();
    private final int _mask;
    private final int _updateSize;
    private final AtomicBoolean _isWait = new AtomicBoolean();

    public RingQueue(int capacity, RingItemFactory<T> itemFactory) {
        int size;
        for (size = 8; size < capacity; size *= 2) {
        }
        this._ring = new RingItem[size];
        this._mask = size - 1;
        this._updateSize = size >> 2;
        for (int i = 0; i < this._ring.length; ++i) {
            this._ring[i] = itemFactory.createItem(i);
        }
    }

    public boolean isEmpty() {
        return this._head.get() == this._tail.get();
    }

    public int getSize() {
        int head = this._head.get();
        int tail = this._tail.get();
        return this._ring.length + head - tail & this._mask;
    }

    public int getHead() {
        return this._head.get();
    }

    public int getHeadAlloc() {
        return this._headAlloc.get();
    }

    public int getTail() {
        return this._tail.get();
    }

    public int getTailAlloc() {
        return this._tailAlloc.get();
    }

    public final T beginOffer(boolean isWait) {
        int headAlloc;
        AtomicInteger headAllocRef = this._headAlloc;
        AtomicInteger tailRef = this._tail;
        int mask = this._mask;
        int retry = 256;
        while (true) {
            int tail;
            int nextHeadAlloc;
            if ((nextHeadAlloc = (headAlloc = headAllocRef.get()) + 1 & mask) == (tail = tailRef.get())) {
                if (!isWait) {
                    return null;
                }
                this.waitForAvailable(headAlloc, tail);
                continue;
            }
            if (headAllocRef.compareAndSet(headAlloc, nextHeadAlloc)) break;
        }
        return this._ring[headAlloc];
    }

    public final void completeOffer(T item) {
        ((RingItem)item).setRingValue();
        this.completeOffer(((RingItem)item).getIndex());
    }

    private void completeOffer(int index) {
        int head;
        AtomicInteger headRef = this._head;
        int mask = this._mask;
        int nextHead = index + 1 & mask;
        if (headRef.compareAndSet(index, nextHead)) {
            return;
        }
        AtomicInteger headAllocRef = this._headAlloc;
        T[] ring = this._ring;
        do {
            int headAlloc;
            if ((head = headRef.get()) != (headAlloc = headAllocRef.get())) continue;
            return;
        } while (!((RingItem)ring[head]).isRingValue() || !headRef.compareAndSet(head, nextHead = head + 1 & mask));
    }

    public final T beginPoll() {
        int nextTail;
        int tailAlloc;
        AtomicInteger tailAllocRef = this._tailAlloc;
        AtomicInteger headRef = this._head;
        int mask = this._mask;
        do {
            tailAlloc = tailAllocRef.get();
            int head = headRef.get();
            if (head != tailAlloc) continue;
            return null;
        } while (!tailAllocRef.compareAndSet(tailAlloc, nextTail = tailAlloc + 1 & mask));
        return this._ring[tailAlloc];
    }

    public final void completePoll(T item) {
        ((RingItem)item).clearRingValue();
        this.completePoll(((RingItem)item).getIndex());
    }

    private void completePoll(int index) {
        int tailAlloc;
        int tail;
        AtomicInteger tailRef = this._tail;
        int mask = this._mask;
        int nextTail = index + 1 & mask;
        if (tailRef.compareAndSet(index, nextTail)) {
            this.wakeAvailable();
            return;
        }
        AtomicInteger tailAllocRef = this._tailAlloc;
        T[] ring = this._ring;
        while ((tail = tailRef.get()) != (tailAlloc = tailAllocRef.get()) && (((RingItem)ring[tail]).isRingValue() || !tailRef.compareAndSet(tail, nextTail = tail + 1 & mask))) {
        }
        this.wakeAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAvailable(int headAlloc, int tail) {
        this._isWait.set(true);
        if (this._headAlloc.get() == headAlloc && this._tail.get() == tail) {
            AtomicBoolean atomicBoolean = this._isWait;
            synchronized (atomicBoolean) {
                if (this._headAlloc.get() == headAlloc && this._tail.get() == tail && this._isWait.get()) {
                    try {
                        this._isWait.wait(100L);
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                }
            }
        }
    }

    private boolean isFull() {
        int tail;
        int head = this._head.get();
        int nextHead = head + 1 & this._mask;
        return nextHead == (tail = this._tail.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeAvailable() {
        if (this._isWait.compareAndSet(true, false)) {
            AtomicBoolean atomicBoolean = this._isWait;
            synchronized (atomicBoolean) {
                this._isWait.notifyAll();
            }
        }
    }
}

