/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.connection;

import com.caucho.amber.AmberException;
import com.caucho.amber.AmberManager;
import com.caucho.amber.AmberQuery;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.collection.AmberCollection;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityFactory;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.entity.RowInvalidateCompletion;
import com.caucho.amber.entity.TableInvalidateCompletion;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.QueryCacheKey;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.amber.query.UserQuery;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmberConnectionImpl {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/connection/AmberConnectionImpl"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/connection/AmberConnectionImpl"));
    protected AmberManager _amberManager;
    private ArrayList<Entity> _entities = new ArrayList();
    private ArrayList<Entity> _txEntities = new ArrayList();
    private ArrayList<AmberCompletion> _completionList = new ArrayList();
    private ArrayList<AmberCollection> _queries = new ArrayList();
    private long _xid;
    private boolean _isInTransaction;
    private boolean _isXA;
    private Connection _conn;
    private boolean _isAutoCommit = true;
    private LruCache<String, PreparedStatement> _preparedStatementMap = new LruCache(32);
    private ArrayList<Statement> _statements = new ArrayList();
    private QueryCacheKey _queryKey = new QueryCacheKey();

    public AmberConnectionImpl(AmberManager amberManager) {
        this._amberManager = amberManager;
    }

    public AmberManager getAmberManager() {
        return this._amberManager;
    }

    public void register(AmberCollection query) {
        this._queries.add(query);
    }

    public void addCompletion(AmberCompletion completion) {
        if (!this._completionList.contains(completion)) {
            this._completionList.add(completion);
        }
    }

    public boolean isInTransaction() {
        return this._isInTransaction;
    }

    public int getCacheChunkSize() {
        return 25;
    }

    public Object load(Class cl, Object key) throws AmberException {
        Entity entity = this.getEntity(cl, key);
        if (entity != null) {
            return entity;
        }
        AmberEntityHome entityHome = this._amberManager.getEntityHome(cl.getName());
        if (entityHome == null) {
            return null;
        }
        try {
            entityHome.init();
        }
        catch (ConfigException e) {
            throw new AmberException(e);
        }
        entity = entityHome.load(this, key);
        this.addEntity(entity);
        return entity;
    }

    public Object load(String entityName, Object key) throws AmberException {
        AmberEntityHome entityHome = this._amberManager.getEntityHome(entityName);
        if (entityHome == null) {
            return null;
        }
        Entity entity = this.getEntity(entityHome.getEntityType().getBeanClass(), key);
        if (entity != null) {
            return entity;
        }
        try {
            entityHome.init();
        }
        catch (ConfigException e) {
            throw new AmberException(e);
        }
        entity = entityHome.load(this, key);
        this.addEntity(entity);
        return entity;
    }

    public Entity getEntity(EntityItem item) {
        Entity itemEntity = item.getEntity();
        EntityType entityType = itemEntity.__caucho_getEntityType();
        Entity entity = this.getEntity(entityType.getBeanClass(), itemEntity.__caucho_getPrimaryKey());
        if (entity != null) {
            return entity;
        }
        entity = item.copy(this);
        this.addEntity(entity);
        return entity;
    }

    public Object makePersistent(Object obj) throws SQLException {
        Entity entity = (Entity)obj;
        if (entity == null) {
            throw new NullPointerException();
        }
        Class<?> cl = entity.getClass();
        AmberEntityHome entityHome = this._amberManager.getEntityHome(entity.getClass().getName());
        if (entityHome == null) {
            throw new AmberException(L.l("entity has no matching home"));
        }
        entityHome.makePersistent(entity, this, false);
        return entity;
    }

    public Entity loadLazy(Class cl, String name, Object key) {
        if (key == null) {
            return null;
        }
        Entity entity = this.getEntity(cl, key);
        try {
            Entity obj;
            AmberEntityHome home = this._amberManager.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", cl.getName()));
            }
            home.init();
            entity = obj = home.loadLazy(this, key);
            this.addEntity(entity);
            return entity;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
        catch (ConfigException e) {
            throw new AmberRuntimeException(e);
        }
    }

    public EntityItem findEntityItem(String name, Object key) {
        try {
            AmberEntityHome home = this._amberManager.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", name));
            }
            home.init();
            return home.findEntityItem(this._amberManager.getCacheConnection(), key, false);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public EntityItem setEntityItem(String name, Object key, EntityItem item) {
        try {
            AmberEntityHome home = this._amberManager.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", name));
            }
            home.init();
            return home.setEntityItem(key, item);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public Object loadProxy(String name, Object key) {
        if (key == null) {
            return null;
        }
        AmberEntityHome home = this._amberManager.getEntityHome(name);
        if (home == null) {
            throw new RuntimeException(L.l("no matching home for {0}", name));
        }
        return this.loadProxy(home.getEntityType(), key);
    }

    public Object loadProxy(EntityType type, Object key) {
        if (key == null) {
            return null;
        }
        try {
            AmberEntityHome home = type.getHome();
            EntityItem item = home.findEntityItem(this, key, false);
            if (item == null) {
                return null;
            }
            EntityFactory factory = home.getEntityFactory();
            Object entity = factory.getEntity(this, item);
            return entity;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public Object load(Class cl, long intKey) throws AmberException {
        AmberEntityHome entityHome = this._amberManager.getEntityHome(cl.getName());
        if (entityHome == null) {
            return null;
        }
        Object key = entityHome.toObjectKey(intKey);
        return this.load(cl, key);
    }

    public Object loadLazy(Class cl, long intKey) throws AmberException {
        AmberEntityHome entityHome = this._amberManager.getEntityHome(cl.getName());
        if (entityHome == null) {
            return null;
        }
        Object key = entityHome.toObjectKey(intKey);
        return this.loadLazy(cl, cl.getName(), key);
    }

    public Entity getEntity(Class cl, Object key) {
        for (int i = this._entities.size() - 1; i >= 0; --i) {
            Entity entity = this._entities.get(i);
            if (!entity.__caucho_match(cl, key)) continue;
            return entity;
        }
        return null;
    }

    public void addEntity(Entity entity) {
        if (!this._entities.contains(entity)) {
            this._entities.add(entity);
            if (this._isInTransaction) {
                this._txEntities.add(entity);
            }
        }
    }

    public void beginTransaction() throws SQLException {
        this._isInTransaction = true;
        if (this._conn != null && this._isAutoCommit) {
            this._isAutoCommit = false;
            this._conn.setAutoCommit(false);
        }
    }

    public void setXA(boolean isXA) {
        this._isXA = isXA;
        this._isInTransaction = isXA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        System.out.println("COMMIT:");
        try {
            this.flush();
            this._xid = 0L;
            if (this._conn != null) {
                this._conn.commit();
            }
        }
        finally {
            if (!this._isXA) {
                this._isInTransaction = false;
            }
            for (int i = 0; i < this._txEntities.size(); ++i) {
                Entity entity = this._txEntities.get(i);
                entity.__caucho_afterCommit();
            }
            this._txEntities.clear();
        }
    }

    public void beforeCommit() throws SQLException {
        for (int i = 0; i < this._txEntities.size(); ++i) {
            Entity entity = this._txEntities.get(i);
            entity.__caucho_flush();
        }
    }

    public void afterCommit(boolean isCommit) {
        if (!this._isXA) {
            this._isInTransaction = false;
        }
        if (isCommit && this._completionList.size() > 0) {
            this._amberManager.complete(this._completionList);
        }
        this._completionList.clear();
        for (int i = 0; i < this._txEntities.size(); ++i) {
            Entity entity = this._txEntities.get(i);
            try {
                if (isCommit) {
                    entity.__caucho_afterCommit();
                    continue;
                }
                entity.__caucho_afterRollback();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        this._txEntities.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        try {
            this.flush();
            this._xid = 0L;
            if (this._conn != null) {
                this._conn.rollback();
            }
        }
        finally {
            if (!this._isXA) {
                this._isInTransaction = false;
            }
            this._completionList.clear();
            for (int i = 0; i < this._txEntities.size(); ++i) {
                Entity entity = this._txEntities.get(i);
                entity.__caucho_afterRollback();
            }
            this._txEntities.clear();
        }
    }

    public void flush() throws SQLException {
        Entity entity;
        int i;
        for (i = 0; i < this._txEntities.size(); ++i) {
            entity = this._txEntities.get(i);
            entity.__caucho_flush();
        }
        if (!this.isInTransaction()) {
            if (this._completionList.size() > 0) {
                this._amberManager.complete(this._completionList);
            }
            this._completionList.clear();
            for (i = 0; i < this._txEntities.size(); ++i) {
                entity = this._txEntities.get(i);
                entity.__caucho_afterCommit();
            }
            this._txEntities.clear();
        }
    }

    public void expire() throws SQLException {
        for (int i = 0; i < this._entities.size(); ++i) {
            Entity entity = this._entities.get(i);
            entity.__caucho_expire();
        }
    }

    public Connection getConnection() throws SQLException {
        if (this._conn == null) {
            this._conn = this._amberManager.getDataSource().getConnection();
            this._isAutoCommit = true;
        } else if (this._conn.isClosed()) {
            this.closeConnectionImpl();
            this._conn = this._amberManager.getDataSource().getConnection();
            this._isAutoCommit = true;
        }
        if (!this._isXA) {
            if (this._isInTransaction && this._isAutoCommit) {
                this._isAutoCommit = false;
                this._conn.setAutoCommit(false);
            } else if (!this._isInTransaction && !this._isAutoCommit) {
                this._isAutoCommit = true;
                this._conn.setAutoCommit(true);
            }
        }
        return this._conn;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            Connection conn = this.getConnection();
            PreparedStatement pstmt = this._preparedStatementMap.get(sql);
            if (pstmt == null) {
                pstmt = conn.prepareStatement(sql);
                this._statements.add(pstmt);
                this._preparedStatementMap.put(sql, pstmt);
            }
            return pstmt;
        }
        catch (SQLException e) {
            this.closeConnectionImpl();
            throw e;
        }
    }

    public PreparedStatement prepareInsertStatement(String sql) throws SQLException {
        PreparedStatement pstmt = this._preparedStatementMap.get(sql);
        if (pstmt == null) {
            Connection conn = this.getConnection();
            pstmt = this._amberManager.hasReturnGeneratedKeys() ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this._statements.add(pstmt);
            this._preparedStatementMap.put(sql, pstmt);
        }
        return pstmt;
    }

    public void makeTransactional(Entity entity) {
    }

    public void update(Object obj) {
    }

    public void create(Object obj) throws SQLException {
        AmberEntityHome home = null;
        for (Class<?> cl = obj.getClass(); home == null && cl != null; cl = cl.getSuperclass()) {
            home = this._amberManager.getHome(cl);
        }
        if (home == null) {
            throw new AmberException(L.l("`{0}' is not a known entity class.", obj.getClass().getName()));
        }
        this.create(home, obj);
    }

    public void create(String homeName, Object obj) throws SQLException {
        AmberEntityHome home = this._amberManager.getEntityHome(homeName);
        if (home == null) {
            throw new AmberException(L.l("`{0}' is not a known entity class.", obj.getClass().getName()));
        }
        this.create(home, obj);
    }

    public void create(AmberEntityHome home, Object obj) throws SQLException {
        home.save(this, (Entity)obj);
        this._txEntities.add((Entity)obj);
        Table table = home.getEntityType().getTable();
        this.addCompletion(new TableInvalidateCompletion(table.getName()));
    }

    public void update(Entity entity) {
        Table table = entity.__caucho_getEntityType().getTable();
        this.addCompletion(new RowInvalidateCompletion(table.getName(), entity.__caucho_getPrimaryKey()));
        if (!this._txEntities.contains(entity)) {
            this._txEntities.add(entity);
        }
    }

    public void delete(Object obj) throws SQLException {
        if (!(obj instanceof Entity)) {
            return;
        }
        Entity entity = (Entity)obj;
        entity.__caucho_delete();
    }

    public AmberQuery prepareQuery(String queryString) throws AmberException {
        return this.prepareQuery(queryString, false);
    }

    public AmberQuery prepareLazyQuery(String queryString) throws AmberException {
        return this.prepareQuery(queryString, true);
    }

    public AmberQuery prepareUpdate(String queryString) throws AmberException {
        return this.prepareQuery(queryString, true);
    }

    private AmberQuery prepareQuery(String queryString, boolean isLazy) throws AmberException {
        AbstractQuery queryProgram = this.parseQuery(queryString, isLazy);
        UserQuery query = new UserQuery(queryProgram);
        query.setSession(this);
        return query;
    }

    public AbstractQuery parseQuery(String queryString, boolean isLazy) throws AmberException {
        try {
            this._amberManager.initEntityHomes();
        }
        catch (Exception e) {
            throw AmberRuntimeException.create(e);
        }
        QueryParser parser = new QueryParser(queryString);
        parser.setAmberManager(this._amberManager);
        parser.setLazyResult(isLazy);
        return parser.parse();
    }

    public ResultSet query(String hsql) throws SQLException {
        AmberQuery query = this.prepareQuery(hsql);
        return query.executeQuery();
    }

    public ResultSetCacheChunk getQueryCacheChunk(String sql, Object[] args, int startRow) {
        this._queryKey.init(sql, args, startRow);
        return this._amberManager.getQueryChunk(this._queryKey);
    }

    public void putQueryCacheChunk(String sql, Object[] args, int startRow, ResultSetCacheChunk cacheChunk) {
        QueryCacheKey key = new QueryCacheKey();
        Object[] newArgs = new Object[args.length];
        System.arraycopy(args, 0, newArgs, 0, args.length);
        key.init(sql, newArgs, startRow);
        this._amberManager.putQueryChunk(key, cacheChunk);
    }

    public int update(String hsql) throws SQLException {
        AmberQuery query = this.prepareUpdate(hsql);
        return query.executeUpdate();
    }

    public List find(String hsql) throws SQLException {
        AmberQuery query = this.prepareQuery(hsql);
        return query.list();
    }

    public List find(String query, Object value) throws SQLException {
        return null;
    }

    public List find(String query, Object[] values) throws SQLException {
        return null;
    }

    public Iterator iterate(String query) throws SQLException {
        return null;
    }

    public Iterator iterate(String query, Object value) throws SQLException {
        return null;
    }

    public Iterator iterate(String query, Object[] values) throws SQLException {
        return null;
    }

    public void cleanup() {
        try {
            this.flush();
        }
        catch (SQLException e) {
            throw new AmberRuntimeException(e);
        }
        finally {
            this._entities.clear();
            this._txEntities.clear();
            this._completionList.clear();
            this.freeConnection();
        }
    }

    public void pushDepth() {
    }

    public void popDepth() {
    }

    public void freeConnection() {
        this.closeConnectionImpl();
    }

    private void closeConnectionImpl() {
        Connection conn = this._conn;
        this._conn = null;
        boolean isAutoCommit = this._isAutoCommit;
        this._isAutoCommit = true;
        try {
            if (conn != null && !isAutoCommit) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this._preparedStatementMap.clear();
            this._statements.clear();
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return "AmberConnectionImpl[]";
    }

    public void finalize() {
        this.cleanup();
    }
}

