/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.AmberManager;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractField
implements AmberField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/AbstractField"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/AbstractField"));
    private EntityType _sourceType;
    private String _name;
    private Class _javaType;
    private Method _getterMethod;
    private Method _setterMethod;
    private boolean _isLazy;
    private int _updateIndex;
    private int _loadGroupIndex;

    AbstractField(EntityType sourceType) {
        this._sourceType = sourceType;
        this._loadGroupIndex = sourceType.getDefaultLoadGroupIndex();
    }

    AbstractField(EntityType sourceType, String name) throws ConfigException {
        this(sourceType);
        this.setName(name);
    }

    public void setName(String name) throws ConfigException {
        this._name = name;
        if (!this.getSourceType().isFieldAccess()) {
            char ch = name.charAt(0);
            if (Character.isLowerCase(ch)) {
                name = new StringBuffer().append(Character.toUpperCase(ch)).append(name.substring(1)).toString();
            }
            String getter = new StringBuffer().append("get").append(name).toString();
            String setter = new StringBuffer().append("set").append(name).toString();
            this._getterMethod = EntityType.getGetter(this.getBeanClass(), getter);
            if (this._getterMethod == null) {
                throw new ConfigException(L.l("{0}: {1} has no matching getter.", (Object)this.getBeanClass().getName(), name));
            }
            this._javaType = this._getterMethod.getReturnType();
            this._setterMethod = EntityType.getSetter(this.getBeanClass(), setter);
        } else {
            Field field = EntityType.getField(this.getBeanClass(), name);
            if (field == null) {
                throw new ConfigException(L.l("{0}: {1} has no matching field.", (Object)this.getBeanClass().getName(), name));
            }
            this._javaType = field.getType();
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    protected void setJavaType(Class type) {
        this._javaType = type;
    }

    @Override
    public EntityType getSourceType() {
        return this._sourceType;
    }

    public Class getBeanClass() {
        return this.getSourceType().getBeanClass();
    }

    @Override
    public Table getTable() {
        return this.getSourceType().getTable();
    }

    @Override
    public int getIndex() {
        return this._updateIndex;
    }

    @Override
    public void setIndex(int index) {
        this._updateIndex = index;
    }

    @Override
    public int getLoadGroupIndex() {
        return this._loadGroupIndex;
    }

    public void setLazy(boolean isLazy) {
        this._isLazy = isLazy;
    }

    @Override
    public Method getGetterMethod() {
        return this._getterMethod;
    }

    @Override
    public String getGetterName() {
        if (this.getSourceType().isFieldAccess()) {
            return new StringBuffer().append("__caucho_get_").append(this.getName()).toString();
        }
        return this._getterMethod.getName();
    }

    @Override
    public String getJavaTypeName() {
        return this.getJavaTypeName(this.getJavaType());
    }

    private String getJavaTypeName(Class cl) {
        if (cl.isArray()) {
            return new StringBuffer().append(this.getJavaTypeName(cl.getComponentType())).append("[]").toString();
        }
        return cl.getName();
    }

    @Override
    public Class getJavaType() {
        return this._javaType;
    }

    @Override
    public Method getSetterMethod() {
        return this._setterMethod;
    }

    @Override
    public String getSetterName() {
        if (this.getSourceType().isFieldAccess()) {
            return new StringBuffer().append("__caucho_set_").append(this.getName()).toString();
        }
        if (this._setterMethod != null) {
            return this._setterMethod.getName();
        }
        return new StringBuffer().append("set").append(this.getGetterName().substring(3)).toString();
    }

    public boolean isFieldAccess() {
        return this.getSourceType().isFieldAccess();
    }

    @Override
    public boolean isAbstract() {
        if (this.getSourceType().isFieldAccess()) {
            return true;
        }
        if (this._getterMethod == null) {
            return false;
        }
        return Modifier.isAbstract(this._getterMethod.getModifiers());
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public void init() throws ConfigException {
        if (this._isLazy) {
            this._loadGroupIndex = this.getSourceType().nextLoadGroupIndex();
        }
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        if (this.isAbstract()) {
            out.println();
            out.print("public ");
            out.printClass(this.getJavaType());
            out.print(new StringBuffer().append(" ").append(this.getFieldName()).append(";").toString());
        }
    }

    @Override
    public String generateLoadSelect(Table table, String id) {
        return null;
    }

    @Override
    public String generateSelect(String id) {
        return null;
    }

    @Override
    public String generateWhere(String id) {
        return null;
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
    }

    @Override
    public void generateUpdate(JavaWriter out, String mask, String pstmt, String index) throws IOException {
        out.println();
        out.println(new StringBuffer().append("if ((").append(mask).append(" & ").append(1L << this.getIndex()).append("L) != 0) {").toString());
        out.pushDepth();
        this.generateSet(out, pstmt, index);
        out.popDepth();
        out.println("}");
    }

    @Override
    public boolean hasLoadGroup(int index) {
        return index == this._loadGroupIndex;
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return index;
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        if (this.getGetterMethod() == null || this.getSetterMethod() == null) {
            return;
        }
        String getter = this.getGetterName();
        out.println(new StringBuffer().append("if ((__caucho_loadMask & ").append(1L << this.getLoadGroupIndex()).append("L) != 0)").toString());
        out.print("  ");
        out.println(new StringBuffer().append("  ").append(this.generateSuperSetter(this.generateGet(obj))).append(";").toString());
    }

    @Override
    public void generateSet(JavaWriter out, String obj) throws IOException {
        out.println(new StringBuffer().append(this.generateSuperSetter(obj)).append(";").toString());
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        out.println(new StringBuffer().append(this.generateSuperSetter(this.generateGet(obj))).append(";").toString());
    }

    @Override
    public void generateGet(JavaWriter out, String value) throws IOException {
        out.print(this.generateGet(value));
    }

    public String generateNull() {
        return "null";
    }

    @Override
    public String generateGet(String obj) {
        if (obj == null) {
            return this.generateNull();
        }
        if (obj.equals("super")) {
            return this.generateSuperGetter();
        }
        if (!this.isAbstract()) {
            return new StringBuffer().append(obj).append(".").append(this._getterMethod.getName()).append("()").toString();
        }
        if (this._getterMethod != null) {
            return new StringBuffer().append(obj).append(".").append(this._getterMethod.getName()).append("()").toString();
        }
        return new StringBuffer().append(obj).append(".").append(this.getFieldName()).toString();
    }

    @Override
    public String generateSet(String obj, String value) {
        if (obj.equals("super")) {
            return this.generateSuperSetter(value);
        }
        if (this.isAbstract()) {
            return new StringBuffer().append(obj).append(".").append(this.getFieldName()).append(" = ").append(value).toString();
        }
        return new StringBuffer().append(obj).append(".").append(this._setterMethod.getName()).append("(").append(value).append(")").toString();
    }

    protected String getFieldName() {
        return new StringBuffer().append("__amber_").append(this.getName()).toString();
    }

    public final String generateInsert() {
        return null;
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
    }

    @Override
    public void generateSetProperty(JavaWriter out) throws IOException {
    }

    @Override
    public String generateSuperGetter() {
        return new StringBuffer().append("__caucho_super_get_").append(this.getName()).append("()").toString();
    }

    @Override
    public String generateSuperSetter(String value) {
        return new StringBuffer().append("__caucho_super_set_").append(this.getName()).append("(").append(value).append(")").toString();
    }

    @Override
    public void generateSuperGetter(JavaWriter out) throws IOException {
        out.println();
        out.println(new StringBuffer().append("public final ").append(this.getJavaTypeName()).append(" __caucho_super_get_").append(this.getName()).append("()").toString());
        out.println("{");
        out.pushDepth();
        if (this.isAbstract() || this.getGetterMethod() == null) {
            out.println(new StringBuffer().append("return ").append(this.getFieldName()).append(";").toString());
        } else {
            out.println(new StringBuffer().append("return super.").append(this.getGetterName()).append("();").toString());
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSuperSetter(JavaWriter out) throws IOException {
        out.println();
        out.println(new StringBuffer().append("public final void __caucho_super_set_").append(this.getName()).append("(").append(this.getJavaTypeName()).append(" v)").toString());
        out.println("{");
        out.pushDepth();
        if (this.isAbstract() || this.getGetterMethod() == null) {
            out.println(new StringBuffer().append(this.getFieldName()).append(" = v;").toString());
        } else if (this.getSetterMethod() != null) {
            out.println(new StringBuffer().append("super.").append(this.getSetterMethod().getName()).append("(v);").toString());
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateCreateTableSQL(AmberManager manager) {
        return null;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index) throws IOException {
        this.generateSet(out, pstmt, index, "super");
    }

    @Override
    public void generateInsertSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        this.generateSet(out, pstmt, index, obj);
    }

    @Override
    public void generateUpdateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        this.generateSet(out, pstmt, index, obj);
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getIndex() == updateIndex) {
            String value = this.generateGet(src);
            out.println(new StringBuffer().append(this.generateSet(dst, value)).append(";").toString());
        }
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
        if (this.getLoadGroupIndex() == loadIndex) {
            String value = this.generateGet(src);
            out.println(new StringBuffer().append(this.generateSet(dst, value)).append(";").toString());
        }
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
    }

    @Override
    public String toObject(String value) {
        return value;
    }

    @Override
    public void link() {
    }

    @Override
    public void generatePreDelete(JavaWriter out) throws IOException {
    }

    @Override
    public void generatePostDelete(JavaWriter out) throws IOException {
    }

    @Override
    public void generateExpire(JavaWriter out) throws IOException {
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
    }

    @Override
    public void childDelete(AmberConnectionImpl aConn, Serializable primaryKey) throws SQLException {
    }

    @Override
    public String generateCastFromObject(String value) {
        return value;
    }

    @Override
    public String generateEquals(String leftBase, String value) {
        return new StringBuffer().append(leftBase).append(".equals(").append(value).append(")").toString();
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("[").append(this.getName()).append("]").toString();
    }
}

