/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.KeyColumnExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyPropertyField
extends PropertyField
implements IdField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/KeyPropertyField"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/KeyPropertyField"));
    private Column _column;
    private boolean _isKeyField;
    private String _generator;

    public KeyPropertyField(EntityType tableType) {
        super(tableType);
    }

    public KeyPropertyField(EntityType tableType, String name) throws ConfigException {
        super(tableType, name);
    }

    public KeyPropertyField(EntityType entityType, String name, Column column) throws ConfigException {
        super(entityType, name);
        this._column = column;
        this._column.setPrimaryKey(true);
    }

    @Override
    public void setKeyField(boolean isKeyField) {
        this._isKeyField = isKeyField;
    }

    public void setGenerator(String generator) {
        this._generator = generator;
        if (this._column != null) {
            this._column.setGeneratorType(generator);
        }
    }

    @Override
    public String getGenerator() {
        return this._generator;
    }

    @Override
    public void setColumn(Column column) {
        this._column = column;
        this._column.setPrimaryKey(true);
    }

    @Override
    public Column getColumn() {
        return this._column;
    }

    @Override
    public ArrayList<Column> getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(this._column);
        return columns;
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public Type getType() {
        return this._column.getType();
    }

    @Override
    public String getForeignTypeName() {
        return this._column.getType().getForeignTypeName();
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        if (this.isAbstract()) {
            out.println();
            out.println();
            out.println(new StringBuffer().append("public ").append(this.getJavaTypeName()).append(" ").append(this.getGetterName()).append("()").toString());
            out.println("{");
            out.println(new StringBuffer().append("  return ").append(this.getFieldName()).append(";").toString());
            out.println("}");
            out.println();
            out.println(new StringBuffer().append("public void ").append(this.getSetterName()).append("(").append(this.getJavaTypeName()).append(" v)").toString());
            out.println("{");
            out.println(new StringBuffer().append("  ").append(this.getFieldName()).append(" = v;").toString());
            out.println("}");
        }
    }

    @Override
    public String generateSuperGetter() {
        if (this.isAbstract() || this.getGetterMethod() == null) {
            return this.getFieldName();
        }
        return new StringBuffer().append(this.getGetterMethod().getName()).append("()").toString();
    }

    @Override
    public String generateSuperSetter(String value) {
        if (this.isAbstract() || this.getGetterMethod() == null || this.getSetterMethod() == null) {
            return new StringBuffer().append(this.getFieldName()).append(" = ").append(value).append(";").toString();
        }
        return new StringBuffer().append(this.getSetterMethod().getName()).append("(").append(value).append(")").toString();
    }

    @Override
    public String generateSelect(String id) {
        return this._column.generateSelect(id);
    }

    @Override
    public String generateMatchArgWhere(String id) {
        return this._column.generateMatchArgWhere(id);
    }

    @Override
    public String generateRawWhere(String id) {
        return new StringBuffer().append(id).append(".").append(this.getName()).append("=?").toString();
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.generateLoadForeign(out, rs, indexVar, index, this.getForeignTypeName().replace('.', '_'));
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        out.println(new StringBuffer().append(this.generateSuperSetter(this.generateGet(obj))).append(";").toString());
    }

    public String generateSetNull(String obj) throws IOException {
        return this.generateSet(obj, this.getColumn().getType().generateNull());
    }

    @Override
    public String generateIsNull(String value) {
        return new StringBuffer().append("(").append(this.getType().generateIsNull(this.generateSuperGetter())).append(")").toString();
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        return this._column.getType().generateLoadForeign(out, rs, indexVar, index);
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        if (value == null) {
            this._column.getType().generateSetNull(out, pstmt, index);
        } else {
            this._column.getType().generateSet(out, pstmt, index, this.generateGet(value));
        }
    }

    public void generateMatch(JavaWriter out, String key) throws IOException {
        out.println(new StringBuffer().append("return ").append(this.generateEquals("super", key)).append(";").toString());
    }

    @Override
    public String generateEquals(String left, String right) {
        return this._column.getType().generateEquals(left, right);
    }

    @Override
    public void generateSetInsert(JavaWriter out, String pstmt, String index) throws IOException {
        String value = this.generateSuperGetter();
        out.println(new StringBuffer().append("if (").append(this.getType().generateIsNull(value)).append(") {").toString());
        out.pushDepth();
        this.getType().generateSetNull(out, pstmt, index);
        out.popDepth();
        out.println("} else {");
        out.pushDepth();
        this.generateSet(out, pstmt, index);
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateCheckCreateKey(JavaWriter out) throws IOException {
        if ("identity".equals(this._generator)) {
            return;
        }
        if (this._generator != null) {
            if (this.getSourceType().getGenerator(this.getName()) == null) {
                throw new IllegalStateException(new StringBuffer().append("no sequence generator for ").append(this.getName()).toString());
            }
            out.println(new StringBuffer().append("if (").append(this.getType().generateIsNull(this.generateSuperGetter())).append(") {").toString());
            out.pushDepth();
            String id = new StringBuffer().append("home.nextGeneratorId(aConn, \"").append(this.getName()).append("\")").toString();
            String javaType = this.getType().getJavaTypeName();
            if ("long".equals(javaType)) {
                id = new StringBuffer().append("(").append(javaType).append(") ").append(id).toString();
            } else if ("int".equals(javaType)) {
                id = new StringBuffer().append("(").append(javaType).append(") ").append(id).toString();
            } else if ("short".equals(javaType)) {
                id = new StringBuffer().append("(").append(javaType).append(") ").append(id).toString();
            } else if ("java.lang.Long".equals(javaType)) {
                id = new StringBuffer().append("new Long(").append(id).append(")").toString();
            } else if ("java.lang.Integer".equals(javaType)) {
                id = new StringBuffer().append("new Integer((int) ").append(id).append(")").toString();
            } else if ("java.lang.Short".equals(javaType)) {
                id = new StringBuffer().append("new Short((short) ").append(id).append(")").toString();
            } else if ("java.lang.Byte".equals(javaType)) {
                id = new StringBuffer().append("new Byte((byte) ").append(id).append(")").toString();
            } else {
                throw new UnsupportedOperationException(L.l("{0} is an unsupported generated key type.", javaType));
            }
            out.println(new StringBuffer().append(this.generateSuperSetter(id)).append(";").toString());
            out.popDepth();
            out.println("}");
            return;
        }
        out.println(new StringBuffer().append("if (").append(this.getType().generateIsNull(this.generateSuperGetter())).append(")").toString());
        out.println(new StringBuffer().append("  throw new com.caucho.amber.AmberException(\"primary key must not be null on creation.  ").append(this.getGetterName()).append("() must not return null.\");").toString());
    }

    @Override
    public void generateSetGeneratedKeys(JavaWriter out, String pstmt) throws IOException {
        if (!"identity".equals(this._generator)) {
            return;
        }
        out.print("if (");
        out.print(this.getType().generateIsNull(this.generateSuperGetter()));
        out.println(") {");
        out.pushDepth();
        String var = new StringBuffer().append("__caucho_rs_").append(out.generateId()).toString();
        out.println(new StringBuffer().append("java.sql.ResultSet ").append(var).append(" = ").append(pstmt).append(".getGeneratedKeys();").toString());
        out.println(new StringBuffer().append("if (").append(var).append(".next()) {").toString());
        out.pushDepth();
        out.print(new StringBuffer().append(this.getType().getName()).append(" v1 = ").toString());
        this.getType().generateLoad(out, var, "", 1);
        out.println(";");
        out.println(new StringBuffer().append(this.generateSuperSetter("v1")).append(";").toString());
        out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINER))");
        out.println(new StringBuffer().append("  __caucho_log.finer(\"create with new primaryKey \" + ").append(this.generateSuperGetter()).append(");").toString());
        out.popDepth();
        out.println("}");
        out.println("else throw new java.sql.SQLException();");
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateSetKeyProperty(String key, String value) throws IOException {
        if (this._isKeyField) {
            return new StringBuffer().append(key).append(".").append(this.getName()).append(" = ").append(value).toString();
        }
        return this.generateSet(key, value);
    }

    @Override
    public String generateGetKeyProperty(String key) {
        if (this._isKeyField) {
            return new StringBuffer().append(key).append(".").append(this.getName()).toString();
        }
        return this.generateGet(key);
    }

    @Override
    public String generateGetProxyProperty(String value) {
        Class proxyClass = this.getSourceType().getProxyClass();
        try {
            Method method = proxyClass.getMethod(this.getGetterName(), new Class[0]);
            if (method != null) {
                return this.generateGet(value);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        Id id = this.getSourceType().getId();
        return this.generateGetKeyProperty(new StringBuffer().append("((").append(id.getForeignTypeName()).append(") ").append(value).append(".getPrimaryKey())").toString());
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new KeyColumnExpr(parent, this.getColumn());
    }

    @Override
    public String toObject(String value) {
        return this.getColumn().getType().toObject(value);
    }

    @Override
    public String toValue(String value) {
        return this.getColumn().getType().generateCastFromObject(value);
    }
}

