/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.AmberManager;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.gen.EntityComponent;
import com.caucho.amber.gen.EntityGenerator;
import com.caucho.amber.type.EntityType;
import com.caucho.java.JavaCompiler;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.java.gen.JavaClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Logger;

public class AmberGeneratorImpl
implements AmberGenerator {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/gen/AmberGeneratorImpl"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/gen/AmberGeneratorImpl"));
    private AmberManager _amberManager;
    private ArrayList<String> _pendingClassNames = new ArrayList();

    public void setAmberManager(AmberManager manager) {
        this._amberManager = manager;
    }

    public void configure(EntityType type) throws Exception {
    }

    public void generate(EntityType type) throws Exception {
        this.generateJava(null, type);
    }

    public void generateJava(JavaClassGenerator javaGen, EntityType type) throws Exception {
        if (this.isPreload(javaGen, type) || type.isGenerated()) {
            return;
        }
        type.setGenerated(true);
        JavaClass javaClass = new JavaClass(type.getInstanceClassName());
        javaClass.setSuperClassName(type.getBeanClass().getName());
        javaClass.addInterfaceName("com.caucho.amber.entity.Entity");
        EntityComponent entity = new EntityComponent();
        entity.setEntityType(type);
        entity.setBaseClassName(type.getBeanClass().getName());
        entity.setExtClassName(type.getInstanceClassName());
        javaClass.addComponent(entity);
        DependencyComponent depend = javaClass.addDependencyComponent();
        depend.addDependencyList(entity.getDependencies());
        javaGen.generate(javaClass);
    }

    public boolean isPreload(JavaClassGenerator javaGen, EntityType type) throws Exception {
        Class cl = type.isEnhanced() ? javaGen.preload(type.getBeanClass().getName()) : javaGen.preload(type.getInstanceClassName());
        return cl != null && ClassLiteral.getClass((String)"com/caucho/amber/entity/Entity").isAssignableFrom(cl);
    }

    public void compile() throws Exception {
        if (this._pendingClassNames.size() == 0) {
            return;
        }
        String[] javaFiles = new String[this._pendingClassNames.size()];
        for (int i = 0; i < this._pendingClassNames.size(); ++i) {
            String name = this._pendingClassNames.get(i);
            javaFiles[i] = name = name.replace('.', '/') + ".java";
        }
        this._pendingClassNames.clear();
        EntityGenerator gen = new EntityGenerator();
        JavaCompiler compiler = gen.getCompiler();
        compiler.compileBatch(javaFiles);
    }
}

