/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.hibernate;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.CompositeId;
import com.caucho.amber.field.Discriminator;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.hibernate.HibernateBag;
import com.caucho.amber.hibernate.HibernateField;
import com.caucho.amber.hibernate.HibernateManyToOne;
import com.caucho.amber.hibernate.HibernateMap;
import com.caucho.amber.hibernate.HibernateMapping;
import com.caucho.amber.hibernate.HibernateProperty;
import com.caucho.amber.hibernate.HibernateSubClass;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;

public class HibernateClass {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/hibernate/HibernateClass"));
    private HibernateMapping _mapping;
    protected AmberManager _amberManager;
    private EntityType _entityType;
    private String _table;
    private String _abstractSchema;

    HibernateClass(HibernateMapping mapping) {
        this._mapping = mapping;
        this._amberManager = mapping.getManager();
    }

    protected EntityType getEntityType() {
        return this._entityType;
    }

    public void setName(Class name) {
        this._entityType = this.createEntity(name);
        this._entityType.startConfigure();
        this._entityType.setBeanClass(name);
        String className = name.getName();
        int p = className.lastIndexOf(46);
        String sqlTable = null;
        sqlTable = p > 0 ? className.substring(p + 1) : className;
        this._entityType.setTable(this._amberManager.createTable(sqlTable));
        this._entityType.addDependency(this._mapping.getDependency());
    }

    protected EntityType createEntity(Class cl) {
        return this._amberManager.createEntity(cl);
    }

    public void setAbstractSchema(String schema) {
        this._abstractSchema = schema;
    }

    public void setTable(String table) {
        this._table = table;
    }

    public HibernateId createId() {
        return new HibernateId(this._entityType);
    }

    public HibernateDiscriminator createDiscriminator() {
        return new HibernateDiscriminator(this._entityType);
    }

    public HibernateCompositeId createCompositeId() {
        return new HibernateCompositeId(this._entityType);
    }

    public HibernateProperty createProperty() {
        return new HibernateProperty(this._entityType);
    }

    public HibernateManyToOne createManyToOne() {
        return new HibernateManyToOne(this._entityType);
    }

    public HibernateBag createBag() {
        return new HibernateBag(this._entityType);
    }

    public HibernateBag createSet() {
        return new HibernateBag(this._entityType);
    }

    public HibernateMap createMap() {
        return new HibernateMap(this._entityType);
    }

    public LoadGroup createLoadGroup() {
        return new LoadGroup(this._entityType);
    }

    public HibernateSubClass createSubclass() {
        return new HibernateSubClass(this._mapping, this);
    }

    public void init() {
        if (this._table != null) {
            this._entityType.setTable(this._amberManager.createTable(this._table));
        }
        if (this._abstractSchema != null) {
            this._entityType.setName(this._abstractSchema);
        }
    }

    public static class HibernateGenerator {
        private String _generator;

        public void setClass(String type) throws ConfigException {
            if (!"identity".equals(type) && !"max".equals(type)) {
                throw new ConfigException(L.l("'{0}' is an unknown generator", type));
            }
            this._generator = type;
        }

        String getGeneratorType() {
            return this._generator;
        }
    }

    public static class HibernateCompositeId {
        EntityType _type;
        private Class _keyClass;
        ArrayList<IdField> _ids = new ArrayList();
        ArrayList<Column> _columns = new ArrayList();

        HibernateCompositeId(EntityType type) {
            this._type = type;
        }

        public void setClass(Class keyClass) {
            this._keyClass = keyClass;
        }

        public HibernateId createKeyProperty() {
            return new HibernateId(this._type);
        }

        public void addKeyProperty(HibernateId id) {
            this._ids.add(id.getId());
            this._columns.add(id.getId().getColumns().get(0));
        }

        public void init() throws ConfigException {
            CompositeId id = new CompositeId(this._type, this._ids);
            id.setKeyClass(this._keyClass);
            this._type.setId(id);
        }
    }

    public static class HibernateDiscriminator
    extends HibernateProperty {
        private Discriminator _discriminator;

        HibernateDiscriminator(EntityType entityType) {
            super(entityType);
            this._discriminator = new Discriminator(entityType);
            this.setField(this._discriminator);
        }

        public void init() throws ConfigException {
            super.init();
            throw new UnsupportedOperationException();
        }
    }

    public static class HibernateId
    extends HibernateField {
        private KeyPropertyField _id;
        private HibernateGenerator _gen;

        HibernateId(EntityType type) {
            super(type);
            this._id = new KeyPropertyField(type);
            this._id.setGenerator("identity");
            this.setField(this._id);
        }

        IdField getId() {
            return this._id;
        }

        public void addGenerator(HibernateGenerator gen) {
            this._id.setGenerator(gen.getGeneratorType());
        }

        public void init() throws ConfigException {
            super.init();
            this._id.setColumn(this.getOwnerType().getTable().createColumn(this._id.getName(), this.getType()));
            this._id.getColumn().setGeneratorType(this._id.getGenerator());
            ArrayList<IdField> keys = new ArrayList<IdField>();
            keys.add(this._id);
            this.getOwnerType().setId(new Id(this.getOwnerType(), keys));
        }
    }

    public class LoadGroup {
        private EntityType _type;

        LoadGroup(EntityType type) {
            this._type = type;
            type.nextDefaultLoadGroupIndex();
        }

        public HibernateProperty createProperty() {
            return new HibernateProperty(HibernateClass.this._entityType);
        }
    }
}

