/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.hibernate;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.hibernate.HibernateColumn;
import com.caucho.amber.hibernate.HibernateField;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;

public class HibernateProperty
extends HibernateField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/hibernate/HibernateProperty"));
    private PropertyField _field;
    private HibernateColumn _column = new HibernateColumn();

    HibernateProperty(EntityType type) {
        super(type);
        this._field = new PropertyField(type);
        this.setField(this._field);
    }

    public void setName(String name) throws ConfigException {
        super.setName(name);
        this._column.setName(name);
        Method getter = this._field.getGetterMethod();
        if (getter != null && getter.getReturnType().isPrimitive()) {
            this._column.setNotNull(true);
        }
    }

    protected void setField(AbstractField field) {
        super.setField(field);
        this._field = (PropertyField)field;
    }

    public HibernateColumn createColumn() {
        return this._column;
    }

    public void setNotNull(boolean isNotNull) {
        this._column.setNotNull(isNotNull);
    }

    public void setLength(int length) {
        this._column.setLength(length);
    }

    public void setSQLType(String sqlType) {
        this._column.setSQLType(sqlType);
    }

    public void setUnique(boolean isUnique) {
        this._column.setUnique(isUnique);
    }

    public void setUniqueKey(String uniqueKey) {
        this._column.setUniqueKey(uniqueKey);
    }

    public void setIndex(String index) {
        this._column.setIndex(index);
    }

    public void setInsert(boolean isInsert) {
        this._field.setInsert(isInsert);
    }

    public void setUpdate(boolean isUpdate) {
        this._field.setUpdate(isUpdate);
    }

    public void init() throws ConfigException {
        super.init();
        this._field.setType(this.getType());
        Column column = this.getOwnerType().getTable().createColumn(this._column.getName(), this.getType());
        column.setNotNull(this._column.getNotNull());
        column.setUnique(this._column.getUnique());
        column.setLength(this._column.getLength());
        column.setSQLType(this._column.getSQLType());
        this._field.setColumn(column);
        this.getOwnerType().addField(this._field);
    }
}

