/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.ColumnExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.IdExpr;
import com.caucho.amber.query.IdFieldExpr;
import com.caucho.amber.query.JoinExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualJoinExpr
extends JoinExpr {
    private ArrayList<Column> _keyColumns;
    private FromItem _fromItemA;
    private FromItem _fromItemB;

    EqualJoinExpr(ArrayList<Column> keyColumns, FromItem fromItemA, FromItem fromItemB) {
        this._keyColumns = keyColumns;
        this._fromItemA = fromItemA;
        this._fromItemB = fromItemB;
        if (fromItemA == null || fromItemB == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        return this;
    }

    @Override
    public boolean bindToFromItem() {
        if (this._fromItemA.getJoinExpr() == null || this._fromItemA.getJoinExpr().equals(this)) {
            this._fromItemA.setJoinExpr(this);
            return true;
        }
        if (this._fromItemB.getJoinExpr() == null) {
            this._fromItemB.setJoinExpr(this);
            return true;
        }
        return false;
    }

    @Override
    FromItem getJoinTarget() {
        return this._fromItemA;
    }

    public AmberExpr replace(IdFieldExpr id) {
        IdExpr parent = (IdExpr)id.getParent();
        if (parent.getFromItem() == this._fromItemA) {
            return new ColumnExpr(new IdExpr(this._fromItemA), id.getColumn());
        }
        if (parent.getFromItem() == this._fromItemB) {
            return new ColumnExpr(new IdExpr(this._fromItemB), id.getColumn());
        }
        return id;
    }

    @Override
    public AmberExpr replace(IdExpr id) {
        return id;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        cb.append('(');
        for (int i = 0; i < this._keyColumns.size(); ++i) {
            Column column = this._keyColumns.get(i);
            if (i != 0) {
                cb.append(" AND ");
            }
            cb.append(this._fromItemA.getName());
            cb.append('.');
            cb.append(column.getName());
            cb.append('=');
            cb.append(this._fromItemB.getName());
            cb.append('.');
            cb.append(column.getName());
        }
        cb.append('(');
    }

    public boolean equals(Object o) {
        if (!(o instanceof EqualJoinExpr)) {
            return false;
        }
        EqualJoinExpr equalExpr = (EqualJoinExpr)o;
        return this._keyColumns.equals(equalExpr._keyColumns) && this._fromItemA.equals(equalExpr._fromItemA) && this._fromItemB.equals(equalExpr._fromItemB);
    }

    public String toString() {
        return new StringBuffer().append("EqualJoinExpr[").append(this._keyColumns).append(",").append(this._fromItemA).append(",").append(this._fromItemB).append("]").toString();
    }
}

