/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.SelectQuery;
import com.caucho.util.Alarm;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;

public class ResultSetCacheChunk {
    private SelectQuery _query;
    private ArrayList<FromItem> _fromList;
    private ArrayList<AmberExpr> _resultList;
    private int _startRow;
    private final ArrayList<Object[]> _results = new ArrayList();
    private boolean _isLast;
    private long _expireTime;

    public void setQuery(SelectQuery query) {
        this._query = query;
        this._fromList = query.getFromList();
        this._resultList = query.getResultList();
        this._expireTime = Alarm.getCurrentTime() + query.getCacheMaxAge();
    }

    public SelectQuery getQuery() {
        return this._query;
    }

    public long getExpireTime() {
        return this._expireTime;
    }

    public boolean isValid() {
        return Alarm.getCurrentTime() <= this._expireTime;
    }

    public void invalidate() {
        this._expireTime = 0L;
    }

    public boolean invalidate(String table, Object key) {
        if (this.getQuery().invalidateTable(table)) {
            this._expireTime = 0L;
            return true;
        }
        return false;
    }

    public int getRowCount() {
        return this._results.size();
    }

    public void newRow() {
        this._results.add(new Object[this._resultList.size()]);
    }

    public void setValue(int row, int column, Object value) {
        this._results.get((int)row)[column] = value;
    }

    public void setLast(boolean isLast) {
        this._isLast = isLast;
    }

    public boolean isLast() {
        return this._isLast;
    }

    public boolean isNull(int row, int column) {
        return this.getObject(row, column) == null;
    }

    public boolean getBoolean(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof String) {
            String s = (String)object;
            return s.startsWith("t") || s.startsWith("y");
        }
        return object != null;
    }

    public int getInt(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        if (object == null) {
            return 0;
        }
        return Integer.parseInt(String.valueOf(object));
    }

    public long getLong(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        if (object instanceof Date) {
            return ((Date)object).getTime();
        }
        if (object == null) {
            return 0L;
        }
        return Long.parseLong(String.valueOf(object));
    }

    public double getDouble(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        if (object == null) {
            return 0.0;
        }
        return Double.parseDouble(String.valueOf(object));
    }

    public String getString(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof String) {
            return (String)object;
        }
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public final Object getObject(int row, int column) {
        return this._results.get(row)[column];
    }
}

