/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.table;

import com.caucho.amber.AmberManager;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityListener;
import com.caucho.amber.entity.TableInvalidateCompletion;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ColumnCompare;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import javax.sql.DataSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private static final L10N L;
    private String _name;
    private EntityType _type;
    private ArrayList<Column> _columns = new ArrayList();
    private ArrayList<LinkColumns> _incomingLinks = new ArrayList();
    private ArrayList<LinkColumns> _outgoingLinks = new ArrayList();
    private ArrayList<Column> _idColumns = new ArrayList();
    private LinkColumns _dependentIdLink;
    private boolean _isReadOnly;
    private long _cacheTimeout = 250L;
    private ArrayList<EntityListener> _entityListeners = new ArrayList();
    private TableInvalidateCompletion _invalidateCompletion;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Table(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setType(EntityType type) {
        if (this._type == null) {
            this._type = type;
        }
    }

    public EntityType getType() {
        return this._type;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public long getCacheTimeout() {
        return this._cacheTimeout;
    }

    public void setCacheTimeout(long timeout) {
        this._cacheTimeout = timeout;
    }

    public Column createColumn(String name, Type type) {
        for (int i = 0; i < this._columns.size(); ++i) {
            Column oldColumn = this._columns.get(i);
            if (!oldColumn.getName().equals(name)) continue;
            return oldColumn;
        }
        Column column = new Column(this, name, type);
        this._columns.add(column);
        Collections.sort(this._columns, new ColumnCompare());
        return column;
    }

    public ForeignColumn createForeignColumn(String name, Column key) {
        for (int i = 0; i < this._columns.size(); ++i) {
            Column oldColumn = this._columns.get(i);
            if (!oldColumn.getName().equals(name)) continue;
            if (oldColumn instanceof ForeignColumn) {
                return (ForeignColumn)oldColumn;
            }
            ForeignColumn column = new ForeignColumn(this, name, key);
            this._columns.set(i, column);
            return column;
        }
        ForeignColumn column = new ForeignColumn(this, name, key);
        this._columns.add(column);
        Collections.sort(this._columns, new ColumnCompare());
        return column;
    }

    public Column addColumn(Column column) {
        for (int i = 0; i < this._columns.size(); ++i) {
            Column oldColumn = this._columns.get(i);
            if (!oldColumn.getName().equals(column.getName())) continue;
            if (oldColumn instanceof ForeignColumn) {
                return oldColumn;
            }
            if (column instanceof ForeignColumn) {
                this._columns.set(i, column);
                return column;
            }
            return oldColumn;
        }
        this._columns.add(column);
        Collections.sort(this._columns, new ColumnCompare());
        return column;
    }

    public ArrayList<Column> getColumns() {
        return this._columns;
    }

    void addIncomingLink(LinkColumns link) {
        if (!$assertionsDisabled && this._incomingLinks.contains(link)) {
            throw new AssertionError();
        }
        this._incomingLinks.add(link);
    }

    void addOutgoingLink(LinkColumns link) {
        if (!$assertionsDisabled && this._outgoingLinks.contains(link)) {
            throw new AssertionError();
        }
        this._outgoingLinks.add(link);
    }

    public void addIdColumn(Column column) {
        this._idColumns.add(column);
    }

    public ArrayList<Column> getIdColumns() {
        return this._idColumns;
    }

    public void setDependentIdLink(LinkColumns link) {
        this._dependentIdLink = link;
    }

    public LinkColumns getDependentIdLink() {
        return this._dependentIdLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDatabaseTable(AmberManager amberManager) throws ConfigException {
        try {
            DataSource ds = amberManager.getDataSource();
            Connection conn = ds.getConnection();
            try {
                Statement stmt = conn.createStatement();
                try {
                    String sql = new StringBuffer().append("SELECT 1 FROM ").append(this.getName()).append(" o WHERE 1=0").toString();
                    ResultSet rs = stmt.executeQuery(sql);
                    rs.close();
                    return;
                }
                catch (SQLException e) {
                    String createSQL = this.generateCreateTableSQL(amberManager);
                    stmt.executeUpdate(createSQL);
                    stmt.close();
                    conn.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    private String generateCreateTableSQL(AmberManager amberManager) {
        CharBuffer cb = new CharBuffer();
        cb.append(new StringBuffer().append("CREATE TABLE ").append(this.getName()).append("(").toString());
        boolean hasColumn = false;
        for (Column column : this._columns) {
            String columnSQL = column.generateCreateTableSQL(amberManager);
            if (columnSQL == null) continue;
            if (!hasColumn) {
                hasColumn = true;
                cb.append(new StringBuffer().append("\n  ").append(columnSQL).toString());
                continue;
            }
            cb.append(new StringBuffer().append(",\n  ").append(columnSQL).toString());
        }
        cb.append("\n)");
        return cb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDatabaseTable(AmberManager amberManager) throws ConfigException {
        try {
            DataSource ds = amberManager.getDataSource();
            Connection conn = ds.getConnection();
            try {
                Statement stmt = conn.createStatement();
                try {
                    String sql = new StringBuffer().append("SELECT 1 FROM ").append(this.getName()).append(" o WHERE 1=0").toString();
                    ResultSet rs = stmt.executeQuery(sql);
                    rs.close();
                }
                catch (SQLException e) {
                    throw new ConfigException(L.l("'{0}' is not a valid database table.  Either the table needs to be created or the create-database-tables attribute must be set.\n\n{1}", (Object)this.getName(), e.toString()), e);
                }
            }
            finally {
                conn.close();
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
        for (Column column : this._columns) {
            column.validateDatabase(amberManager);
        }
    }

    public AmberCompletion getInvalidateCompletion() {
        if (this._invalidateCompletion == null) {
            this._invalidateCompletion = new TableInvalidateCompletion(this.getName());
        }
        return this._invalidateCompletion;
    }

    public AmberCompletion getUpdateCompletion() {
        return this.getInvalidateCompletion();
    }

    public AmberCompletion getDeleteCompletion() {
        return this.getInvalidateCompletion();
    }

    public void addEntityListener(EntityListener listener) {
        if (!this._entityListeners.contains(listener)) {
            this._entityListeners.add(listener);
        }
    }

    public boolean hasListeners() {
        return this._entityListeners.size() > 0;
    }

    public boolean isCascadeDelete() {
        LinkColumns link;
        int i;
        for (i = 0; i < this._incomingLinks.size(); ++i) {
            link = this._incomingLinks.get(i);
            if (!link.isSourceCascadeDelete()) continue;
            return true;
        }
        for (i = 0; i < this._outgoingLinks.size(); ++i) {
            link = this._outgoingLinks.get(i);
            if (!link.isTargetCascadeDelete()) continue;
            return true;
        }
        return false;
    }

    public void beforeEntityDelete(AmberConnectionImpl aConn, Entity entity) {
        try {
            int i;
            for (i = 0; i < this._entityListeners.size(); ++i) {
                EntityListener listener = this._entityListeners.get(i);
                listener.beforeEntityDelete(aConn, entity);
            }
            for (i = 0; i < this._incomingLinks.size(); ++i) {
                LinkColumns link = this._incomingLinks.get(i);
                link.beforeTargetDelete(aConn, entity);
            }
            aConn.addCompletion(this.getDeleteCompletion());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public String toString() {
        return new StringBuffer().append("Table[").append(this.getName()).append("]").toString();
    }

    static {
        $assertionsDisabled = !ClassLiteral.getClass((String)"com/caucho/amber/table/Table").desiredAssertionStatus();
        L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/table/Table"));
    }
}

