/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ByteType
extends Type {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/ByteType"));
    private static final ByteType BYTE_TYPE = new ByteType();

    private ByteType() {
    }

    public static ByteType create() {
        return BYTE_TYPE;
    }

    public String getName() {
        return "java.lang.Byte";
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(-6, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.ByteType.toByte(" + rs + ".getByte(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.TINYINT);");
        out.println("else");
        out.println("  " + pstmt + ".setByte(" + index + "++, " + value + ".byteValue());");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.TINYINT);");
    }

    public static Byte toByte(int value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Byte((byte)value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        byte value = rs.getByte(index);
        return rs.wasNull() ? null : new Byte(value);
    }
}

