/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DoubleType
extends Type {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/DoubleType"));
    private static final DoubleType DOUBLE_TYPE = new DoubleType();

    private DoubleType() {
    }

    public static DoubleType create() {
        return DOUBLE_TYPE;
    }

    public String getName() {
        return "java.lang.Double";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.DoubleType.toDouble(" + rs + ".getDouble(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.DOUBLE);");
        out.println("else");
        out.println("  " + pstmt + ".setDouble(" + index + "++, " + value + ".doubleValue());");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.DOUBLE);");
    }

    public static Double toDouble(double value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Double(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        double value = rs.getDouble(index);
        return rs.wasNull() ? null : new Double(value);
    }
}

