/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IntegerType
extends Type {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/IntegerType"));
    private static final IntegerType INTEGER_TYPE = new IntegerType();

    private IntegerType() {
    }

    public static IntegerType create() {
        return INTEGER_TYPE;
    }

    public String getName() {
        return "java.lang.Integer";
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(4, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.IntegerType.toInt(" + rs + ".getInt(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.INTEGER);");
        out.println("else");
        out.println("  " + pstmt + ".setInt(" + index + "++, " + value + ".intValue());");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.INTEGER);");
    }

    public Object toObject(long value) {
        return new Integer((int)value);
    }

    public static Integer toInt(int value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Integer(value);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 4);
        } else {
            pstmt.setInt(index, (Integer)value);
        }
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        int value = rs.getInt(index);
        return rs.wasNull() ? null : new Integer(value);
    }
}

