/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LongType
extends Type {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/LongType"));
    private static final LongType LONG_TYPE = new LongType();

    private LongType() {
    }

    public static LongType create() {
        return LONG_TYPE;
    }

    public String getName() {
        return "java.lang.Long";
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(-5, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.LongType.toLong(" + rs + ".getLong(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.BIGINT);");
        out.println("else");
        out.println("  " + pstmt + ".setLong(" + index + "++, " + value + ".longValue());");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.BIGINT);");
    }

    public static Long toLong(long value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Long(value);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 0);
        } else {
            pstmt.setLong(index, (Long)value);
        }
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        long value = rs.getLong(index);
        return rs.wasNull() ? null : new Long(value);
    }
}

