/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.BooleanType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class PrimitiveBooleanType
extends PrimitiveType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/PrimitiveBooleanType"));
    private static final PrimitiveBooleanType BOOLEAN_TYPE = new PrimitiveBooleanType();

    private PrimitiveBooleanType() {
    }

    public static PrimitiveBooleanType create() {
        return BOOLEAN_TYPE;
    }

    public String getName() {
        return "boolean";
    }

    public Type getForeignType() {
        return BooleanType.create();
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(-7, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getBoolean(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setBoolean(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.BIT);");
    }

    public String toObject(String value) {
        return "((" + value + ") ? Boolean.TRUE : Boolean.FALSE)";
    }

    public String generateCastFromObject(String value) {
        return "((Boolean) " + value + ").booleanValue()";
    }

    public String generateIsNull(String value) {
        return "! (" + value + ")";
    }
}

