/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ShortType
extends Type {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/ShortType"));
    private static final ShortType SHORT_TYPE = new ShortType();

    private ShortType() {
    }

    public static ShortType create() {
        return SHORT_TYPE;
    }

    public String getName() {
        return "java.lang.Short";
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(5, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.ShortType.toShort(" + rs + ".getShort(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.SMALLINT);");
        out.println("else");
        out.println("  " + pstmt + ".setShort(" + index + "++, " + value + ".shortValue());");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.SMALLINT);");
    }

    public Object toObject(long value) {
        return new Short((short)value);
    }

    public static Short toShort(int value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Short((short)value);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 0);
        } else {
            pstmt.setShort(index, ((Number)value).shortValue());
        }
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        short value = rs.getShort(index);
        return rs.wasNull() ? null : new Short(value);
    }
}

