/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ClassConstant;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.bytecode.DoubleConstant;
import com.caucho.bytecode.FieldRefConstant;
import com.caucho.bytecode.FloatConstant;
import com.caucho.bytecode.IntegerConstant;
import com.caucho.bytecode.InterfaceMethodRefConstant;
import com.caucho.bytecode.LongConstant;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.bytecode.NameAndTypeConstant;
import com.caucho.bytecode.StringConstant;
import com.caucho.bytecode.Utf8Constant;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPool {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/bytecode/ConstantPool"));
    public static final int CP_CLASS = 7;
    public static final int CP_FIELD_REF = 9;
    public static final int CP_METHOD_REF = 10;
    public static final int CP_INTERFACE_METHOD_REF = 11;
    public static final int CP_STRING = 8;
    public static final int CP_INTEGER = 3;
    public static final int CP_FLOAT = 4;
    public static final int CP_LONG = 5;
    public static final int CP_DOUBLE = 6;
    public static final int CP_NAME_AND_TYPE = 12;
    public static final int CP_UTF8 = 1;
    private ArrayList<ConstantPoolEntry> _entries = new ArrayList();

    ConstantPool() {
        this._entries.add(null);
    }

    public ConstantPoolEntry getEntry(int index) {
        return this._entries.get(index);
    }

    public ArrayList<ConstantPoolEntry> getEntries() {
        return this._entries;
    }

    public ClassConstant getClass(int index) {
        return (ClassConstant)this._entries.get(index);
    }

    public FieldRefConstant getFieldRef(int index) {
        return (FieldRefConstant)this._entries.get(index);
    }

    public MethodRefConstant getMethodRef(int index) {
        return (MethodRefConstant)this._entries.get(index);
    }

    public InterfaceMethodRefConstant getInterfaceMethodRef(int index) {
        return (InterfaceMethodRefConstant)this._entries.get(index);
    }

    public StringConstant getString(int index) {
        return (StringConstant)this._entries.get(index);
    }

    public IntegerConstant getInteger(int index) {
        return (IntegerConstant)this._entries.get(index);
    }

    public LongConstant getLong(int index) {
        return (LongConstant)this._entries.get(index);
    }

    public FloatConstant getFloat(int index) {
        return (FloatConstant)this._entries.get(index);
    }

    public DoubleConstant getDouble(int index) {
        return (DoubleConstant)this._entries.get(index);
    }

    public NameAndTypeConstant getNameAndType(int index) {
        return (NameAndTypeConstant)this._entries.get(index);
    }

    public Utf8Constant getUtf8(int index) {
        return (Utf8Constant)this._entries.get(index);
    }

    public void addConstant(ConstantPoolEntry entry) {
        this._entries.add(entry);
    }

    public Utf8Constant getUTF8(String value) {
        for (int i = 0; i < this._entries.size(); ++i) {
            Utf8Constant utf8Entry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof Utf8Constant) || !(utf8Entry = (Utf8Constant)entry).getValue().equals(value)) continue;
            return utf8Entry;
        }
        return null;
    }

    public Utf8Constant addUTF8(String value) {
        Utf8Constant entry = this.getUTF8(value);
        if (entry != null) {
            return entry;
        }
        entry = new Utf8Constant(this, this._entries.size(), value);
        this._entries.add(entry);
        return entry;
    }

    public StringConstant getString(String name) {
        for (int i = 0; i < this._entries.size(); ++i) {
            StringConstant stringEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof StringConstant) || !(stringEntry = (StringConstant)entry).getString().equals(name)) continue;
            return stringEntry;
        }
        return null;
    }

    public StringConstant addString(String name) {
        StringConstant entry = this.getString(name);
        if (entry != null) {
            return entry;
        }
        Utf8Constant utf8 = this.addUTF8(name);
        entry = new StringConstant(this, this._entries.size(), utf8.getIndex());
        this._entries.add(entry);
        return entry;
    }

    public IntegerConstant getIntegerByValue(int value) {
        for (int i = 0; i < this._entries.size(); ++i) {
            IntegerConstant integerEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof IntegerConstant) || (integerEntry = (IntegerConstant)entry).getValue() != value) continue;
            return integerEntry;
        }
        return null;
    }

    public IntegerConstant addInteger(int value) {
        IntegerConstant entry = this.getIntegerByValue(value);
        if (entry != null) {
            return entry;
        }
        entry = new IntegerConstant(this, this._entries.size(), value);
        this._entries.add(entry);
        return entry;
    }

    public LongConstant getLongByValue(long value) {
        for (int i = 0; i < this._entries.size(); ++i) {
            LongConstant longEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof LongConstant) || (longEntry = (LongConstant)entry).getValue() != value) continue;
            return longEntry;
        }
        return null;
    }

    public LongConstant addLong(long value) {
        LongConstant entry = this.getLongByValue(value);
        if (entry != null) {
            return entry;
        }
        entry = new LongConstant(this, this._entries.size(), value);
        this._entries.add(entry);
        this._entries.add(null);
        return entry;
    }

    public FloatConstant getFloatByValue(float value) {
        for (int i = 0; i < this._entries.size(); ++i) {
            FloatConstant floatEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof FloatConstant) || (floatEntry = (FloatConstant)entry).getValue() != value) continue;
            return floatEntry;
        }
        return null;
    }

    public FloatConstant addFloat(float value) {
        FloatConstant entry = this.getFloatByValue(value);
        if (entry != null) {
            return entry;
        }
        entry = new FloatConstant(this, this._entries.size(), value);
        this._entries.add(entry);
        return entry;
    }

    public DoubleConstant getDoubleByValue(double value) {
        for (int i = 0; i < this._entries.size(); ++i) {
            DoubleConstant doubleEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof DoubleConstant) || (doubleEntry = (DoubleConstant)entry).getValue() != value) continue;
            return doubleEntry;
        }
        return null;
    }

    public DoubleConstant addDouble(double value) {
        DoubleConstant entry = this.getDoubleByValue(value);
        if (entry != null) {
            return entry;
        }
        entry = new DoubleConstant(this, this._entries.size(), value);
        this._entries.add(entry);
        this._entries.add(null);
        return entry;
    }

    public ClassConstant getClass(String name) {
        for (int i = 0; i < this._entries.size(); ++i) {
            ClassConstant classEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof ClassConstant) || !(classEntry = (ClassConstant)entry).getName().equals(name)) continue;
            return classEntry;
        }
        return null;
    }

    public ClassConstant addClass(String name) {
        ClassConstant entry = this.getClass(name);
        if (entry != null) {
            return entry;
        }
        Utf8Constant utf8 = this.addUTF8(name);
        entry = new ClassConstant(this, this._entries.size(), utf8.getIndex());
        this._entries.add(entry);
        return entry;
    }

    public NameAndTypeConstant getNameAndType(String name, String type) {
        for (int i = 0; i < this._entries.size(); ++i) {
            NameAndTypeConstant methodEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof NameAndTypeConstant) || !(methodEntry = (NameAndTypeConstant)entry).getName().equals(name) || !methodEntry.getType().equals(type)) continue;
            return methodEntry;
        }
        return null;
    }

    public NameAndTypeConstant addNameAndType(String name, String type) {
        NameAndTypeConstant entry = this.getNameAndType(name, type);
        if (entry != null) {
            return entry;
        }
        Utf8Constant nameEntry = this.addUTF8(name);
        Utf8Constant typeEntry = this.addUTF8(type);
        entry = new NameAndTypeConstant(this, this._entries.size(), nameEntry.getIndex(), typeEntry.getIndex());
        this._entries.add(entry);
        return entry;
    }

    public FieldRefConstant getFieldRef(String className, String name, String type) {
        for (int i = 0; i < this._entries.size(); ++i) {
            FieldRefConstant fieldEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof FieldRefConstant) || !(fieldEntry = (FieldRefConstant)entry).getClassName().equals(className) || !fieldEntry.getName().equals(name) || !fieldEntry.getType().equals(type)) continue;
            return fieldEntry;
        }
        return null;
    }

    public FieldRefConstant getFieldRef(String name) {
        for (int i = 0; i < this._entries.size(); ++i) {
            FieldRefConstant fieldEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof FieldRefConstant) || !(fieldEntry = (FieldRefConstant)entry).getName().equals(name)) continue;
            return fieldEntry;
        }
        return null;
    }

    public FieldRefConstant addFieldRef(String className, String name, String type) {
        FieldRefConstant entry = this.getFieldRef(className, name, type);
        if (entry != null) {
            return entry;
        }
        ClassConstant classEntry = this.addClass(className);
        NameAndTypeConstant typeEntry = this.addNameAndType(name, type);
        entry = new FieldRefConstant(this, this._entries.size(), classEntry.getIndex(), typeEntry.getIndex());
        this._entries.add(entry);
        return entry;
    }

    public MethodRefConstant getMethodRef(String className, String name, String type) {
        for (int i = 0; i < this._entries.size(); ++i) {
            MethodRefConstant methodEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof MethodRefConstant) || !(methodEntry = (MethodRefConstant)entry).getClassName().equals(className) || !methodEntry.getName().equals(name) || !methodEntry.getType().equals(type)) continue;
            return methodEntry;
        }
        return null;
    }

    public MethodRefConstant addMethodRef(String className, String name, String type) {
        MethodRefConstant entry = this.getMethodRef(className, name, type);
        if (entry != null) {
            return entry;
        }
        ClassConstant classEntry = this.addClass(className);
        NameAndTypeConstant typeEntry = this.addNameAndType(name, type);
        entry = new MethodRefConstant(this, this._entries.size(), classEntry.getIndex(), typeEntry.getIndex());
        this._entries.add(entry);
        return entry;
    }

    public InterfaceMethodRefConstant getInterfaceRef(String className, String name, String type) {
        for (int i = 0; i < this._entries.size(); ++i) {
            InterfaceMethodRefConstant methodEntry;
            ConstantPoolEntry entry = this._entries.get(i);
            if (!(entry instanceof InterfaceMethodRefConstant) || !(methodEntry = (InterfaceMethodRefConstant)entry).getClassName().equals(className) || !methodEntry.getName().equals(name) || !methodEntry.getType().equals(type)) continue;
            return methodEntry;
        }
        return null;
    }

    public InterfaceMethodRefConstant addInterfaceRef(String className, String name, String type) {
        InterfaceMethodRefConstant entry = this.getInterfaceRef(className, name, type);
        if (entry != null) {
            return entry;
        }
        ClassConstant classEntry = this.addClass(className);
        NameAndTypeConstant typeEntry = this.addNameAndType(name, type);
        entry = new InterfaceMethodRefConstant(this, this._entries.size(), classEntry.getIndex(), typeEntry.getIndex());
        this._entries.add(entry);
        return entry;
    }

    void write(ByteCodeWriter out) throws IOException {
        out.writeShort(this._entries.size());
        for (int i = 1; i < this._entries.size(); ++i) {
            ConstantPoolEntry entry = this._entries.get(i);
            if (entry == null) continue;
            entry.write(out);
        }
    }
}

