/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.JavaClass;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class JavaMethod {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/bytecode/JavaMethod"));
    private int _accessFlags;
    private String _name;
    private String _descriptor;
    private ArrayList<Attribute> _attributes = new ArrayList();

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setAccessFlags(int flags) {
        this._accessFlags = flags;
    }

    public int getAccessFlags() {
        return this._accessFlags;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
    }

    public String getDescriptor() {
        return this._descriptor;
    }

    public void addAttribute(Attribute attr) {
        this._attributes.add(attr);
    }

    public CodeAttribute getCode() {
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            if (!(attr instanceof CodeAttribute)) continue;
            return (CodeAttribute)attr;
        }
        return null;
    }

    public void write(ByteCodeWriter out) throws IOException {
        out.writeShort(this._accessFlags);
        out.writeUTF8Const(this._name);
        out.writeUTF8Const(this._descriptor);
        out.writeShort(this._attributes.size());
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            attr.write(out);
        }
    }

    public JavaMethod export(JavaClass source, JavaClass target) {
        JavaMethod method = new JavaMethod();
        method.setName(this._name);
        method.setDescriptor(this._descriptor);
        method.setAccessFlags(this._accessFlags);
        target.getConstantPool().addUTF8(this._name);
        target.getConstantPool().addUTF8(this._descriptor);
        for (int i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            method.addAttribute(attr.export(source, target));
        }
        return method;
    }

    public void concatenate(JavaMethod tail) {
        CodeAttribute codeAttr = this.getCode();
        CodeAttribute tailCodeAttr = tail.getCode();
        byte[] code = codeAttr.getCode();
        byte[] tailCode = tailCodeAttr.getCode();
        int codeLength = code.length;
        if ((code[codeLength - 1] & 0xFF) == 177) {
            --codeLength;
        }
        byte[] newCode = new byte[codeLength + tailCode.length];
        System.arraycopy(code, 0, newCode, 0, codeLength);
        System.arraycopy(tailCode, 0, newCode, codeLength, tailCode.length);
        codeAttr.setCode(newCode);
        if (codeAttr.getMaxStack() < tailCodeAttr.getMaxStack()) {
            codeAttr.setMaxStack(tailCodeAttr.getMaxStack());
        }
        if (codeAttr.getMaxLocals() < tailCodeAttr.getMaxLocals()) {
            codeAttr.setMaxLocals(tailCodeAttr.getMaxLocals());
        }
        ArrayList<CodeAttribute.ExceptionItem> exns = tailCodeAttr.getExceptions();
        for (int i = 0; i < exns.size(); ++i) {
            CodeAttribute.ExceptionItem exn = exns.get(i);
            CodeAttribute.ExceptionItem newExn = new CodeAttribute.ExceptionItem();
            newExn.setType(exn.getType());
            newExn.setStart(exn.getStart() + codeLength);
            newExn.setEnd(exn.getEnd() + codeLength);
            newExn.setHandler(exn.getHandler() + codeLength);
        }
    }

    public String toString() {
        return "JavaMethod[" + this._name + "]";
    }
}

