/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeBuilder;
import com.caucho.config.ConfigException;
import com.caucho.config.ConfigurationException;
import com.caucho.config.DependencyBean;
import com.caucho.config.LineConfigException;
import com.caucho.config.NodeBuilderChildProgram;
import com.caucho.config.NodePropertyBuilder;
import com.caucho.config.ProgramAttributeBuilder;
import com.caucho.config.ProgramPropertyBuilder;
import com.caucho.config.ProgramTypeBuilder;
import com.caucho.config.TypeBuilder;
import com.caucho.config.TypeBuilderFactory;
import com.caucho.config.types.ResinType;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.make.PersistentDependency;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.vfs.Depend;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlUtil;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class NodeBuilder {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/NodeBuilder"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/NodeBuilder"));
    private static final QName RESIN_TYPE = new QName("resin:type");
    private static final QName RESIN_TYPE_NS = new QName("resin:type", "http://caucho.com/ns/resin/core");
    private static HashMap<Path, SoftReference<QDocument>> _parseCache = new HashMap();
    private Schema _schema;

    public void setCompactSchema(Path path) throws ConfigurationException, IOException {
        try {
            this._schema = CompactVerifierFactoryImpl.compileFromPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException(e);
        }
    }

    public void setCompactSchema(String location) throws IOException, ConfigException {
        try {
            MergePath schemaPath = new MergePath();
            schemaPath.addClassPath();
            Path path = schemaPath.lookup(location);
            if (path.canRead()) {
                CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
                this._schema = factory.compileSchema(path);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public Object configure(Object bean, Path path) throws LineConfigException, IOException, SAXException {
        return this.configure(bean, path, true);
    }

    public Object configureNoInit(Object bean, Path path) throws LineConfigException, IOException, SAXException {
        return this.configure(bean, path, false);
    }

    public Object configure(Object bean, InputStream is) throws LineConfigException, IOException, SAXException {
        return this.configure(bean, is, true);
    }

    public Object configureNoInit(Object bean, InputStream is) throws LineConfigException, IOException, SAXException {
        return this.configure(bean, is, false);
    }

    public Object configure(Object bean, Path path, boolean isInit) throws LineConfigException, IOException, SAXException {
        QDocument doc = this.parseDocument(path);
        return NodeBuilder.configure(bean, doc.getDocumentElement(), isInit);
    }

    public Object configure(Object bean, InputStream is, boolean isInit) throws LineConfigException, IOException, SAXException {
        QDocument doc = this.parseDocument(is);
        return NodeBuilder.configure(bean, doc.getDocumentElement(), isInit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDocument parseDocument(Path path) throws LineConfigException, IOException, SAXException {
        QDocument doc;
        SoftReference<QDocument> docRef = _parseCache.get(path);
        if (docRef != null && (doc = docRef.get()) != null && !doc.isModified()) {
            return doc;
        }
        ReadStream is = path.openRead();
        try {
            doc = this.parseDocument(is);
            _parseCache.put(path, new SoftReference<QDocument>(doc));
            QDocument qDocument = doc;
            return qDocument;
        }
        finally {
            is.close();
        }
    }

    private QDocument parseDocument(InputStream is) throws LineConfigException, IOException, SAXException {
        try {
            QDocument doc = new QDocument();
            DOMBuilder builder = new DOMBuilder();
            builder.init(doc);
            String systemId = null;
            if (is instanceof ReadStream) {
                systemId = ((ReadStream)is).getPath().getUserPath();
            }
            doc.setSystemId(systemId);
            builder.setSystemId(systemId);
            builder.setSkipWhitespace(true);
            InputSource in = new InputSource();
            in.setByteStream(is);
            in.setSystemId(systemId);
            Xml xml = new Xml();
            xml.setOwner(doc);
            if (this._schema != null) {
                Verifier verifier = this._schema.newVerifier();
                VerifierFilter filter = verifier.getVerifierFilter();
                filter.setParent((XMLReader)xml);
                filter.setContentHandler((ContentHandler)builder);
                filter.setErrorHandler((ErrorHandler)builder);
                filter.parse(in);
            } else {
                xml.setContentHandler(builder);
                xml.parse(in);
            }
            return doc;
        }
        catch (VerifierConfigurationException e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public static Object configure(Object bean, Node top) throws LineConfigException {
        return NodeBuilder.configure(bean, top, true);
    }

    public static void configureNoInit(Object bean, Node top) throws LineConfigException {
        NodeBuilder.configure(bean, top, false);
    }

    public static Object configure(Object bean, Node top, boolean doInit) throws LineConfigException {
        Object object;
        if (top == null) {
            return bean;
        }
        TypeBuilderFactory oldFactory = TypeBuilderFactory.getFactory();
        ClassLoader oldConfigLoader = null;
        try {
            TypeBuilderFactory factory = TypeBuilderFactory.createFactory();
            oldConfigLoader = factory.getConfigVariableResolver().getConfigLoader();
            TypeBuilder builder = factory.getTypeBuilder(bean.getClass());
            object = NodeBuilder.configure(builder, bean, top, doInit);
            TypeBuilderFactory.getConfigVariableResolver().setConfigLoader(oldConfigLoader);
        }
        catch (Exception e) {
            try {
                throw NodeBuilder.error(e, top);
            }
            catch (Throwable throwable) {
                TypeBuilderFactory.getConfigVariableResolver().setConfigLoader(oldConfigLoader);
                TypeBuilderFactory.setFactory(oldFactory);
                throw throwable;
            }
        }
        TypeBuilderFactory.setFactory(oldFactory);
        return object;
    }

    private static Object configure(TypeBuilder builder, Object bean, Node node) throws LineConfigException {
        return NodeBuilder.configure(builder, bean, node, true);
    }

    public static Object configure(TypeBuilder builder, Object bean, Node node, boolean doInit) throws LineConfigException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        EnvironmentBean envOwner = null;
        TypeBuilderFactory oldFactory = TypeBuilderFactory.getFactory();
        ClassLoader oldConfigLoader = null;
        if (oldLoader instanceof EnvironmentClassLoader) {
            envOwner = ((EnvironmentClassLoader)oldLoader).getOwner();
        }
        try {
            NamedNodeMap attrList;
            int i;
            TypeBuilderFactory factory = TypeBuilderFactory.createFactory();
            oldConfigLoader = factory.getConfigVariableResolver().getConfigLoader();
            ArrayList<Depend> dependList = null;
            if (node instanceof QElement) {
                QElement qelt = (QElement)node;
                builder.setLocation(bean, qelt.getBaseURI(), qelt.getFilename(), qelt.getLine());
                builder.setNode(bean, qelt);
                ArrayList<Path> pathList = ((QDocument)qelt.getOwnerDocument()).getDependList();
                if (pathList != null) {
                    dependList = new ArrayList<Depend>();
                    for (i = 0; i < pathList.size(); ++i) {
                        dependList.add(new Depend(pathList.get(i)));
                    }
                }
            }
            if (bean instanceof EnvironmentBean) {
                EnvironmentBean envBean = (EnvironmentBean)bean;
                ClassLoader beanLoader = envBean.getClassLoader();
                if (beanLoader != null) {
                    thread.setContextClassLoader(beanLoader);
                    factory.getConfigVariableResolver().setConfigLoader(beanLoader);
                }
                for (i = 0; dependList != null && i < dependList.size(); ++i) {
                    Dependency depend = (Dependency)dependList.get(i);
                    Environment.addDependency(depend);
                }
            } else if (bean instanceof DependencyBean) {
                DependencyBean dependBean = (DependencyBean)bean;
                for (int i2 = 0; dependList != null && i2 < dependList.size(); ++i2) {
                    dependBean.addDependency((PersistentDependency)dependList.get(i2));
                }
            }
            if (node instanceof Attr) {
                builder.addText(bean, node.getNodeValue());
            }
            if ((attrList = node.getAttributes()) != null) {
                int length = attrList.getLength();
                for (i = 0; i < length; ++i) {
                    Node child = attrList.item(i);
                    if (envOwner != null) {
                        thread.setContextClassLoader(envOwner.getClassLoader());
                    }
                    NodeBuilder.configureChild(builder, bean, child);
                }
            }
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (envOwner != null) {
                    thread.setContextClassLoader(envOwner.getClassLoader());
                }
                NodeBuilder.configureChild(builder, bean, child);
            }
            if (doInit) {
                builder.init(bean);
                Object object = builder.replaceObject(bean);
                return object;
            }
            Object object = bean;
            return object;
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw NodeBuilder.error(e, node);
        }
        finally {
            if (envOwner != null) {
                thread.setContextClassLoader(envOwner.getClassLoader());
            } else {
                thread.setContextClassLoader(oldLoader);
            }
            TypeBuilderFactory.getConfigVariableResolver().setConfigLoader(oldConfigLoader);
            TypeBuilderFactory.setFactory(oldFactory);
        }
    }

    static void configureChild(TypeBuilder typeBuilder, Object bean, Node child) throws LineConfigException {
        QName qName = ((QAbstractNode)child).getQName();
        String attrName = child.getNodeName();
        if (attrName.equals("resin:type")) {
            return;
        }
        if (attrName.startsWith("xmlns")) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        EnvironmentBean envOwner = null;
        TypeBuilderFactory oldFactory = TypeBuilderFactory.getFactory();
        ClassLoader oldConfigLoader = null;
        if (oldLoader instanceof EnvironmentClassLoader) {
            envOwner = ((EnvironmentClassLoader)oldLoader).getOwner();
        }
        try {
            TypeBuilderFactory factory = TypeBuilderFactory.createFactory();
            oldConfigLoader = factory.getConfigVariableResolver().getConfigLoader();
            if (bean instanceof EnvironmentBean) {
                ArrayList<Path> pathList;
                EnvironmentBean envBean = (EnvironmentBean)bean;
                ClassLoader beanLoader = envBean.getClassLoader();
                if (beanLoader != null) {
                    thread.setContextClassLoader(beanLoader);
                    factory.getConfigVariableResolver().setConfigLoader(beanLoader);
                }
                if ((pathList = ((QDocument)child.getOwnerDocument()).getDependList()) != null) {
                    for (int i = 0; i < pathList.size(); ++i) {
                        Environment.addDependency(new Depend(pathList.get(i)));
                    }
                }
            }
            NodeBuilder.configureChildProperty(typeBuilder, bean, child);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw NodeBuilder.error(e, child);
        }
        finally {
            if (envOwner != null) {
                thread.setContextClassLoader(envOwner.getClassLoader());
            } else {
                thread.setContextClassLoader(oldLoader);
            }
            TypeBuilderFactory.getConfigVariableResolver().setConfigLoader(oldConfigLoader);
            TypeBuilderFactory.setFactory(oldFactory);
        }
    }

    private static void configureChildProperty(TypeBuilder typeBuilder, Object bean, Node child) throws Exception {
        QName qName = ((QAbstractNode)child).getQName();
        String attrName = child.getNodeName();
        if (child instanceof Comment) {
            return;
        }
        if (child instanceof ProcessingInstruction) {
            return;
        }
        if (child instanceof CharacterData) {
            String data = ((CharacterData)child).getData();
            if (!XmlUtil.isWhitespace(data)) {
                typeBuilder.addText(bean, data.trim());
            }
            return;
        }
        AttributeBuilder attributeBuilder = typeBuilder.getAttributeBuilder(qName);
        TypeBuilder subBuilder = null;
        if (attributeBuilder != null) {
            subBuilder = attributeBuilder.getBuilder();
        }
        if (attributeBuilder instanceof ProgramAttributeBuilder) {
            ProgramAttributeBuilder programBuilder = (ProgramAttributeBuilder)attributeBuilder;
            NodeBuilderChildProgram program = new NodeBuilderChildProgram(child);
            programBuilder.getMethod().invoke(bean, program);
        } else if (attributeBuilder instanceof ProgramPropertyBuilder) {
            ProgramPropertyBuilder propertyBuilder = (ProgramPropertyBuilder)attributeBuilder;
            NodeBuilderChildProgram program = new NodeBuilderChildProgram(child);
            propertyBuilder.getMethod().invoke(bean, attrName, program);
        } else if (attributeBuilder instanceof NodePropertyBuilder) {
            attributeBuilder.setChild(bean, child);
        } else if (subBuilder instanceof ProgramTypeBuilder) {
            NodeBuilderChildProgram program = new NodeBuilderChildProgram(child);
            attributeBuilder.setChild(bean, program);
        } else if (attributeBuilder != null && !NodeBuilder.hasChildren(child) && attributeBuilder.isPrimitive()) {
            attributeBuilder.setString(bean, NodeBuilder.textValue(child));
        } else {
            String value;
            String configClass = null;
            ResinType resinType = null;
            String type = NodeBuilder.getValue(RESIN_TYPE, child, null);
            if ((type = NodeBuilder.getValue(RESIN_TYPE_NS, child, type)) != null) {
                resinType = new ResinType();
                resinType.addText(type);
                resinType.init();
                configClass = resinType.getClassName();
            }
            if ((subBuilder = attributeBuilder.getBuilder(configClass)) == null || ClassLiteral.getClass((String)"java/lang/String").equals(subBuilder.getType())) {
                attributeBuilder.setString(bean, NodeBuilder.textValue(child));
            } else if (resinType == null && !NodeBuilder.hasChildren(child) && (value = NodeBuilder.textValue(child)) != null && value.startsWith("${") && value.endsWith("}")) {
                Object valueObj = AttributeBuilder.evalObject(value);
                if (!(valueObj instanceof String)) {
                    attributeBuilder.setChild(bean, valueObj);
                } else {
                    NodeBuilder.setValueObject(resinType, bean, typeBuilder, attributeBuilder, subBuilder, child);
                }
            } else {
                NodeBuilder.setValueObject(resinType, bean, typeBuilder, attributeBuilder, subBuilder, child);
            }
        }
    }

    private static void setValueObject(ResinType resinType, Object bean, TypeBuilder typeBuilder, AttributeBuilder attributeBuilder, TypeBuilder subBuilder, Node child) throws Exception {
        Object valueObj = resinType != null ? resinType.create(attributeBuilder.getBuilder().getType()) : attributeBuilder.create(bean, subBuilder);
        if (valueObj != null && ClassLiteral.getClass((String)"java/lang/Object").equals(valueObj.getClass())) {
            attributeBuilder.setString(bean, NodeBuilder.textValue(child));
        } else {
            if (valueObj != null) {
                subBuilder = typeBuilder.getFactory().getTypeBuilder(valueObj.getClass());
            }
            valueObj = NodeBuilder.configure(subBuilder, valueObj, child);
            attributeBuilder.setChild(bean, valueObj);
        }
    }

    static boolean hasChildren(Node node) {
        NamedNodeMap attrList = node.getAttributes();
        if (attrList != null && attrList.getLength() > 0) {
            return true;
        }
        for (Node ptr = node.getFirstChild(); ptr != null; ptr = ptr.getNextSibling()) {
            if (!(ptr instanceof Element)) continue;
            return true;
        }
        return false;
    }

    static String getValue(QName name, Node node, String defaultValue) {
        NamedNodeMap attrList = node.getAttributes();
        if (attrList != null) {
            for (int i = 0; i < attrList.getLength(); ++i) {
                if (!attrList.item(i).getNodeName().equals(name.getName())) continue;
                return attrList.item(i).getNodeValue();
            }
        }
        for (Node ptr = node.getFirstChild(); ptr != null; ptr = ptr.getNextSibling()) {
            QName qName = ((QAbstractNode)ptr).getQName();
            if (!name.equals(qName)) continue;
            return NodeBuilder.textValue(ptr);
        }
        return defaultValue;
    }

    static String textValue(Node node) {
        String space;
        if (node instanceof Attr) {
            return node.getNodeValue();
        }
        String value = XmlUtil.textValue(node);
        if (node instanceof Element && !(space = ((Element)node).getAttribute("xml:space")).equals("")) {
            return value;
        }
        return value.trim();
    }

    private static LineConfigException error(Throwable e, Node node) {
        String msg;
        String filename = null;
        int line = 0;
        if (node instanceof QAbstractNode) {
            QAbstractNode qnode = (QAbstractNode)node;
            filename = qnode.getFilename();
            line = qnode.getLine();
        }
        while (e.getCause() != null && !(e instanceof LineCompileException) && !(e instanceof CompileException)) {
            e = e.getCause();
        }
        if (e instanceof LineConfigException) {
            return (LineConfigException)e;
        }
        if (e instanceof ConfigException && e.getMessage() != null && filename != null) {
            msg = filename + ":" + line + ": " + e.getMessage();
            log.log(Level.FINER, e.toString(), e);
            return new LineConfigException(msg, e);
        }
        if (e instanceof LineCompileException) {
            log.log(Level.FINER, e.toString(), e);
            return new LineConfigException(e.getMessage());
        }
        if (e instanceof CompileException && e.getMessage() != null) {
            msg = filename + ":" + line + ": " + e.getMessage();
            log.log(Level.FINER, e.toString(), e);
            return new LineConfigException(msg, e);
        }
        msg = filename + ":" + line + ": " + e;
        return new LineConfigException(msg, e);
    }
}

