/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeBuilder;
import com.caucho.config.ConfigException;
import com.caucho.config.ConfigurationException;
import com.caucho.config.DependencyBean;
import com.caucho.config.LineConfigException;
import com.caucho.config.ProgramAttributeBuilder;
import com.caucho.config.ProgramPropertyBuilder;
import com.caucho.config.ProgramTypeBuilder;
import com.caucho.config.RegistryBuilderChildProgram;
import com.caucho.config.TypeBuilder;
import com.caucho.config.TypeBuilderFactory;
import com.caucho.config.types.ResinType;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.util.CompileException;
import com.caucho.util.LineCompileException;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Depend;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.iso_relax.verifier.Schema;
import org.xml.sax.SAXException;

public class RegistryBuilder {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/RegistryBuilder"));
    private Schema _schema;

    public void setCompactSchema(Path path) throws ConfigurationException, IOException {
        ReadStream is = path.openRead();
        try {
            CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
            this._schema = factory.compileSchema(is);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompactSchema(String location) throws IOException, ConfigException {
        block6: {
            try {
                MergePath schemaPath = new MergePath();
                schemaPath.addClassPath();
                Path path = schemaPath.lookup(location);
                if (!path.canRead()) break block6;
                ReadStream is = path.openRead();
                try {
                    CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
                    this._schema = factory.compileSchema(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigException(e);
            }
        }
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public Object configure(Object bean, Path path) throws LineConfigException, IOException, SAXException {
        RegistryNode node = Registry.parse(path, this._schema).getTop();
        return this.configure(bean, node.getFirstChild());
    }

    public Object configure(Object bean, InputStream is) throws LineConfigException, IOException, SAXException {
        RegistryNode node = Registry.parse(is, this._schema).getTop();
        return this.configure(bean, node.getFirstChild());
    }

    public Object configureNoInit(Object bean, Path path) throws LineConfigException, IOException, SAXException {
        RegistryNode node = Registry.parse(path, this._schema).getTop();
        return this.configure(bean, node.getFirstChild(), false);
    }

    public Object configureNoInit(Object bean, InputStream is) throws LineConfigException, IOException, SAXException {
        RegistryNode node = Registry.parse(is, this._schema).getTop();
        return this.configure(bean, node.getFirstChild(), false);
    }

    public Object configure(Object bean, RegistryNode node) throws LineConfigException {
        return this.configure(bean, node, true);
    }

    public void configureNoInit(Object bean, RegistryNode node) throws LineConfigException {
        this.configure(bean, node, false);
    }

    public Object configure(Object bean, RegistryNode node, boolean doInit) throws LineConfigException {
        if (node == null) {
            return bean;
        }
        TypeBuilderFactory oldFactory = TypeBuilderFactory.getFactory();
        try {
            TypeBuilderFactory factory = TypeBuilderFactory.createFactory();
            TypeBuilder builder = factory.getTypeBuilder(bean.getClass());
            Object object = this.configure(builder, bean, node, doInit);
            return object;
        }
        catch (Exception e) {
            throw RegistryBuilder.error(e, node);
        }
        finally {
            TypeBuilderFactory.setFactory(oldFactory);
        }
    }

    private Object configure(TypeBuilder builder, Object bean, RegistryNode node) throws LineConfigException {
        return this.configure(builder, bean, node, true);
    }

    public Object configure(TypeBuilder builder, Object bean, RegistryNode node, boolean doInit) throws LineConfigException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        EnvironmentBean envOwner = null;
        if (oldLoader instanceof EnvironmentClassLoader) {
            envOwner = ((EnvironmentClassLoader)oldLoader).getOwner();
        }
        try {
            if (node.getFilename() != null) {
                builder.setLocation(bean, node.getFilename(), node.getFilename(), node.getLine());
            }
            if (bean instanceof EnvironmentBean) {
                EnvironmentBean envBean = (EnvironmentBean)bean;
                ClassLoader beanLoader = envBean.getClassLoader();
                if (beanLoader != null) {
                    thread.setContextClassLoader(beanLoader);
                }
                ArrayList<Depend> dependList = node.getDependList();
                for (int i = 0; dependList != null && i < dependList.size(); ++i) {
                    Dependency depend = dependList.get(i);
                    Environment.addDependency(depend);
                }
            }
            if (bean instanceof DependencyBean) {
                DependencyBean dependBean = (DependencyBean)bean;
                ArrayList<Depend> dependList = node.getDependList();
                for (int i = 0; dependList != null && i < dependList.size(); ++i) {
                    dependBean.addDependency(dependList.get(i));
                }
            }
            if (node.getValue() != null && !node.getValue().equals("")) {
                builder.addText(bean, node.getValue());
            }
            Object iter = node.iterator();
            while (iter.hasNext()) {
                RegistryNode child = iter.next();
                if (envOwner != null) {
                    thread.setContextClassLoader(envOwner.getClassLoader());
                }
                this.configureChild(builder, bean, child);
            }
            if (doInit) {
                builder.init(bean);
                iter = builder.replaceObject(bean);
                return iter;
            }
            iter = bean;
            return iter;
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw RegistryBuilder.error(e, node);
        }
        finally {
            if (envOwner != null) {
                thread.setContextClassLoader(envOwner.getClassLoader());
            } else {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }

    void configureChild(TypeBuilder typeBuilder, Object bean, RegistryNode child) throws LineConfigException {
        String attrName = child.getName();
        if (attrName.equals("resin:type")) {
            return;
        }
        try {
            AttributeBuilder attributeBuilder = typeBuilder.getAttributeBuilder(attrName);
            TypeBuilder subBuilder = attributeBuilder.getBuilder();
            if (attributeBuilder instanceof ProgramAttributeBuilder) {
                ProgramAttributeBuilder programBuilder = (ProgramAttributeBuilder)attributeBuilder;
                RegistryBuilderChildProgram program = new RegistryBuilderChildProgram(this, child);
                programBuilder.getMethod().invoke(bean, program);
            } else if (attributeBuilder instanceof ProgramPropertyBuilder) {
                ProgramPropertyBuilder propertyBuilder = (ProgramPropertyBuilder)attributeBuilder;
                RegistryBuilderChildProgram program = new RegistryBuilderChildProgram(this, child);
                propertyBuilder.getMethod().invoke(bean, attrName, program);
            } else if (subBuilder instanceof ProgramTypeBuilder) {
                RegistryBuilderChildProgram program = new RegistryBuilderChildProgram(this, child);
                attributeBuilder.setChild(bean, program);
            } else if (!child.hasChildren() && attributeBuilder.isPrimitive()) {
                attributeBuilder.setString(bean, child.getValue());
            } else if (!child.hasChildren() && child.getValue() != null && child.getValue().startsWith("${") && child.getValue().endsWith("}")) {
                attributeBuilder.setString(bean, child.getValue());
            } else {
                String configClass = null;
                ResinType resinType = null;
                String type = child.getString("resin:type", null);
                if (type != null) {
                    resinType = new ResinType();
                    resinType.addText(type);
                    resinType.init();
                    configClass = resinType.getClassName();
                }
                if ((subBuilder = attributeBuilder.getBuilder(configClass)) == null || ClassLiteral.getClass((String)"java/lang/String").equals(subBuilder.getType())) {
                    attributeBuilder.setString(bean, child.getValue());
                } else {
                    Object value = resinType != null ? resinType.create(attributeBuilder.getBuilder().getType()) : attributeBuilder.create(bean, subBuilder);
                    if (value != null && ClassLiteral.getClass((String)"java/lang/Object").equals(value.getClass())) {
                        attributeBuilder.setString(bean, child.getValue());
                    } else {
                        if (value != null) {
                            subBuilder = typeBuilder.getFactory().getTypeBuilder(value.getClass());
                        }
                        value = this.configure(subBuilder, value, child);
                        attributeBuilder.setChild(bean, value);
                    }
                }
            }
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw RegistryBuilder.error(e, child);
        }
    }

    private static LineConfigException error(Throwable e, RegistryNode node) {
        while (e.getCause() != null && !(e instanceof LineCompileException) && !(e instanceof CompileException)) {
            e = e.getCause();
        }
        if (e instanceof LineConfigException) {
            return (LineConfigException)e;
        }
        if (e instanceof ConfigException && e.getMessage() != null) {
            String msg = node.getFilename() + ":" + node.getLine() + ": " + e.getMessage();
            log.log(Level.FINER, e.toString(), e);
            return new LineConfigException(msg, e);
        }
        if (e instanceof LineCompileException) {
            log.log(Level.FINER, e.toString(), e);
            return new LineConfigException(e.getMessage());
        }
        if (e instanceof CompileException && e.getMessage() != null) {
            String msg = node.getFilename() + ":" + node.getLine() + ": " + e.getMessage();
            log.log(Level.FINER, e.toString(), e);
            return new LineConfigException(msg, e);
        }
        String msg = node.getFilename() + ":" + node.getLine() + ": " + e;
        return new LineConfigException(msg, e);
    }
}

