/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeBuilder;
import com.caucho.config.BeanAttributeBuilder;
import com.caucho.config.BeanBuilder;
import com.caucho.config.BeanBuilderException;
import com.caucho.config.ConfigVariableResolver;
import com.caucho.config.EnvironmentAttributeBuilder;
import com.caucho.config.NodePropertyBuilder;
import com.caucho.config.PrimitiveAttributeBuilder;
import com.caucho.config.ProgramTypeBuilder;
import com.caucho.config.TypeBuilder;
import com.caucho.config.types.PrimitiveTypeBuilder;
import com.caucho.el.EL;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.xml.QName;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeBuilderFactory {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/TypeBuilderFactory"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/TypeBuilderFactory"));
    private static EnvironmentLocal<WeakHashMap<Class, SoftReference<TypeBuilder>>> _localBuilderMap = new EnvironmentLocal();
    private static final ThreadLocal<TypeBuilderFactory> _threadFactory = new ThreadLocal();
    private static final QName RESIN_SET = new QName("resin:set", "http://caucho.com/ns/resin/core");
    private static final QName RESIN_LOG = new QName("resin:log", "http://caucho.com/ns/resin/core");
    private static final QName RESIN_IF = new QName("resin:if", "http://caucho.com/ns/resin/core");
    private static final QName RESIN_CHOOSE = new QName("resin:choose", "http://caucho.com/ns/resin/core");
    private static final QName RESIN_ENV = new QName("resin:env", "http://caucho.com/ns/resin/core");
    private static final QName RESIN_INCLUDE = new QName("resin:include", "http://caucho.com/ns/resin/core");
    private static final QName RESIN_INCLUDE_2 = new QName("resin:include", null);
    private static final QName RESIN_IMPORT = new QName("resin:import", "http://caucho.com/ns/resin/core");
    private static HashMap<QName, AttributeBuilder> _flowAttributes = new HashMap();
    private static HashMap<QName, AttributeBuilder> _envAttributes;
    private HashMap<Class, Class> _proxyTypeMap = new HashMap();
    private ConfigVariableResolver _varResolver = new ConfigVariableResolver();

    public TypeBuilderFactory() {
        this._proxyTypeMap.put(ClassLiteral.getClass((String)"com/caucho/vfs/Path"), ClassLiteral.getClass((String)"com/caucho/config/types/PathBuilder"));
        this._proxyTypeMap.put(ClassLiteral.getClass((String)"java/io/File"), ClassLiteral.getClass((String)"com/caucho/config/types/FileBuilder"));
        this._proxyTypeMap.put(ClassLiteral.getClass((String)"javax/sql/DataSource"), ClassLiteral.getClass((String)"com/caucho/config/types/DataSourceBuilder"));
    }

    public TypeBuilderFactory(VariableResolver varResolver) {
        this();
        if (varResolver instanceof ConfigVariableResolver) {
            this._varResolver = (ConfigVariableResolver)varResolver;
        }
    }

    public static TypeBuilderFactory getFactory() {
        return _threadFactory.get();
    }

    public static void setFactory(TypeBuilderFactory factory) {
        _threadFactory.set(factory);
    }

    public static TypeBuilderFactory createFactory() {
        return TypeBuilderFactory.createFactory(null);
    }

    public static TypeBuilderFactory createFactory(VariableResolver varResolver) {
        TypeBuilderFactory factory = _threadFactory.get();
        if (factory == null) {
            factory = new TypeBuilderFactory(varResolver);
            _threadFactory.set(factory);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAttribute(Object obj, String attr, Object value) throws Exception {
        TypeBuilderFactory oldFactory = TypeBuilderFactory.getFactory();
        try {
            TypeBuilderFactory factory = TypeBuilderFactory.createFactory();
            TypeBuilder builder = factory.getTypeBuilder(obj.getClass());
            if (value instanceof String) {
                builder.setAttribute(obj, attr, (String)value);
            } else {
                builder.setAttribute(obj, attr, value);
            }
        }
        finally {
            TypeBuilderFactory.setFactory(oldFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Object obj) throws Exception {
        TypeBuilderFactory oldFactory = TypeBuilderFactory.getFactory();
        try {
            TypeBuilderFactory factory = TypeBuilderFactory.createFactory();
            TypeBuilder builder = factory.getTypeBuilder(obj.getClass());
            builder.init(obj);
        }
        finally {
            TypeBuilderFactory.setFactory(oldFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object replaceObject(Object obj) throws Exception {
        TypeBuilderFactory oldFactory = TypeBuilderFactory.getFactory();
        try {
            TypeBuilderFactory factory = TypeBuilderFactory.createFactory();
            TypeBuilder builder = factory.getTypeBuilder(obj.getClass());
            Object object = builder.replaceObject(obj);
            return object;
        }
        finally {
            TypeBuilderFactory.setFactory(oldFactory);
        }
    }

    public static VariableResolver getEnvironment() {
        TypeBuilderFactory factory = TypeBuilderFactory.getFactory();
        if (factory != null) {
            return factory._varResolver;
        }
        return EL.getEnvironment();
    }

    public static VariableResolver getVariableResolver() {
        TypeBuilderFactory factory = TypeBuilderFactory.getFactory();
        if (factory != null) {
            return factory._varResolver;
        }
        return null;
    }

    public static ConfigVariableResolver getConfigVariableResolver() {
        return TypeBuilderFactory.getFactory()._varResolver;
    }

    public static Object putVar(String name, Object value) {
        return TypeBuilderFactory.getFactory()._varResolver.put(name, value);
    }

    public static String evalString(String string) throws ELException {
        return AttributeBuilder.evalString(string);
    }

    public TypeBuilder getTypeBuilder(Class type) throws Exception {
        SoftReference<TypeBuilder> ref;
        TypeBuilder builder;
        WeakHashMap<Class<Object>, SoftReference<TypeBuilder>> builderMap = _localBuilderMap.getLevel(type.getClassLoader());
        if (builderMap == null) {
            builderMap = new WeakHashMap();
            _localBuilderMap.set(builderMap, type.getClassLoader());
        }
        TypeBuilder typeBuilder = builder = (ref = builderMap.get(type)) != null ? ref.get() : null;
        if (builder == null) {
            builder = this.createTypeBuilder(type, builderMap);
            builderMap.put(type, new SoftReference<TypeBuilder>(builder));
        }
        return builder;
    }

    private TypeBuilder createTypeBuilder(Class type, WeakHashMap<Class, SoftReference<TypeBuilder>> map) throws Exception {
        if (type == null) {
            throw new BeanBuilderException(L.l("Null type."));
        }
        Class proxyType = this._proxyTypeMap.get(type);
        if (proxyType != null) {
            type = proxyType;
        }
        if (PrimitiveTypeBuilder.accepts(type)) {
            return new PrimitiveTypeBuilder(type);
        }
        if (ClassLiteral.getClass((String)"com/caucho/config/BuilderProgram").equals(type)) {
            return new ProgramTypeBuilder(type);
        }
        BeanBuilder builder = new BeanBuilder(type);
        map.put(type, new SoftReference<BeanBuilder>(builder));
        if (ClassLiteral.getClass((String)"com/caucho/loader/EnvironmentBean").isAssignableFrom(type)) {
            builder.setEnvAttributeMap(_envAttributes);
        }
        return builder;
    }

    public AttributeBuilder getAttributeBuilder(Method setter) throws Exception {
        Class<?> type;
        if (setter == null) {
            throw new BeanBuilderException(L.l("Null setter."));
        }
        Class<?>[] param = setter.getParameterTypes();
        if (param.length == 0) {
            type = setter.getReturnType();
        } else if (param.length == 1) {
            type = param[0];
            if (PrimitiveAttributeBuilder.accepts(type)) {
                return new PrimitiveAttributeBuilder(setter, type);
            }
            if (ClassLiteral.getClass((String)"org/w3c/dom/Node").equals(type)) {
                return new NodePropertyBuilder(setter);
            }
        } else {
            throw new BeanBuilderException(L.l("bad method {0}", setter));
        }
        TypeBuilder builder = this.getTypeBuilder(type);
        BeanAttributeBuilder attrBuilder = new BeanAttributeBuilder();
        attrBuilder.setMethod(setter);
        attrBuilder.setTypeBuilder(builder);
        return attrBuilder;
    }

    public static AttributeBuilder getFlowAttribute(QName name) throws Exception {
        return _flowAttributes.get(name);
    }

    static {
        try {
            TypeBuilderFactory factory = new TypeBuilderFactory();
            EnvironmentAttributeBuilder attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/core/ResinSet")));
            _flowAttributes.put(RESIN_SET, attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/core/ResinLog")));
            _flowAttributes.put(RESIN_LOG, attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/core/ResinIf")));
            _flowAttributes.put(RESIN_IF, attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/core/ResinChoose")));
            _flowAttributes.put(RESIN_CHOOSE, attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/core/ResinEnv")));
            _flowAttributes.put(RESIN_ENV, attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/core/ResinInclude")));
            _flowAttributes.put(RESIN_INCLUDE, attr);
            _flowAttributes.put(RESIN_INCLUDE_2, attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/core/ResinImport")));
            _flowAttributes.put(RESIN_IMPORT, attr);
            _envAttributes = new HashMap();
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/types/Authenticator")));
            _envAttributes.put(new QName("authenticator"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/vfs/CaseInsensitive")));
            _envAttributes.put(new QName("case-insensitive"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/i18n/CharacterEncoding")));
            _envAttributes.put(new QName("character-encoding"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/loader/DependencyCheckInterval")));
            _envAttributes.put(new QName("class-update-interval"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/loader/ClasspathConfig")));
            _envAttributes.put(new QName("classpath"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/loader/ClassLoaderConfig")));
            _envAttributes.put(new QName("class-loader"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/server/cluster/Cluster")));
            _envAttributes.put(new QName("cluster"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterDef")));
            _envAttributes.put(new QName("cluster-definition"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/server/cluster/PersistentStoreConfig")));
            _envAttributes.put(new QName("persistent-store"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/sql/DBPool")));
            _envAttributes.put(new QName("database"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/loader/DependencyCheckInterval")));
            _envAttributes.put(new QName("dependency-check-interval"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/make/DependencyConfig")));
            _envAttributes.put(new QName("dependency"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/types/EnvEntry")));
            _envAttributes.put(new QName("env-entry"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/types/EjbRef")));
            _envAttributes.put(new QName("ejb-ref"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/types/EjbLocalRef")));
            _envAttributes.put(new QName("ejb-local-ref"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/log/ErrorLog")));
            _envAttributes.put(new QName("error-log"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/security/GrantConfig")));
            _envAttributes.put(new QName("grant"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/java/JavacConfig")));
            _envAttributes.put(new QName("javac"), attr);
            _envAttributes.put(new QName("java"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/naming/LinkProxy")));
            _envAttributes.put(new QName("jndi-link"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/log/LogConfig")));
            _envAttributes.put(new QName("log"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/jmx/MBeanConfig")));
            _envAttributes.put(new QName("mbean"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/types/ReferenceConfig")));
            _envAttributes.put(new QName("reference"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/jca/Resource")));
            _envAttributes.put(new QName("resource"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/jca/ConnectorResource")));
            _envAttributes.put(new QName("connector"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/types/ResourceEnvRef")));
            _envAttributes.put(new QName("resource-env-ref"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/config/types/ResourceRef")));
            _envAttributes.put(new QName("resource-ref"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/loader/ServletClassloaderHack")));
            _envAttributes.put(new QName("servlet-classloader-hack"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/log/StderrLog")));
            _envAttributes.put(new QName("stderr-log"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/log/StdoutLog")));
            _envAttributes.put(new QName("stdout-log"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/loader/SystemProperty")));
            _envAttributes.put(new QName("system-property"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/java/WorkDir")));
            _envAttributes.put(new QName("work-dir"), attr);
            _envAttributes.put(new QName("work-directory"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/java/TempDir")));
            _envAttributes.put(new QName("temp-dir"), attr);
            _envAttributes.put(new QName("temporary-directory"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/jca/ResourceDeploy")));
            _envAttributes.put(new QName("resource-deploy"), attr);
            attr = new EnvironmentAttributeBuilder();
            attr.setTypeBuilder(factory.getTypeBuilder(ClassLiteral.getClass((String)"com/caucho/jca/ResourceManagerConfig")));
            _envAttributes.put(new QName("resource-manager"), attr);
            try {
                Class<?> ejbClass = Class.forName("com.caucho.ejb.EJBServer");
                if (ejbClass != null) {
                    attr = new EnvironmentAttributeBuilder();
                    attr.setTypeBuilder(factory.getTypeBuilder(ejbClass));
                    _envAttributes.put(new QName("ejb-server"), attr);
                }
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

