/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.TypeBuilderFactory;
import com.caucho.config.types.RawString;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.el.MapVariableResolver;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathBuilder {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/types/PathBuilder"));
    private String _userPath;

    public void addText(RawString text) {
        this._userPath = text.getValue().trim();
    }

    public Path replaceObject() throws ELException {
        return PathBuilder.lookupPath(this._userPath, TypeBuilderFactory.getEnvironment());
    }

    public static Path lookupPath(String string) throws ELException {
        return PathBuilder.lookupPath(string, TypeBuilderFactory.getEnvironment());
    }

    public static Path lookupPath(String string, ArrayList vars) throws ELException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        return PathBuilder.lookupPath(string, map);
    }

    public static Path lookupPath(String string, HashMap<String, Object> map) throws ELException {
        VariableResolver parent = TypeBuilderFactory.getEnvironment();
        VariableResolver resolver = map != null ? new MapVariableResolver(map, parent) : parent;
        return PathBuilder.lookupPath(string, resolver);
    }

    public static Path lookupPath(String string, VariableResolver env) throws ELException {
        return PathBuilder.lookupPath(string, env, Vfs.lookup());
    }

    public static Path lookupPath(String string, VariableResolver env, Path pwd) throws ELException {
        Expr expr = new ELParser(string = PathBuilder.rewritePathString(string)).parse();
        Object obj = expr.evalObject(env);
        if (obj instanceof Path) {
            return (Path)obj;
        }
        String value = Expr.toString(obj, env);
        if (pwd != null) {
            return pwd.lookup(value);
        }
        return Vfs.lookup(value);
    }

    public static String rewritePathString(String pathName) {
        CharBuffer cb = CharBuffer.allocate();
        int length = pathName.length();
        for (int i = 0; i < length; ++i) {
            char ch = pathName.charAt(i);
            if (ch != '$') {
                cb.append(ch);
                continue;
            }
            if (i + 1 == length) {
                cb.append('$');
                continue;
            }
            ch = pathName.charAt(i + 1);
            if ('0' <= ch && ch <= '9') {
                int value = 0;
                ++i;
                while (i < length && (ch = pathName.charAt(i)) >= '0' && ch <= '9') {
                    value = 10 * value + ch - 48;
                    ++i;
                }
                --i;
                cb.append(new StringBuffer().append("${regexp[").append(value).append("]}").toString());
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z') {
                int tail;
                for (tail = i + 1; tail < length && (ch = pathName.charAt(tail)) != '/' && ch != '\\' && ch != '$'; ++tail) {
                }
                cb.append(new StringBuffer().append("${Var[\"").append(pathName.substring(i + 1, tail)).append("\"]}").toString());
                i = tail - 1;
                continue;
            }
            cb.append('$');
        }
        return cb.close();
    }
}

