/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PathPatternType {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/types/PathPatternType"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/types/PathPatternType"));
    private Pattern _pattern;

    public PathPatternType() {
    }

    public PathPatternType(String pattern) throws ConfigException, PatternSyntaxException {
        this.setName(pattern);
    }

    public void setName(String pattern) throws ConfigException, PatternSyntaxException {
        int i;
        CharBuffer cb = new CharBuffer();
        cb.append("^");
        int length = pattern.length();
        for (i = 0; i < length && pattern.charAt(i) == '/'; ++i) {
        }
        while (i < length) {
            char ch = pattern.charAt(i);
            if (ch == '/') {
                cb.append('/');
            } else if (ch != '*') {
                cb.append(ch);
            } else if (length <= i + 1 || pattern.charAt(i + 1) != '*') {
                cb.append("[^/]*");
            } else {
                if (i > 0 && pattern.charAt(i - 1) != '/') {
                    throw new ConfigException(L.l("'{0}' is an invalid pattern at '**'", pattern));
                }
                if (i + 2 < length && pattern.charAt(i + 2) == '/') {
                    cb.append("([^/]*/)*");
                    i += 2;
                } else {
                    if (i + 2 < length) {
                        throw new ConfigException(L.l("'{0}' is an invalid pattern at '**'", pattern));
                    }
                    cb.append(".*");
                    ++i;
                }
            }
            ++i;
        }
        cb.append("$");
        this._pattern = Pattern.compile(cb.toString());
    }

    public void init() throws ConfigException {
        if (this._pattern == null) {
            throw new ConfigException(L.l("pattern requires 'name' attribute."));
        }
    }

    public boolean isMatch(String path) {
        return this._pattern.matcher(path).matches();
    }

    public String toString() {
        return "PathPatternType[" + this._pattern.pattern() + "]";
    }
}

