/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.rc.retroweaver.runtime.ClassLiteral;

public class Period {
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/types/Period"));
    private static final long DAY = 86400000L;
    private static final QDate _localCalendar = QDate.createLocal();
    private long _period;

    public Period() {
    }

    public Period(long period) {
        this._period = period;
    }

    public void addText(String text) throws ConfigException {
        this._period = Period.toPeriod(text);
    }

    public long getPeriod() {
        return this._period;
    }

    public static long toPeriod(String value) throws ConfigException {
        if (value == null) {
            return 0L;
        }
        long sign = 1L;
        long period = 0L;
        int i = 0;
        int length = value.length();
        if (length > 0 && value.charAt(i) == '-') {
            sign = -1L;
            ++i;
        }
        block9: while (i < length) {
            char ch;
            long delta = 0L;
            while (i < length && (ch = value.charAt(i)) >= '0' && ch <= '9') {
                delta = 10L * delta + (long)ch - 48L;
                ++i;
            }
            if (i >= length) {
                period += 1000L * delta;
                continue;
            }
            ch = value.charAt(i++);
            switch (ch) {
                case 's': {
                    period += 1000L * delta;
                    continue block9;
                }
                case 'm': {
                    if (i < value.length() && value.charAt(i) == 's') {
                        ++i;
                        period += delta;
                        continue block9;
                    }
                    period += 60000L * delta;
                    continue block9;
                }
                case 'h': {
                    period += 3600000L * delta;
                    continue block9;
                }
                case 'D': {
                    period += 86400000L * delta;
                    continue block9;
                }
                case 'W': {
                    period += 604800000L * delta;
                    continue block9;
                }
                case 'M': {
                    period += 2592000000L * delta;
                    continue block9;
                }
                case 'Y': {
                    period += 31536000000L * delta;
                    continue block9;
                }
            }
            throw new ConfigException(L.l("Unknown unit `{0}' in period `{1}'. Valid units are:\n  '10ms' milliseconds\n  '10s' seconds\n  '10m' minutes\n  '10h' hours\n  '10D' days\n  '10W' weeks\n  '10M' months\n  '10Y' years", (Object)String.valueOf(ch), value));
        }
        return sign * period;
    }

    public static long periodEnd(long now, long period) {
        return Period.periodEnd(now, period, _localCalendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long periodEnd(long now, long period, QDate cal) {
        if (period < 0L) {
            return Long.MAX_VALUE;
        }
        if (period == 0L) {
            return now;
        }
        if (period < 2592000000L) {
            QDate qDate = cal;
            synchronized (qDate) {
                cal.setGMTTime(now);
                long localTime = cal.getLocalTime();
                localTime += period - (localTime + 345600000L) % period;
                cal.setLocalTime(localTime);
                return cal.getGMTTime();
            }
        }
        if (period % 2592000000L == 0L) {
            int months = (int)(period / 2592000000L);
            QDate localTime = cal;
            synchronized (localTime) {
                cal.setGMTTime(now);
                long year = cal.getYear();
                int month = cal.getMonth();
                cal.setLocalTime(0L);
                cal.setDate(year, month + months, 1L);
                return cal.getGMTTime();
            }
        }
        if (period % 31536000000L == 0L) {
            long years = period / 31536000000L;
            QDate qDate = cal;
            synchronized (qDate) {
                cal.setGMTTime(now);
                long year = cal.getYear();
                cal.setLocalTime(0L);
                long newYear = year + (years - year % years);
                cal.setDate(newYear, 0L, 1L);
                return cal.getGMTTime();
            }
        }
        QDate qDate = cal;
        synchronized (qDate) {
            cal.setGMTTime(now);
            long localTime = cal.getLocalTime();
            localTime += period - (localTime + 345600000L) % period;
            cal.setLocalTime(localTime);
            return cal.getGMTTime();
        }
    }
}

