/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db;

import com.caucho.db.sql.Parser;
import com.caucho.db.sql.Query;
import com.caucho.db.store.BlockManager;
import com.caucho.db.store.Lock;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableFactory;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Database {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/Database"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/Database"));
    private Path _dir;
    private BlockManager _blockManager = new BlockManager();
    private HashMap<String, Table> _tables = new HashMap();
    private LruCache<String, Query> _cachedQueries = new LruCache(128);
    private Lock _databaseLock = new Lock(0L);
    private int _tableId;
    private boolean _removeOnError;
    private long _timeout = 1000L;

    public void setPath(Path dir) {
        this._dir = dir;
    }

    public void setRemoveOnError(boolean remove) {
        this._removeOnError = remove;
    }

    public void init() throws SQLException {
        this._blockManager.init();
        Path dir = this._dir;
        String[] list = null;
        try {
            list = dir.list();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".db")) continue;
            name = name.substring(0, name.length() - 3);
            try {
                Table table = Table.loadFromFile(this, name);
                table.init();
                this._tables.put(name, table);
                continue;
            }
            catch (Throwable e) {
                if (this._removeOnError) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, e.toString(), e);
                    } else {
                        log.warning(e.toString());
                    }
                    try {
                        dir.lookup(name + ".db").remove();
                    }
                    catch (IOException e1) {}
                    continue;
                }
                throw new SQLExceptionWrapper(e);
            }
        }
    }

    public Path getPath() {
        return this._dir;
    }

    public BlockManager getBlockManager() {
        return this._blockManager;
    }

    public TableFactory createTableFactory() {
        return new TableFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateTableId() {
        Database database = this;
        synchronized (database) {
            return this._tableId++;
        }
    }

    public void addTable(Table table) throws IOException {
        log.fine("adding table " + table.getName());
        table.init();
        this._tables.put(table.getName(), table);
    }

    public Table getTable(String name) {
        return this._tables.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String name) throws SQLException {
        Table table = null;
        Database database = this;
        synchronized (database) {
            table = this._tables.get(name);
            if (table == null) {
                throw new SQLException(L.l("Table {0} does not exist.  DROP TABLE can only drop an existing table.", name));
            }
            this._tables.remove(name);
            this._cachedQueries.clear();
        }
        table.remove();
    }

    public Query parseQuery(String sql) throws SQLException {
        Query query = this._cachedQueries.get(sql);
        if (query == null) {
            query = Parser.parse(this, sql);
            this._cachedQueries.put(sql, query);
        }
        return query;
    }

    public void close() {
    }
}

