/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.index;

import com.caucho.db.Database;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.store.Block;
import com.caucho.db.store.BlockManager;
import com.caucho.db.store.Store;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTree {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/index/BTree"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/index/BTree"));
    private static final int BLOCK_SIZE = 65536;
    private static final long FAIL = Long.MIN_VALUE;
    private static final int PTR_SIZE = 8;
    private static final int FLAGS_OFFSET = 0;
    private static final int LENGTH_OFFSET = 4;
    private static final int PARENT_OFFSET = 8;
    private static final int NEXT_OFFSET = 16;
    private static final int HEADER_SIZE = 24;
    private static final int LEAF_FLAG = 1;
    private BlockManager _blockManager;
    private Store _store;
    private long _indexRoot;
    private int _keySize;
    private int _tupleSize;
    private int _n;
    private KeyCompare _keyCompare;
    private int _blockCount;
    private volatile boolean _isStarted;

    public BTree(Store store, long indexRoot, int keySize, KeyCompare keyCompare) throws IOException {
        if (keyCompare == null) {
            throw new NullPointerException();
        }
        this._store = store;
        this._blockManager = this._store.getBlockManager();
        this._indexRoot = indexRoot;
        if (65536 < keySize + 24) {
            throw new IOException(L.l("BTree key size `{0}' is too large.", keySize));
        }
        this._keySize = keySize;
        this._tupleSize = keySize + 16 - 1;
        this._tupleSize -= this._tupleSize % 8;
        this._n = 65512 / this._tupleSize;
        this._keyCompare = keyCompare;
    }

    public long getIndexRoot() {
        return this._indexRoot;
    }

    public void create() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lookup(byte[] keyBuffer, int keyOffset, int keyLength) throws IOException {
        long index = this._indexRoot;
        while (index != 0L) {
            Block block = this._blockManager.getBlock(this._store, this._store.addressToBlockId(index));
            boolean isLeaf = true;
            try {
                block.read();
                byte[] buffer = block.getBuffer();
                int flags = this.getInt(buffer, 0);
                isLeaf = (flags & 1) == 0;
                index = this.lookupTuple(buffer, keyBuffer, keyOffset, keyLength, isLeaf);
            }
            finally {
                block.free();
            }
            if (!isLeaf && index != Long.MIN_VALUE) continue;
            return index;
        }
        return Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(byte[] keyBuffer, int keyOffset, int keyLength, long value) throws SQLException {
        try {
            if (value == Long.MIN_VALUE) {
                throw new IllegalArgumentException();
            }
            long index = this._indexRoot;
            long parentIndex = 0L;
            while (index != Long.MIN_VALUE) {
                long lastIndex = index;
                Block block = this._blockManager.getBlock(this._store, this._store.addressToBlockId(index));
                try {
                    block.read();
                    byte[] buffer = block.getBuffer();
                    int flags = this.getInt(buffer, 0);
                    boolean isLeaf = (flags & 1) == 0;
                    int length = this.getInt(buffer, 4);
                    if (length == this._n) {
                        Block freeBlock;
                        if (index == this._indexRoot) {
                            freeBlock = block;
                            block = null;
                            freeBlock.free();
                            this.split(index);
                            continue;
                        }
                        if (parentIndex != 0L) {
                            freeBlock = block;
                            block = null;
                            freeBlock.free();
                            this.split(parentIndex, index);
                            index = parentIndex;
                            parentIndex = 0L;
                            continue;
                        }
                    }
                    if (!isLeaf) {
                        parentIndex = index;
                        index = this.lookupTuple(buffer, keyBuffer, keyOffset, keyLength, isLeaf);
                        continue;
                    }
                    this.insertLeafBlock(index, block.getBuffer(), keyBuffer, keyOffset, keyLength, value);
                    block.write();
                    return;
                }
                finally {
                    if (block == null) continue;
                    block.free();
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private long insertLeafBlock(long blockIndex, byte[] block, byte[] keyBuffer, int keyOffset, int keyLength, long value) throws IOException {
        int offset = 24;
        int tupleSize = this._tupleSize;
        int length = this.getInt(block, 4);
        for (int i = 0; i < length; ++i) {
            int cmp = this._keyCompare.compare(keyBuffer, keyOffset, block, offset + 8, keyLength);
            if (0 < cmp) {
                offset += tupleSize;
                continue;
            }
            if (cmp == 0) {
                this.setPointer(block, offset, value);
                return 0L;
            }
            if (length < this._n) {
                return this.addKey(blockIndex, block, offset, i, length, keyBuffer, keyOffset, keyLength, value);
            }
            throw new IllegalStateException("ran out of key space");
        }
        if (length < this._n) {
            return this.addKey(blockIndex, block, offset, length, length, keyBuffer, keyOffset, keyLength, value);
        }
        throw new IllegalStateException();
    }

    private long addKey(long blockIndex, byte[] block, int offset, int index, int length, byte[] keyBuffer, int keyOffset, int keyLength, long value) throws IOException {
        int tupleSize = this._tupleSize;
        if (index < length) {
            System.arraycopy(block, offset, block, offset + tupleSize, (length - index) * tupleSize);
        }
        this.setPointer(block, offset, value);
        this.setInt(block, 4, length + 1);
        if (log.isLoggable(Level.FINER)) {
            log.finer(new StringBuffer().append("btree insert at ").append(blockIndex / 65536L).append(":").append(offset).append(" value:").append(value).toString());
        }
        System.arraycopy(keyBuffer, keyOffset, block, offset + 8, keyLength);
        for (int j = tupleSize - 8 - keyLength; j >= 0; --j) {
            block[offset + tupleSize - j] = 0;
        }
        return -value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split(long parentIndex, long index) throws IOException {
        log.finer(new StringBuffer().append("btree splitting ").append(index / 65536L).toString());
        Block parentBlock = null;
        Block leftBlock = null;
        Block rightBlock = null;
        try {
            parentBlock = this._blockManager.getBlock(this._store, this._store.addressToBlockId(parentIndex));
            parentBlock.read();
            byte[] parentBuffer = parentBlock.getBuffer();
            int parentLength = this.getInt(parentBuffer, 4);
            rightBlock = this._blockManager.getBlock(this._store, this._store.addressToBlockId(index));
            rightBlock.read();
            byte[] rightBuffer = rightBlock.getBuffer();
            long rightBlockId = rightBlock.getBlockId();
            leftBlock = this._store.allocate();
            byte[] leftBuffer = leftBlock.getBuffer();
            long leftBlockId = leftBlock.getBlockId();
            int length = this.getInt(rightBuffer, 4);
            int pivot = (length - 1) / 2;
            int pivotOffset = 24 + pivot * this._tupleSize;
            System.arraycopy(rightBuffer, 24, leftBuffer, 24, pivotOffset + this._tupleSize - 24);
            this.setInt(leftBuffer, 0, this.getInt(rightBuffer, 0));
            this.setInt(leftBuffer, 4, pivot + 1);
            this.setPointer(leftBuffer, 16, rightBlockId);
            this.setPointer(leftBuffer, 8, parentIndex);
            System.arraycopy(rightBuffer, pivotOffset + this._tupleSize, rightBuffer, 24, (length - pivot - 1) * this._tupleSize);
            this.setInt(rightBuffer, 4, length - pivot - 1);
            this.insertLeafBlock(parentIndex, parentBuffer, leftBuffer, pivotOffset + 8, this._keySize, leftBlockId);
            leftBlock.write();
            rightBlock.write();
            parentBlock.write();
        }
        finally {
            if (parentBlock != null) {
                parentBlock.free();
            }
            if (leftBlock != null) {
                leftBlock.free();
            }
            if (rightBlock != null) {
                rightBlock.free();
            }
        }
    }

    private long split(long index) throws IOException {
        log.finer(new StringBuffer().append("btree splitting ").append(index / 65536L).toString());
        Block parentBlock = this._blockManager.getBlock(this._store, this._store.addressToBlockId(index));
        parentBlock.read();
        byte[] parentBuffer = parentBlock.getBuffer();
        int parentFlags = this.getInt(parentBuffer, 0);
        Block leftBlock = this._store.allocate();
        long leftBlockId = leftBlock.getBlockId();
        Block rightBlock = this._store.allocate();
        long rightBlockId = rightBlock.getBlockId();
        int length = this.getInt(parentBuffer, 4);
        int pivot = (length - 1) / 2;
        int pivotOffset = 24 + pivot * this._tupleSize;
        long pivotValue = this.getPointer(parentBuffer, pivotOffset);
        byte[] leftBuffer = leftBlock.getBuffer();
        System.arraycopy(parentBuffer, 24, leftBuffer, 24, pivotOffset + this._tupleSize - 24);
        this.setInt(leftBuffer, 0, parentFlags);
        this.setInt(leftBuffer, 4, pivot + 1);
        this.setPointer(leftBuffer, 8, index);
        this.setPointer(leftBuffer, 16, rightBlockId);
        leftBlock.write();
        leftBlock.free();
        byte[] rightBuffer = rightBlock.getBuffer();
        System.arraycopy(parentBuffer, pivotOffset + this._tupleSize, rightBuffer, 24, (length - pivot - 1) * this._tupleSize);
        this.setInt(rightBuffer, 0, parentFlags);
        this.setInt(rightBuffer, 4, length - pivot - 1);
        this.setPointer(rightBuffer, 8, index);
        this.setPointer(rightBuffer, 16, this.getPointer(parentBuffer, 16));
        rightBlock.write();
        rightBlock.free();
        System.arraycopy(parentBuffer, pivotOffset, parentBuffer, 24, this._tupleSize);
        this.setPointer(parentBuffer, 24, leftBlockId);
        this.setInt(parentBuffer, 0, 1);
        this.setInt(parentBuffer, 4, 1);
        this.setPointer(parentBuffer, 16, rightBlockId);
        parentBlock.write();
        parentBlock.free();
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] keyBuffer, int keyOffset, int keyLength) throws SQLException {
        try {
            long index = this._indexRoot;
            while (index != Long.MIN_VALUE) {
                Block block = this._blockManager.getBlock(this._store, this._store.addressToBlockId(index));
                block.read();
                try {
                    boolean isLeaf;
                    byte[] buffer = block.getBuffer();
                    int flags = this.getInt(buffer, 0);
                    boolean bl = isLeaf = (flags & 1) == 0;
                    if (isLeaf) {
                        this.removeLeafBlock(index, block.getBuffer(), keyBuffer, keyOffset, keyLength);
                        block.write();
                        return;
                    }
                    index = this.lookupTuple(buffer, keyBuffer, keyOffset, keyLength, false);
                }
                finally {
                    block.free();
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private long lookupTuple(byte[] block, byte[] keyBuffer, int keyOffset, int keyLength, boolean isLeaf) throws IOException {
        int length = this.getInt(block, 4);
        int offset = 24;
        int tupleSize = this._tupleSize;
        int end = offset + length * tupleSize;
        while (length > 0) {
            int tail = offset + tupleSize * length;
            int delta = tupleSize * (length / 2);
            int newOffset = offset + delta;
            int cmp = this._keyCompare.compare(keyBuffer, keyOffset, block, 8 + newOffset, keyLength);
            if (cmp == 0) {
                return this.getPointer(block, newOffset);
            }
            if (cmp > 0) {
                offset = newOffset + tupleSize;
                length = (tail - offset) / tupleSize;
            } else if (cmp < 0) {
                length /= 2;
            }
            if (length > 0) continue;
            if (isLeaf) {
                return 0L;
            }
            if (cmp < 0) {
                return this.getPointer(block, newOffset);
            }
            if (offset == end) {
                return this.getPointer(block, 16);
            }
            return this.getPointer(block, offset);
        }
        if (isLeaf) {
            return 0L;
        }
        return this.getPointer(block, 16);
    }

    private long removeLeafBlock(long blockIndex, byte[] block, byte[] keyBuffer, int keyOffset, int keyLength) throws IOException {
        int offset = 24;
        int tupleSize = this._tupleSize;
        int length = this.getInt(block, 4);
        for (int i = 0; i < length; ++i) {
            int cmp = this._keyCompare.compare(keyBuffer, keyOffset, block, offset + 8, keyLength);
            if (0 < cmp) {
                offset += tupleSize;
                continue;
            }
            if (cmp == 0) {
                int tupleLength = length * tupleSize;
                if (offset + tupleSize < 24 + tupleLength) {
                    System.arraycopy(block, offset + tupleSize, block, offset, 24 + tupleLength - offset - tupleSize);
                }
                this.setInt(block, 4, length - 1);
                return i;
            }
            return 0L;
        }
        return 0L;
    }

    private int getInt(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
    }

    private long getPointer(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    private void setInt(byte[] buffer, int offset, int value) {
        buffer[offset + 0] = (byte)(value >> 24);
        buffer[offset + 1] = (byte)(value >> 16);
        buffer[offset + 2] = (byte)(value >> 8);
        buffer[offset + 3] = (byte)value;
    }

    private void setPointer(byte[] buffer, int offset, long value) {
        buffer[offset + 0] = (byte)(value >> 56);
        buffer[offset + 1] = (byte)(value >> 48);
        buffer[offset + 2] = (byte)(value >> 40);
        buffer[offset + 3] = (byte)(value >> 32);
        buffer[offset + 4] = (byte)(value >> 24);
        buffer[offset + 5] = (byte)(value >> 16);
        buffer[offset + 6] = (byte)(value >> 8);
        buffer[offset + 7] = (byte)value;
    }

    private synchronized void start() throws IOException {
        if (this._isStarted) {
            return;
        }
        this._isStarted = true;
    }

    public ArrayList<String> getBlockKeys(long blockIndex) throws IOException {
        Block block = this._blockManager.getBlock(this._store, this._store.addressToBlockId(blockIndex * 65536L));
        block.read();
        byte[] buffer = block.getBuffer();
        int length = this.getInt(buffer, 4);
        int offset = 24;
        int tupleSize = this._tupleSize;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            byte ch;
            CharBuffer cb = new CharBuffer();
            for (int j = 8; j < tupleSize && (ch = buffer[offset + i * tupleSize + j]) != 0; ++j) {
                cb.append((char)ch);
            }
            keys.add(cb.toString());
        }
        block.free();
        return keys;
    }

    public static BTree createTest(Path path, int keySize) throws IOException, SQLException {
        Database db = new Database();
        db.setPath(path);
        db.init();
        Store store = new Store(db, "test", null);
        store.create();
        Block block = store.allocate();
        long blockId = block.getBlockId();
        block.free();
        return new BTree(store, blockId, keySize, new KeyCompare());
    }

    public String toString() {
        return new StringBuffer().append("BTree[").append(this._store).append(",").append(this._indexRoot / 65536L).append("]").toString();
    }
}

