/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.jdbc.AbstractResultSet;
import com.caucho.db.sql.Data;
import com.caucho.db.table.Column;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class GeneratedKeysResultSet
extends AbstractResultSet {
    private ArrayList<Data> _keys = new ArrayList();
    private Statement _stmt;
    private int _row;

    public void init(Statement stmt) {
        this._stmt = stmt;
        this._row = 0;
    }

    public void init() {
        this._row = 0;
    }

    public Statement getStatement() throws SQLException {
        return this._stmt;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    public boolean next() throws SQLException {
        return this._row++ == 0;
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public int findColumn(String columnName) throws SQLException {
        for (int i = 0; i < this._keys.size(); ++i) {
            Column column = this._keys.get(i).getColumn();
            if (!column.getName().equals(columnName)) continue;
            return i + 1;
        }
        throw new SQLException(L.l("`{0}' is an unknown column.", columnName));
    }

    public void setColumn(int index, Column column) {
        Data data = this.addData(index);
        data.setColumn(column);
    }

    public String getString(int columnIndex) throws SQLException {
        Data data = this._keys.get(columnIndex - 1);
        return data.getString();
    }

    public void setString(int columnIndex, String value) throws SQLException {
        Data data = this.addData(columnIndex);
        data.setString(value);
    }

    public int getInt(int columnIndex) throws SQLException {
        Data data = this._keys.get(columnIndex - 1);
        return data.getInt();
    }

    public void setInt(int columnIndex, int value) throws SQLException {
        Data data = this.addData(columnIndex);
        data.setInt(value);
    }

    public long getLong(int columnIndex) throws SQLException {
        Data data = this._keys.get(columnIndex - 1);
        return data.getLong();
    }

    public void setLong(int columnIndex, long value) throws SQLException {
        Data data = this.addData(columnIndex);
        data.setLong(value);
    }

    private Data addData(int columnIndex) {
        for (int i = this._keys.size(); i < columnIndex; ++i) {
            this._keys.add(new Data());
        }
        return this._keys.get(columnIndex - 1);
    }

    public void close() {
        this._stmt = null;
    }
}

