/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Data;
import com.caucho.db.sql.ExistsQuery;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SubSelectExpr;
import com.caucho.db.sql.SubSelectParamExpr;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistsExpr
extends SubSelectExpr {
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/sql/ExistsExpr"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/ExistsExpr"));
    private int _groupIndex;
    private ExistsQuery _exists;
    private Query _parentQuery;

    ExistsExpr(ExistsQuery query) {
        super(query);
        this._exists = query;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        if (this._parentQuery != null) {
            return this;
        }
        this._parentQuery = query;
        super.bind(query);
        this._groupIndex = query.getDataFields();
        query.setDataFields(this._groupIndex + 1);
        this._exists.bind();
        return this;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    ArrayList<SubSelectParamExpr> getParamExprs() {
        return this._exists.getParamExprs();
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        ArrayList<SubSelectParamExpr> paramExprs = this.getParamExprs();
        long cost = 10L;
        for (int i = 0; i < paramExprs.size(); ++i) {
            cost += paramExprs.get(i).getExpr().cost(fromList);
        }
        return 2L * cost;
    }

    @Override
    void evaluate(QueryContext context) throws SQLException {
        QueryContext subcontext = QueryContext.allocate();
        ArrayList<SubSelectParamExpr> paramExprs = this.getParamExprs();
        for (int i = 0; i < paramExprs.size(); ++i) {
            paramExprs.get(i).eval(context, subcontext);
        }
        boolean exists = this._exists.exists(subcontext, context.getTransaction());
        Data data = context.getGroupData(this._groupIndex);
        data.setBoolean(exists);
        QueryContext.free(subcontext);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        Data data = context.getGroupData(this._groupIndex);
        return data.isNull();
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        Data data = context.getGroupData(this._groupIndex);
        return data.getBoolean();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("ExistsExpr[").append(this._exists).append("]").toString();
    }
}

