/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IdExpr
extends Expr {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/sql/IdExpr"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/IdExpr"));
    private FromItem _fromItem;
    private Column _column;
    private int _tableIndex = -1;

    IdExpr(FromItem fromItem, Column column) {
        this._fromItem = fromItem;
        this._column = column;
    }

    @Override
    public Class getType() {
        return this._column.getJavaType();
    }

    public Column getColumn() {
        return this._column;
    }

    @Override
    public String getName() {
        return this._column.getName();
    }

    public FromItem getFromItem() {
        return this._fromItem;
    }

    @Override
    public Table getTable() {
        return this._fromItem.getTable();
    }

    protected long lookupCost(ArrayList<FromItem> fromList) {
        if (!fromList.contains(this._fromItem)) {
            return Integer.MAX_VALUE;
        }
        if (fromList.indexOf(this._fromItem) < fromList.size() - 1) {
            return 0L;
        }
        if (this._column.isPrimaryKey()) {
            return 100L;
        }
        if (this._column.isUnique()) {
            return 10000L;
        }
        return 1000000L;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        if (!fromList.contains(this._fromItem)) {
            return Integer.MAX_VALUE;
        }
        return 10000000L;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        FromItem[] fromItems = query.getFromItems();
        for (int i = 0; i < fromItems.length; ++i) {
            if (fromItems[i] != this._fromItem) continue;
            this._tableIndex = i;
        }
        return this;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isNull(this._column);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getString(this._column);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        String value = row.getString(this._column);
        if (value == null) {
            return -1;
        }
        if (value.equals("1")) {
            return 1;
        }
        if (value.equalsIgnoreCase("t")) {
            return 1;
        }
        if (value.equalsIgnoreCase("y")) {
            return 1;
        }
        return 0;
    }

    public int evalInt(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getInteger(this._column);
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getLong(this._column);
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getDouble(this._column);
    }

    @Override
    public void evalToResult(QueryContext context, SelectResult result) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        row.evalToResult(this._column, result);
    }

    public boolean evalEqual(QueryContext context, byte[] matchBuffer) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isEqual(this._column, matchBuffer);
    }

    public boolean evalEqual(QueryContext context, String string) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isEqual(this._column, string);
    }

    public boolean equals(Object o) {
        if (o == null || !ClassLiteral.getClass((String)"com/caucho/db/sql/IdExpr").equals(o.getClass())) {
            return false;
        }
        IdExpr expr = (IdExpr)o;
        return this._fromItem == expr._fromItem && this._column == expr._column;
    }

    public String toString() {
        return new StringBuffer().append(this._fromItem.getName()).append(".").append(this._column.getName()).toString();
    }
}

