/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.AutoIncrementExpr;
import com.caucho.db.sql.DefaultExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.NullExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InsertQuery
extends Query {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/InsertQuery"));
    private Table _table;
    private ArrayList<Column> _columns;
    private ArrayList<Expr> _values;

    InsertQuery(String sql, Table table, ArrayList<Column> columns) throws SQLException {
        super(sql, null);
        this._table = table;
        this._columns = columns;
    }

    public void setValues(ArrayList<Expr> values) {
        this._values = values;
    }

    void init() throws SQLException {
        Column[] tableColumns = this._table.getColumns();
        for (int i = 0; i < tableColumns.length; ++i) {
            int j;
            Column column = tableColumns[i];
            Expr defaultExpr = column.getDefault();
            if (column.getAutoIncrement() > 0) {
                defaultExpr = new AutoIncrementExpr(column.getTable());
            }
            if (defaultExpr == null) continue;
            for (j = 0; j < this._columns.size() && this._columns.get(j) != column; ++j) {
            }
            if (j == this._columns.size()) {
                this._columns.add(column);
                this._values.add(new NullExpr());
            }
            this._values.set(j, new DefaultExpr(this._values.get(j), defaultExpr));
        }
    }

    @Override
    public void execute(QueryContext queryContext, Transaction xa) throws SQLException {
        try {
            xa.lockWrite(this._table.getLock());
            this._table.insert(queryContext, xa, this._columns, this._values);
            queryContext.setRowUpdateCount(1);
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    public String toString() {
        return "InsertQuery[]";
    }
}

