/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsNullExpr
extends Expr {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/IsNullExpr"));
    private Expr _expr;
    private boolean _isNot;

    IsNullExpr(Expr expr, boolean isNot) {
        this._expr = expr;
        this._isNot = isNot;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        return this;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._expr.subCost(fromList);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._isNot) {
            return !this._expr.isNull(context) ? 1 : 0;
        }
        return this._expr.isNull(context) ? 1 : 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return this.evalBoolean(context) == 1 ? "1" : "0";
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._expr.evalGroup(context);
    }

    public String toString() {
        if (this._isNot) {
            return new StringBuffer().append(this._expr).append(" IS NOT NULL").toString();
        }
        return new StringBuffer().append(this._expr).append(" IS NULL").toString();
    }
}

